/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.TargeterManager;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.ability.Spell;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Location;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;

public abstract class Targeter {
    private boolean canceled;
    private int maxRange;
    private int minRange;
    private int mouseX;
    private int mouseY;
    private Point mouseGridPoint;
    private boolean mouseHoverValid;
    private MouseActionList.Condition mouseActionCondition;
    private Creature parent;
    private Scriptable scriptable;
    private boolean cancelable;
    private String menuTitle;
    private AbilitySlot abilitySlot;
    private List<Point> allowedPoints;
    private List<Object> callbackArguments;
    private boolean treatAllowedPointsAsNonEmpty;
    private Runnable activateCallback;
    private Runnable cancelCallback;
    private CheckValidCallback checkValidCallback;

    public Targeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        this.parent = creature;
        this.scriptable = scriptable;
        this.cancelable = true;
        this.abilitySlot = abilitySlot;
        if (abilitySlot != null) {
            this.setMenuTitle(abilitySlot.getAbility().getName());
        }
        this.allowedPoints = new ArrayList<Point>();
        this.callbackArguments = new ArrayList<Object>();
        this.callbackArguments.add(this);
        this.treatAllowedPointsAsNonEmpty = false;
        this.activateCallback = new ActivateCallback();
        this.cancelCallback = new CancelCallback();
    }

    public Creature getParent() {
        return this.parent;
    }

    public AbilitySlot getSlot() {
        return this.abilitySlot;
    }

    public abstract boolean hasSelectedTargets();

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean bl) {
        this.cancelable = bl;
    }

    public void activate() {
        Game.areaListener.getTargeterManager().addTargeter(this);
    }

    public void setMinRange(int n) {
        this.minRange = n;
    }

    public void setMaxRange(int n) {
        this.maxRange = n;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public void addAllowedPoint(Location location) {
        this.allowedPoints.add(location.toPoint());
    }

    public void addAllowedPoints(List<Point> list) {
        for (Point point : list) {
            this.allowedPoints.add(new Point(point));
        }
        this.treatAllowedPointsAsNonEmpty = true;
    }

    public void addAllowedCreature(Creature creature) {
        this.allowedPoints.add(creature.getLocation().toPoint());
    }

    public void addAllowedCreatures(List<Entity> list) {
        for (Entity entity : list) {
            this.allowedPoints.add(entity.getLocation().toPoint());
        }
        this.treatAllowedPointsAsNonEmpty = true;
    }

    public List<Point> getAllowedPoints() {
        return this.allowedPoints;
    }

    public boolean hasAllowedPoint(Point point) {
        if (this.allowedPoints.isEmpty() && !this.treatAllowedPointsAsNonEmpty) {
            return true;
        }
        for (Point point2 : this.allowedPoints) {
            if (!point2.equals(point)) continue;
            return true;
        }
        return false;
    }

    protected void setMouseHoverValid(boolean bl) {
        this.mouseHoverValid = bl;
    }

    public boolean mouseHoverValid() {
        return this.mouseHoverValid;
    }

    protected void setMouseActionCondition(MouseActionList.Condition condition) {
        this.mouseActionCondition = condition;
    }

    public MouseActionList.Condition getMouseActionCondition() {
        return this.mouseActionCondition;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public Point getMouseGridPosition() {
        return this.mouseGridPoint;
    }

    public Point getMouseScreenPosition() {
        return AreaUtil.convertGridToScreenAndCenter(this.mouseGridPoint);
    }

    public boolean setMousePosition(Location location) {
        Point point = location.getCenteredScreenPoint();
        return this.setMousePosition(point.x, point.y, location.toPoint());
    }

    public boolean setMousePosition(Point point) {
        Point point2 = AreaUtil.convertGridToScreenAndCenter(point);
        return this.setMousePosition(point2.x, point2.y, point);
    }

    public boolean setMousePosition(int n, int n2, Point point) {
        this.mouseX = n;
        this.mouseY = n2;
        if (point.equals(this.mouseGridPoint)) {
            return false;
        }
        this.mouseGridPoint = new Point(point);
        boolean bl = Game.curCampaign.curArea.isPassable(point.x, point.y);
        boolean bl2 = bl = bl && this.parent.hasVisibilityInCurrentArea(point.x, point.y);
        if (this.parent.getFaction() == Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction"))) {
            bl = bl && Game.curCampaign.curArea.getExplored()[point.x][point.y];
        }
        int n3 = AreaUtil.distance(this.mouseGridPoint, this.parent.getLocation().toPoint());
        if (this.maxRange != 0) {
            boolean bl3 = bl = bl && n3 <= this.maxRange;
        }
        if (this.minRange != 0) {
            bl = bl && n3 >= this.minRange;
        }
        bl = bl && this.hasAllowedPoint(point);
        this.setMouseHoverValid(bl);
        return true;
    }

    public boolean draw(AnimationState animationState) {
        if (!this.parent.isPlayerFaction()) {
            return false;
        }
        Game.areaViewer.drawAnimHex(this.parent.getLocation().getX(), this.parent.getLocation().getY(), animationState);
        return true;
    }

    public void setMenuTitle(String string) {
        this.menuTitle = string;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public abstract void showMenu(int var1, int var2);

    public abstract void performLeftClickAction();

    public Runnable getCancelCallback() {
        return this.cancelCallback;
    }

    protected Runnable getActivateCallback() {
        return this.activateCallback;
    }

    public void setCancelCallback(Runnable runnable) {
        this.cancelCallback = runnable;
    }

    public void setActivateCallback(Runnable runnable) {
        this.activateCallback = runnable;
    }

    public void addCallbackArgument(Object object) {
        this.callbackArguments.add(object);
    }

    public void addCallbackArguments(Object[] objectArray) {
        for (Object object : objectArray) {
            this.callbackArguments.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.canceled = true;
        Game.mainViewer.updateInterface();
        try {
            TargeterManager targeterManager = Game.areaListener.getTargeterManager();
            synchronized (targeterManager) {
                while (Game.areaListener.getTargeterManager().getCurrentTargeter() == this) {
                    Game.areaListener.getTargeterManager().wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Thread was interrupted", interruptedException);
        }
    }

    public boolean checkValid() {
        if (this.canceled) {
            return false;
        }
        if (this.checkValidCallback != null) {
            return this.checkValidCallback.isValid();
        }
        return true;
    }

    public void setCheckValidCallback(CheckValidCallback checkValidCallback) {
        this.checkValidCallback = checkValidCallback;
    }

    public void setTitleText() {
        int n;
        Object object;
        String string = "Select Target for " + this.menuTitle;
        String string2 = null;
        if (this.abilitySlot != null && this.abilitySlot.getAbility() instanceof Spell) {
            object = (Spell)this.abilitySlot.getAbility();
            n = ((Spell)object).getSpellFailurePercentage(this.parent);
            string2 = "Base Spell Failure: " + n + '%';
        }
        object = null;
        if (this.mouseHoverValid) {
            n = Game.curCampaign.curArea.getConcealment(this.parent, this.mouseGridPoint);
            object = "Target Concealment " + n;
        }
        Game.mainViewer.setTargetTitleText(string, string2, (String)object);
    }

    public int getDesirableTargetCount() {
        if (this.abilitySlot == null) {
            return 0;
        }
        if (this.mouseHoverValid) {
            return 1;
        }
        return 0;
    }

    public int getUndesirableTargetCount() {
        return 0;
    }

    private class ActivateCallback
    implements Runnable {
        private ActivateCallback() {
        }

        @Override
        public void run() {
            Game.areaListener.getTargeterManager().endCurrentTargeter();
            Game.mainViewer.getMenu().hide();
            if (!Targeter.this.scriptable.hasFunction(ScriptFunctionType.onTargetSelect)) {
                Logger.appendToWarningLog("Scriptable " + Targeter.this.scriptable.getScriptLocation() + " runs a Targeter but does not have an onTargetSelect function.");
            }
            Targeter.this.scriptable.executeFunction(ScriptFunctionType.onTargetSelect, Targeter.this.callbackArguments.toArray());
        }
    }

    private class CancelCallback
    implements Runnable {
        private CancelCallback() {
        }

        @Override
        public void run() {
            Game.areaListener.getTargeterManager().cancelCurrentTargeter();
            Game.mainViewer.getMenu().hide();
        }
    }

    public static interface CheckValidCallback {
        public boolean isValid();
    }
}

