/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.Color;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ScriptInterface;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.Effect;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Creature;
import net.sf.hale.util.SimpleJSONObject;

public class Spell
extends Ability {
    private final boolean verbalComponent;
    private final boolean somaticComponent;
    private final boolean spellResistanceApplies;

    protected Spell(String string, String string2, String string3, SimpleJSONObject simpleJSONObject) {
        super(string, string2, string3, simpleJSONObject, false);
        this.verbalComponent = simpleJSONObject.get("hasVerbalComponent", true);
        this.somaticComponent = simpleJSONObject.get("hasSomaticComponent", true);
        this.spellResistanceApplies = simpleJSONObject.get("spellResistanceApplies", true);
    }

    public boolean hasVerbalComponent() {
        return this.verbalComponent;
    }

    public boolean hasSomaticComponent() {
        return this.somaticComponent;
    }

    public boolean spellResistanceApplies() {
        return this.spellResistanceApplies;
    }

    @Override
    public void activate(Creature creature) {
        super.activate(creature);
        ScriptInterface.performSearchChecksForCreature(creature, Game.ruleset.getValue("HideCastSpellPenalty"));
    }

    @Override
    public int getCooldown(Creature creature) {
        int n = super.getCooldown(creature);
        return n - creature.stats.get(Bonus.Type.SpellCooldown);
    }

    public boolean checkSpellFailure(Creature creature) {
        return this.checkSpellFailure(creature, 0, null);
    }

    public boolean checkSpellFailure(Creature creature, Creature creature2) {
        if (creature.getLocation().equals(creature2.getLocation()) || creature.getFaction().isFriendly(creature2)) {
            return this.checkSpellFailure(creature, 0, creature2);
        }
        int n = creature.getLocation().getArea().getConcealment(creature, creature2);
        return this.checkSpellFailure(creature, n, creature2);
    }

    public boolean checkSpellFailure(Creature creature, List<Creature> list) {
        int n = 0;
        for (Creature creature2 : list) {
            n = Math.max(n, creature.getLocation().getArea().getConcealment(creature, creature2));
        }
        return this.checkSpellFailure(creature, n, null);
    }

    public int getSpellFailurePercentage(Creature creature) {
        int n = creature.stats.getBaseSpellFailure(this.getSpellLevel(creature)) + creature.roles.getThreatenedSpellFailure();
        if (this.verbalComponent) {
            n += creature.roles.getVerbalSpellFailure();
        }
        if (this.somaticComponent) {
            n += creature.roles.getSomaticSpellFailure();
        }
        return Math.min(100, n);
    }

    private boolean checkSpellFailure(Creature creature, int n, Creature creature2) {
        int n2;
        int n3 = creature.stats.getBaseSpellFailure(this.getSpellLevel(creature));
        int n4 = Game.dice.d100();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(creature.getTemplate().getName());
        stringBuilder.append(" casts ").append(this.getName());
        if (creature2 != null) {
            stringBuilder.append(" on ").append(creature2.getName());
        }
        stringBuilder.append(" with ");
        if (this.verbalComponent) {
            n2 = creature.roles.getVerbalSpellFailure();
            if (n2 >= 0xCCCCCCC) {
                stringBuilder.append("100% failure due to silence : Failure.");
                Game.mainViewer.addMessage(stringBuilder.toString());
                Game.mainViewer.addFadeAway("Spell Failed!", creature.getLocation().getX(), creature.getLocation().getY(), new Color(-5527127));
                return false;
            }
            if (n2 > 0) {
                bl = true;
                n3 += n2;
            }
        }
        if (this.somaticComponent) {
            n3 += creature.roles.getSomaticSpellFailure();
        }
        if ((n2 = creature.roles.getThreatenedSpellFailure()) > 0) {
            bl2 = true;
            n3 += n2;
        }
        if (n > 0) {
            bl3 = true;
            n3 += n;
        }
        int n5 = (bl ? 1 : 0) + (bl2 ? 1 : 0) + (bl3 ? 1 : 0);
        stringBuilder.append(Math.max(0, n3));
        stringBuilder.append("% failure");
        if (n5 > 0) {
            stringBuilder.append(" due to ");
            if (bl) {
                stringBuilder.append("deafness");
                if (n5 == 3) {
                    stringBuilder.append(", ");
                } else if (n5 == 2) {
                    stringBuilder.append(" and ");
                }
                --n5;
            }
            if (bl3) {
                stringBuilder.append("concealment");
                if (n5 == 2) {
                    stringBuilder.append(" and ");
                }
            }
            if (bl2) {
                stringBuilder.append("threatening creatures");
            }
        }
        if (n4 <= n3) {
            stringBuilder.append(" : Failure.");
            Game.mainViewer.addFadeAway("Spell Failed!", creature.getLocation().getX(), creature.getLocation().getY(), new Color(-5527127));
        } else {
            stringBuilder.append(" : Success.");
        }
        Game.mainViewer.addMessage(stringBuilder.toString());
        return n4 > n3;
    }

    public void applyDamage(Creature creature, Creature creature2, int n, String string) {
        int n2;
        int n3 = creature.stats.get(Bonus.Type.SpellDamage) + creature.stats.get(string, Bonus.Type.DamageForSpellType);
        n = n * (100 + n3) / 100;
        int n4 = Math.max(0, this.spellResistanceApplies ? creature2.stats.get(Bonus.Type.SpellResistance) : 0);
        if (n4 != 0) {
            Game.mainViewer.addMessage("blue", creature2.getTemplate().getName() + "'s Spell Resistance absorbs " + n4 + "% of the spell.");
        }
        if ((n2 = 100 - n4) < 0) {
            n2 = 0;
        }
        n = n * n2 / 100;
        creature2.takeDamage(n, string);
        if (creature.getFaction().isHostile(creature2) && creature2.getEncounter() != null) {
            creature2.getEncounter().checkAddHostile(creature);
        }
    }

    public void applyHealing(Creature creature, Creature creature2, int n) {
        int n2 = creature.stats.get(Bonus.Type.SpellHealing);
        n = n * (100 + n2) / 100;
        int n3 = Math.max(0, this.spellResistanceApplies ? creature2.stats.get(Bonus.Type.SpellResistance) : 0);
        if (n3 == 0) {
            creature2.healDamage(n);
        } else {
            int n4 = Math.min(0, 100 - n3);
            creature2.healDamage(n * n4 / 100);
        }
    }

    @Override
    public void setSpellDuration(Effect effect, Creature creature) {
        int n = effect.getRoundsRemaining();
        int n2 = creature.stats.get(Bonus.Type.SpellDuration);
        n = n * (100 + n2) / 100;
        if (this.spellResistanceApplies) {
            int n3 = Math.min(100, Math.max(0, 100 - effect.getTarget().getSpellResistance()));
            n = n * n3 / 100;
        }
        effect.setDuration(n);
    }

    public int getCheckDifficulty(Creature creature) {
        return 50 + (creature.stats.getSpellCastingAttribute() - 10) * 2 + 3 * creature.stats.getCasterLevel();
    }

    @Override
    public void appendDetails(StringBuilder stringBuilder, Creature creature) {
        stringBuilder.append("<p><span style=\"font-family: medium-blue\">Spell</span></p>");
        super.appendDetails(stringBuilder, creature);
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle; margin-top: 1em;\">");
        stringBuilder.append("<tr><td style=\"width: 10ex;\">");
        stringBuilder.append("Spell Level</td><td style=\"font-family: medium-blue\">");
        stringBuilder.append(this.getSpellLevel(creature)).append("</td></tr>");
        stringBuilder.append("</table>");
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle;\">");
        if (this.spellResistanceApplies) {
            stringBuilder.append("<tr><td>Affected by ");
        } else {
            stringBuilder.append("<tr><td>Ignores ");
        }
        stringBuilder.append("<span style=\"font-family: medium-red\">Spell Resistance</span></td></tr>");
        stringBuilder.append("</table>");
    }
}

