/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.HashSet;
import java.util.Set;
import javax.script.ScriptException;
import net.sf.hale.Game;
import net.sf.hale.ability.DelayedScriptCallback;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.JSEngine;
import net.sf.hale.util.Logger;

public class Scriptable
implements Saveable {
    private final String scriptLocation;
    private final String script;
    private final boolean inline;
    private final Set<ScriptFunctionType> scriptFunctions;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        if (this.inline) {
            jSONOrderedObject.put("scriptContents", this.script);
        }
        if (this.scriptLocation != null) {
            jSONOrderedObject.put("scriptLocation", this.scriptLocation);
        }
        return jSONOrderedObject;
    }

    public Scriptable(String string, String string2, boolean bl) {
        this.scriptFunctions = new HashSet<ScriptFunctionType>();
        this.script = string;
        this.scriptLocation = string2;
        this.inline = bl;
        if (string != null) {
            JSEngine jSEngine = Game.scriptEngineManager.getEngine();
            try {
                jSEngine.eval(string);
            }
            catch (ScriptException scriptException) {
                Logger.appendToErrorLog("Error preparsing script at " + string2, scriptException);
            }
            for (ScriptFunctionType scriptFunctionType : ScriptFunctionType.values()) {
                if (!jSEngine.hasFunction(scriptFunctionType.toString())) continue;
                this.scriptFunctions.add(scriptFunctionType);
            }
            jSEngine.release();
        }
    }

    public Scriptable(Scriptable scriptable) {
        this.script = scriptable.script;
        this.scriptLocation = scriptable.scriptLocation;
        this.inline = scriptable.inline;
        this.scriptFunctions = new HashSet<ScriptFunctionType>(scriptable.scriptFunctions);
    }

    public int getNumberOfScriptFunctionTypes() {
        return this.scriptFunctions.size();
    }

    public boolean hasFunction(String string) {
        ScriptFunctionType scriptFunctionType = ScriptFunctionType.valueOf(string);
        return this.scriptFunctions.contains((Object)scriptFunctionType);
    }

    public boolean hasFunction(ScriptFunctionType scriptFunctionType) {
        return this.scriptFunctions.contains((Object)scriptFunctionType);
    }

    public Object executeFunction(ScriptFunctionType scriptFunctionType, Object ... objectArray) {
        if (this.hasFunction(scriptFunctionType)) {
            return this.executeFunction(scriptFunctionType.toString(), objectArray);
        }
        return null;
    }

    public Object executeFunction(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.executeFunction(string, objectArray);
    }

    public Object executeFunction(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.executeFunction(string, objectArray);
    }

    public Object executeFunction(String string, Object ... objectArray) {
        Object object = null;
        JSEngine jSEngine = Game.scriptEngineManager.getEngine();
        try {
            jSEngine.eval(this.script);
            object = jSEngine.invokeFunction(string, Scriptable.createArgumentList(objectArray));
        }
        catch (ScriptException scriptException) {
            Logger.appendToErrorLog("Error invoking function " + string + " for script " + this.scriptLocation, scriptException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Logger.appendToErrorLog("Error invoking function " + string + " for script " + this.scriptLocation, noSuchMethodException);
        }
        jSEngine.release();
        return object;
    }

    private static Object[] createArgumentList(Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = Game.scriptInterface;
        int n = 1;
        Object[] objectArray3 = objectArray;
        int n2 = objectArray3.length;
        for (int i = 0; i < n2; ++i) {
            Object object;
            objectArray2[n] = object = objectArray3[i];
            ++n;
        }
        return objectArray2;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public DelayedScriptCallback createDelayedCallback(String string) {
        return new DelayedScriptCallback(this, string);
    }
}

