/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.ability.Targeter;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Creature;
import net.sf.hale.util.Point;
import net.sf.hale.widgets.RightClickMenu;

public class ListTargeter
extends Targeter {
    private int numberOfSelections = 1;
    private boolean uniqueSelectionsRequired = false;
    private List<Point> selectedPoints = new ArrayList<Point>();

    public ListTargeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        super(creature, scriptable, abilitySlot);
    }

    @Override
    public boolean hasSelectedTargets() {
        return this.numberOfSelections == this.selectedPoints.size();
    }

    public void setNumberOfSelections(int n) {
        if (n < 1) {
            n = 1;
        }
        this.numberOfSelections = n;
    }

    public int getNumberOfSelections() {
        return this.numberOfSelections;
    }

    public Point getSelected() {
        if (this.selectedPoints.size() < 1) {
            return null;
        }
        return this.selectedPoints.get(0);
    }

    public Creature getSelectedCreature() {
        if (this.selectedPoints.size() < 1) {
            return null;
        }
        return Game.curCampaign.curArea.getCreatureAtGridPoint(this.selectedPoints.get(0));
    }

    public Point getSelected(int n) {
        if (this.selectedPoints.size() < n + 1) {
            return null;
        }
        return this.selectedPoints.get(n);
    }

    public List<Creature> getSelectedCreatures() {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        for (Point point : this.selectedPoints) {
            Creature creature = Game.curCampaign.curArea.getCreatureAtGridPoint(point);
            if (creature == null) continue;
            arrayList.add(creature);
        }
        return arrayList;
    }

    public void setUniqueSelectionsRequired(boolean bl) {
        this.uniqueSelectionsRequired = bl;
    }

    private boolean canSelectPoint(Point point) {
        if (!this.hasAllowedPoint(point)) {
            return false;
        }
        if (this.uniqueSelectionsRequired) {
            for (Point point2 : this.selectedPoints) {
                if (!point2.equals(point)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setMousePosition(int n, int n2, Point point) {
        if (!super.setMousePosition(n, n2, point)) {
            return false;
        }
        MouseActionList.Condition condition = MouseActionList.Condition.Cancel;
        if (this.canSelectPoint(point)) {
            int n3 = this.numberOfSelections - this.selectedPoints.size();
            if (n3 == 1) {
                condition = MouseActionList.Condition.TargetSelect;
            } else if (n3 > 1) {
                condition = MouseActionList.Condition.TargetSelectAdd;
            }
        }
        this.setMouseActionCondition(condition);
        return true;
    }

    @Override
    public void showMenu(int n, int n2) {
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.clear();
        rightClickMenu.setPosition(n, n2);
        rightClickMenu.addMenuLevel(this.getMenuTitle());
        if (this.canSelectPoint(this.getMouseGridPosition())) {
            int n3 = this.numberOfSelections - this.selectedPoints.size();
            if (n3 == 1) {
                Button button = new Button("Select & Activate");
                button.addCallback((Runnable)new AddPointCallback());
                button.addCallback(this.getActivateCallback());
                rightClickMenu.addButton(button);
            } else if (n3 > 1) {
                Button button = new Button("Select");
                button.addCallback((Runnable)new AddPointCallback());
                rightClickMenu.addButton(button);
                if (!this.uniqueSelectionsRequired) {
                    button = new Button("Select All & Activate");
                    AddAllCallback addAllCallback = new AddAllCallback(n3);
                    button.addCallback((Runnable)addAllCallback);
                    button.addCallback(this.getActivateCallback());
                    rightClickMenu.addButton(button);
                }
            }
        }
        if (this.isCancelable()) {
            Button button = new Button("Cancel");
            button.addCallback(this.getCancelCallback());
            rightClickMenu.addButton(button);
        }
        rightClickMenu.show();
    }

    @Override
    public void performLeftClickAction() {
        if (!this.canSelectPoint(this.getMouseGridPosition())) {
            return;
        }
        int n = this.numberOfSelections - this.selectedPoints.size();
        if (n == 1) {
            this.selectedPoints.add(new Point(this.getMouseGridPosition()));
            this.getActivateCallback().run();
        } else if (n > 1) {
            this.selectedPoints.add(new Point(this.getMouseGridPosition()));
        }
    }

    @Override
    public boolean draw(AnimationState animationState) {
        if (!super.draw(animationState)) {
            return false;
        }
        for (Point point : this.getAllowedPoints()) {
            Game.areaViewer.drawGreenHex(point, animationState);
        }
        return true;
    }

    private class AddAllCallback
    implements Runnable {
        private int selections;

        private AddAllCallback(int n) {
            this.selections = n;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.selections; ++i) {
                ListTargeter.this.selectedPoints.add(new Point(ListTargeter.this.getMouseGridPosition()));
            }
        }
    }

    private class AddPointCallback
    implements Runnable {
        private AddPointCallback() {
        }

        @Override
        public void run() {
            ListTargeter.this.selectedPoints.add(new Point(ListTargeter.this.getMouseGridPosition()));
        }
    }
}

