/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.AreaTargeter;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class LineTargeter
extends AreaTargeter {
    private Point gridEnd;
    private Point gridOrigin;
    private Point screenOrigin;
    private int lineGridLength = 0;
    private double lineAngle;
    private double lineLength;
    private boolean stopLineAtCreature = false;
    private boolean stopLineAtImpassable = false;

    public LineTargeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        super(creature, scriptable, abilitySlot);
    }

    public void setStopLineAtImpassable(boolean bl) {
        this.stopLineAtImpassable = bl;
    }

    public void setStopLineAtCreature(boolean bl) {
        this.stopLineAtCreature = bl;
    }

    public void setOrigin(Location location) {
        this.setOrigin(location.toPoint());
    }

    public void setOrigin(Point point) {
        this.gridOrigin = new Point(point);
        this.screenOrigin = AreaUtil.convertGridToScreenAndCenter(this.gridOrigin);
    }

    public Point getEndPoint() {
        return this.gridEnd;
    }

    public void setForceLineLength(int n) {
        this.lineGridLength = n;
    }

    @Override
    public boolean draw(AnimationState animationState) {
        if (!super.draw(animationState)) {
            return false;
        }
        double d = 72.0 * Math.cos(this.lineAngle) / 20.0;
        double d2 = -72.0 * Math.sin(this.lineAngle) / 20.0;
        double d3 = this.lineLength * 72.0 * Math.sin(this.lineAngle);
        double d4 = this.lineLength * 72.0 * Math.cos(this.lineAngle);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)((double)this.screenOrigin.x + d), (double)((double)this.screenOrigin.y + d2));
        GL11.glVertex2d((double)((double)this.screenOrigin.x + d3 + d), (double)((double)this.screenOrigin.y + d4 + d2));
        GL11.glVertex2d((double)((double)this.screenOrigin.x - d), (double)((double)this.screenOrigin.y - d2));
        GL11.glVertex2d((double)((double)this.screenOrigin.x + d3 - d), (double)((double)this.screenOrigin.y + d4 - d2));
        GL11.glEnd();
        GL11.glEnable((int)3553);
        return true;
    }

    @Override
    protected boolean updateMouseStateOnlyWhenGridPointChanges() {
        return false;
    }

    @Override
    protected void computeAffectedPoints(int n, int n2, Point point) {
        double d;
        double d2;
        List<Point> list = this.getAffectedPoints();
        this.lineAngle = AreaUtil.angle(this.screenOrigin.x, this.screenOrigin.y, n, n2);
        if (this.lineGridLength == 0) {
            d2 = n;
            d = n2;
        } else {
            d2 = (double)this.screenOrigin.x + (double)(this.lineGridLength * 72) * Math.sin(this.lineAngle);
            d = (double)this.screenOrigin.y + (double)(this.lineGridLength * 72) * Math.cos(this.lineAngle);
        }
        ArrayList<Point> arrayList = AreaUtil.findIntersectingHexes(this.screenOrigin.x, this.screenOrigin.y, (int)d2, (int)d);
        this.gridEnd = this.gridOrigin;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Point point2;
            this.gridEnd = point2 = (Point)object.next();
            if (!Game.curCampaign.curArea.isTransparent(point2.x, point2.y) || this.stopLineAtImpassable && !Game.curCampaign.curArea.isPassable(point2.x, point2.y)) break;
            list.add(point2);
            if (!this.stopLineAtCreature || Game.curCampaign.curArea.getCreatureAtGridPoint(point2) == null) continue;
            break;
        }
        object = AreaUtil.convertGridToScreen(this.gridEnd);
        ((Point)object).x += 36;
        ((Point)object).y += 36;
        this.lineLength = Math.sqrt(AreaUtil.euclideanDistance2(this.screenOrigin.x, this.screenOrigin.y, ((Point)object).x, ((Point)object).y)) / 72.0 - 0.5;
        int n3 = AreaUtil.distance(this.gridOrigin, this.gridEnd);
        if (n3 < this.getMinRange()) {
            this.setMouseHoverValid(false);
        }
        if (this.lineGridLength > 0) {
            this.setMouseHoverValid(true);
        }
    }
}

