/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EffectTarget;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Spell;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.entity.Entity;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class EntityEffectSet
implements Iterable<Effect>,
Saveable {
    private final List<Aura> auras = new ArrayList<Aura>();
    private final List<Effect> effectsNoActiveScript = new ArrayList<Effect>();
    private final List<Effect> effectsWithActiveScript = new ArrayList<Effect>();

    @Override
    public JSONOrderedObject save() {
        Object[] objectArray;
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        if (this.effectsNoActiveScript.size() > 0) {
            objectArray = new ArrayList();
            for (Effect object : this.effectsNoActiveScript) {
                if (object.getRoundsRemaining() == 0 && !object.removeOnDeactivate()) continue;
                objectArray.add(object.save());
            }
            if (objectArray.size() > 0) {
                jSONOrderedObject.put("noActiveScript", objectArray.toArray());
            }
        }
        if (this.effectsWithActiveScript.size() > 0) {
            objectArray = new ArrayList();
            for (Effect effect : this.effectsWithActiveScript) {
                if (effect.getRoundsRemaining() == 0 && !effect.removeOnDeactivate()) continue;
                objectArray.add(effect.save());
            }
            if (objectArray.size() > 0) {
                jSONOrderedObject.put("withActiveScript", objectArray.toArray());
            }
        }
        if (this.auras.size() > 0) {
            objectArray = new Object[this.auras.size()];
            int n = 0;
            for (Aura aura : this.auras) {
                objectArray[n] = SaveGameUtil.getRef(aura);
                ++n;
            }
            jSONOrderedObject.put("auras", objectArray);
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler, EffectTarget effectTarget) throws LoadGameException {
        String string;
        Effect effect;
        SimpleJSONObject simpleJSONObject2;
        SimpleJSONArray simpleJSONArray;
        this.clear();
        if (simpleJSONObject.containsKey("noActiveScript")) {
            simpleJSONArray = simpleJSONObject.getArray("noActiveScript");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                simpleJSONObject2 = simpleJSONArrayEntry.getObject();
                effect = Effect.load(simpleJSONObject2, referenceHandler, effectTarget);
                string = simpleJSONObject2.get("ref", null);
                referenceHandler.add(string, effect);
                this.effectsNoActiveScript.add(effect);
            }
        }
        if (simpleJSONObject.containsKey("withActiveScript")) {
            simpleJSONArray = simpleJSONObject.getArray("withActiveScript");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                simpleJSONObject2 = simpleJSONArrayEntry.getObject();
                effect = Effect.load(simpleJSONObject2, referenceHandler, effectTarget);
                string = simpleJSONObject2.get("ref", null);
                referenceHandler.add(string, effect);
                this.effectsWithActiveScript.add(effect);
            }
        }
        if (simpleJSONObject.containsKey("auras")) {
            simpleJSONArray = simpleJSONObject.getArray("auras");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                this.auras.add((Aura)referenceHandler.getEffect(simpleJSONArrayEntry.getString()));
            }
        }
    }

    public EntityEffectSet() {
    }

    public EntityEffectSet(EntityEffectSet entityEffectSet, EffectTarget effectTarget) {
        this();
        for (Effect effect : entityEffectSet.effectsNoActiveScript) {
            this.effectsNoActiveScript.add(new Effect(effect, effectTarget));
        }
        for (Effect effect : entityEffectSet.effectsWithActiveScript) {
            this.effectsWithActiveScript.add(new Effect(effect, effectTarget));
        }
        for (Aura aura : entityEffectSet.auras) {
            this.auras.add(new Aura(aura, effectTarget));
        }
    }

    public synchronized void clear() {
        this.auras.clear();
        this.effectsNoActiveScript.clear();
        this.effectsWithActiveScript.clear();
    }

    public int size() {
        return this.effectsWithActiveScript.size() + this.effectsNoActiveScript.size();
    }

    public synchronized void moveAuras() {
        for (Aura aura : this.auras) {
            Game.curCampaign.curArea.moveAura(aura, aura.getCurrentAffectedPoints());
        }
    }

    public synchronized void elapseRounds(Entity entity, int n) {
        this.elapseRounds(this.effectsNoActiveScript, entity, n);
        this.elapseRounds(this.effectsWithActiveScript, entity, n);
    }

    private void elapseRounds(List<Effect> list, Entity entity, int n) {
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            Effect effect = list.get(i);
            boolean bl2 = bl = effect.getRoundsRemaining() != 0;
            if (effect.getSlot() != null) continue;
            effect.elapseRounds(n);
            if (!bl || effect.getRoundsRemaining() >= 1) continue;
            entity.removeEffect(effect);
            --i;
        }
    }

    public synchronized List<Effect> getDispellableEffects() {
        ArrayList<Effect> arrayList = new ArrayList<Effect>();
        for (Effect effect : this.effectsNoActiveScript) {
            if (!this.checkDispellable(effect)) continue;
            arrayList.add(effect);
        }
        for (Effect effect : this.effectsWithActiveScript) {
            if (!this.checkDispellable(effect)) continue;
            arrayList.add(effect);
        }
        return arrayList;
    }

    private boolean checkDispellable(Effect effect) {
        if (effect.getSlot() == null) {
            return false;
        }
        Ability ability = effect.getSlot().getAbility();
        if (!ability.isActivateable()) {
            return false;
        }
        if (ability.getSpellLevel() <= 0) {
            return false;
        }
        if (!(ability instanceof Spell)) {
            return false;
        }
        Spell spell = (Spell)ability;
        return spell.spellResistanceApplies();
    }

    public synchronized Effect getEffectCreatedBySlot(String string) {
        for (Effect effect : this.effectsNoActiveScript) {
            if (effect.getSlot() == null || !string.equals(effect.getSlot().getAbilityID())) continue;
            return effect;
        }
        for (Effect effect : this.effectsWithActiveScript) {
            if (effect.getSlot() == null || !string.equals(effect.getSlot().getAbilityID())) continue;
            return effect;
        }
        return null;
    }

    public synchronized void add(Effect effect, boolean bl) {
        if (effect instanceof Aura) {
            Aura aura = (Aura)effect;
            this.auras.add(aura);
            if (bl) {
                Game.curCampaign.curArea.applyEffect(aura, aura.getCurrentAffectedPoints());
            }
        }
        if (effect.getNumberOfScriptFunctionTypes() == 0) {
            this.effectsNoActiveScript.add(effect);
        } else {
            this.effectsWithActiveScript.add(effect);
        }
        this.executeOnAll(ScriptFunctionType.onEffectApplied, effect);
    }

    public synchronized void remove(Effect effect) {
        if (effect instanceof Aura) {
            Aura aura = (Aura)effect;
            this.auras.remove(aura);
            Game.curCampaign.curArea.removeEffect(aura);
        }
        if (effect.getNumberOfScriptFunctionTypes() == 0) {
            this.effectsNoActiveScript.remove(effect);
        } else {
            this.effectsWithActiveScript.remove(effect);
        }
    }

    public synchronized void executeOnAllAuraChildren(ScriptFunctionType scriptFunctionType) {
        for (Aura aura : this.auras) {
            for (Effect effect : aura.getChildEffects()) {
                aura.executeFunction(scriptFunctionType, effect.getTarget(), aura);
            }
        }
    }

    public synchronized void executeOnAll(ScriptFunctionType scriptFunctionType, Object ... objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i];
        }
        HashSet<Effect> hashSet = new HashSet<Effect>();
        for (int i = 0; i < this.effectsWithActiveScript.size(); ++i) {
            Effect effect = this.effectsWithActiveScript.get(i);
            if (hashSet.contains(effect)) continue;
            int n = this.effectsWithActiveScript.size();
            objectArray2[objectArray2.length - 1] = effect;
            effect.executeFunction(scriptFunctionType, objectArray2);
            hashSet.add(effect);
            int n2 = this.effectsWithActiveScript.size();
            if (n2 == n) continue;
            i = 0;
        }
    }

    public synchronized void offsetAnimationPositions(int n, int n2) {
        for (Effect effect : this.effectsNoActiveScript) {
            effect.offsetAnimationPositions(n, n2);
        }
        for (Effect effect : this.effectsWithActiveScript) {
            effect.offsetAnimationPositions(n, n2);
        }
    }

    public synchronized void startAnimations() {
        for (Effect effect : this.effectsNoActiveScript) {
            effect.startAnimations();
        }
        for (Effect effect : this.effectsWithActiveScript) {
            effect.startAnimations();
        }
    }

    public synchronized void endAllAnimations() {
        for (Effect effect : this.effectsNoActiveScript) {
            effect.endAnimations();
        }
        for (Effect effect : this.effectsWithActiveScript) {
            effect.endAnimations();
        }
    }

    public BonusList getBonusesOfType(String string) {
        return this.getBonusesOfType(Bonus.Type.valueOf(string), true);
    }

    public BonusList getBonusesOfType(Bonus.Type type) {
        return this.getBonusesOfType(type, true);
    }

    public BonusList getPenaltiesOfType(String string) {
        return this.getBonusesOfType(Bonus.Type.valueOf(string), false);
    }

    public BonusList getPenaltiesOfType(Bonus.Type type) {
        return this.getBonusesOfType(type, false);
    }

    public synchronized List<Effect> getEffectsWithBonusesOfType(Bonus.Type type) {
        ArrayList<Effect> arrayList = new ArrayList<Effect>();
        block0: for (Effect effect : this.effectsNoActiveScript) {
            for (Bonus bonus : effect.getBonuses()) {
                if (bonus.getType() != type) continue;
                arrayList.add(effect);
                continue block0;
            }
        }
        block2: for (Effect effect : this.effectsWithActiveScript) {
            for (Bonus bonus : effect.getBonuses()) {
                if (bonus.getType() != type) continue;
                arrayList.add(effect);
                continue block2;
            }
        }
        return arrayList;
    }

    public synchronized boolean hasPenaltiesOfTypes(String[] stringArray) {
        HashSet<Bonus.Type> hashSet = new HashSet<Bonus.Type>();
        for (String object : stringArray) {
            hashSet.add(Bonus.Type.valueOf(object));
        }
        for (Effect effect : this.effectsNoActiveScript) {
            for (Bonus bonus : effect.getBonuses()) {
                if (!hashSet.contains((Object)bonus.getType()) || bonus.getValue() >= 0) continue;
                return true;
            }
        }
        for (Effect effect : this.effectsWithActiveScript) {
            for (Bonus bonus : effect.getBonuses()) {
                if (!hashSet.contains((Object)bonus.getType()) || bonus.getValue() >= 0) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized BonusList getBonusesOfType(Bonus.Type type, boolean bl) {
        BonusList bonusList = new BonusList();
        for (Effect effect : this.effectsNoActiveScript) {
            this.addBonusesOfTypeToList(effect, bonusList, type, bl);
        }
        for (Effect effect : this.effectsWithActiveScript) {
            this.addBonusesOfTypeToList(effect, bonusList, type, bl);
        }
        return bonusList;
    }

    private void addBonusesOfTypeToList(Effect effect, BonusList bonusList, Bonus.Type type, boolean bl) {
        for (Bonus bonus : effect.getBonuses()) {
            if (bonus.getType() != type) continue;
            if (bl && bonus.getValue() >= 0) {
                bonusList.add(bonus);
                continue;
            }
            if (bl || bonus.getValue() > 0) continue;
            bonusList.add(bonus);
        }
    }

    @Override
    public java.util.Iterator<Effect> iterator() {
        return new Iterator();
    }

    private class Iterator
    implements java.util.Iterator<Effect> {
        private java.util.Iterator<Effect> iter;
        private boolean secondIterUsed;

        private Iterator() {
            this.iter = EntityEffectSet.this.effectsNoActiveScript.iterator();
            this.secondIterUsed = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.iter.hasNext()) {
                if (!this.secondIterUsed) {
                    this.iter = EntityEffectSet.this.effectsWithActiveScript.iterator();
                    this.secondIterUsed = true;
                    return this.iter.hasNext();
                }
                return false;
            }
            return true;
        }

        @Override
        public Effect next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

