/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.HasScriptState;
import net.sf.hale.ScriptState;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.EffectTarget;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusList;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.particle.Animated;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Effect
extends Scriptable
implements Saveable,
HasScriptState {
    private String title;
    private int duration;
    private boolean removeOnDeactivate;
    private boolean hasDescription;
    private List<Effect> childEffects;
    private EffectTarget target;
    private AbilitySlot slot;
    private BonusList bonuses;
    private List<Icon> icons;
    private List<Animated> animations;
    private ScriptState scriptState;

    @Override
    public JSONOrderedObject save() {
        Object object;
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("ref", SaveGameUtil.getRef(this));
        if (this.title != null) {
            jSONOrderedObject.put("title", this.title);
        }
        if (this.icons.size() > 0) {
            object = new Object[this.icons.size()];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                object[i] = this.icons.get(i).save();
            }
            jSONOrderedObject.put("icons", object);
        }
        jSONOrderedObject.put("duration", this.duration);
        jSONOrderedObject.put("removeOnDeactivate", this.removeOnDeactivate);
        jSONOrderedObject.put("hasDescription", this.hasDescription);
        if (this.childEffects.size() > 0) {
            object = new ArrayList();
            for (Effect object2 : this.childEffects) {
                if (!object2.getTarget().isValidEffectTarget()) continue;
                object.add(SaveGameUtil.getRef(object2));
            }
            jSONOrderedObject.put("children", object.toArray());
        }
        if (this.slot != null) {
            jSONOrderedObject.put("slot", SaveGameUtil.getRef(this.slot));
        }
        if (this.bonuses.size() > 0) {
            jSONOrderedObject.put("bonuses", this.bonuses.save());
        }
        int n = 0;
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.animations.size()];
        for (Animated animated : this.animations) {
            jSONOrderedObjectArray[n] = animated.save();
            ++n;
        }
        if (jSONOrderedObjectArray.length != 0) {
            jSONOrderedObject.put("animations", jSONOrderedObjectArray);
        }
        if (!this.scriptState.isEmpty()) {
            jSONOrderedObject.put("scriptState", this.scriptState.save());
        }
        return jSONOrderedObject;
    }

    public static Effect load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler, EffectTarget effectTarget) throws LoadGameException {
        Object object;
        Iterable<SimpleJSONArrayEntry> iterable;
        Effect effect = simpleJSONObject.containsKey("isAura") && simpleJSONObject.get("isAura", false) ? Aura.load(simpleJSONObject, referenceHandler) : (simpleJSONObject.containsKey("scriptLocation") ? new Effect(simpleJSONObject.get("scriptLocation", null)) : new Effect());
        effect.setTarget(effectTarget);
        referenceHandler.add(simpleJSONObject.get("ref", null), effect);
        if (simpleJSONObject.containsKey("title")) {
            effect.title = simpleJSONObject.get("title", null);
        }
        if (simpleJSONObject.containsKey("icons")) {
            iterable = simpleJSONObject.getArray("icons");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : iterable) {
                effect.icons.add(IconFactory.createIcon(simpleJSONArrayEntry.getObject()));
            }
        }
        effect.duration = simpleJSONObject.get("duration", 0);
        effect.removeOnDeactivate = simpleJSONObject.get("removeOnDeactivate", false);
        effect.hasDescription = simpleJSONObject.get("hasDescription", false);
        if (simpleJSONObject.containsKey("children")) {
            iterable = simpleJSONObject.getArray("children");
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : iterable) {
                object = simpleJSONArrayEntry.getString();
                referenceHandler.addChildEffect(effect, (String)object);
            }
        }
        if (simpleJSONObject.containsKey("slot")) {
            referenceHandler.addSlotReference(effect, simpleJSONObject.get("slot", null));
        }
        iterable = new BonusList();
        effect.bonuses = iterable;
        if (simpleJSONObject.containsKey("bonuses")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("bonuses")) {
                object = (Bonus)SaveGameUtil.loadObject(simpleJSONArrayEntry.getObject());
                ((BonusList)iterable).add((Bonus)object);
            }
        }
        if (simpleJSONObject.containsKey("animations")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("animations")) {
                effect.animations.add((Animated)SaveGameUtil.loadObject(simpleJSONArrayEntry.getObject()));
            }
        }
        if (simpleJSONObject.containsKey("scriptState")) {
            effect.scriptState.load(simpleJSONObject.getObject("scriptState"));
        }
        return effect;
    }

    public Effect() {
        super(null, null, false);
        this.bonuses = new BonusList();
        this.title = "Effect";
        this.hasDescription = true;
        this.icons = new ArrayList<Icon>();
        this.animations = new ArrayList<Animated>(1);
        this.childEffects = new ArrayList<Effect>(1);
        this.scriptState = new ScriptState();
    }

    public Effect(String string) {
        super(ResourceManager.getScriptResourceAsString(string), string, false);
        this.bonuses = new BonusList();
        this.hasDescription = true;
        this.icons = new ArrayList<Icon>();
        this.animations = new ArrayList<Animated>(1);
        this.childEffects = new ArrayList<Effect>(1);
        this.scriptState = new ScriptState();
    }

    public Effect(Effect effect, EffectTarget effectTarget) {
        super(effect);
        this.target = effectTarget;
        this.bonuses = new BonusList(effect.bonuses);
        this.duration = effect.duration;
        this.title = effect.title;
        this.icons = new ArrayList<Icon>(effect.icons);
        this.scriptState = new ScriptState(effect.scriptState);
        this.animations = new ArrayList<Animated>(1);
        this.childEffects = new ArrayList<Effect>(1);
    }

    public void setHasDescription(boolean bl) {
        this.hasDescription = bl;
    }

    public void addNegativeIcon(String string) {
        this.icons.add(IconFactory.createIcon(string, Color.RED));
    }

    public void addPositiveIcon(String string) {
        this.icons.add(IconFactory.createIcon(string, Color.AQUA));
    }

    public void addIcon(String string) {
        this.icons.add(IconFactory.createIcon(string));
    }

    public void getIcons(Collection<Icon> collection) {
        collection.addAll(this.icons);
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public BonusList getBonuses() {
        return this.bonuses;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public void elapseRounds(int n) {
        if (this.duration != 0) {
            this.duration -= n;
        }
        this.executeFunction(ScriptFunctionType.onRoundElapsed, this);
    }

    public int getRoundsRemaining() {
        return this.duration;
    }

    public void setRemoveOnDeactivate(boolean bl) {
        this.removeOnDeactivate = bl;
    }

    public boolean removeOnDeactivate() {
        return this.removeOnDeactivate;
    }

    public EffectTarget getTarget() {
        return this.target;
    }

    public void setTarget(EffectTarget effectTarget) {
        this.target = effectTarget;
        if (this.slot != null) {
            this.slot.getAbility().setSpellDuration(this, this.slot.getParent());
        }
    }

    public void removeChildEffect(Effect effect) {
        this.childEffects.remove(effect);
    }

    public void addChildEffect(Effect effect) {
        this.childEffects.add(effect);
    }

    public List<Effect> getChildEffects() {
        ArrayList<Effect> arrayList = new ArrayList<Effect>();
        for (Effect effect : this.childEffects) {
            arrayList.add(effect);
        }
        return arrayList;
    }

    public Effect getChildEffectWithTarget(EffectTarget effectTarget) {
        for (Effect effect : this.childEffects) {
            if (effect.getTarget() != effectTarget) continue;
            return effect;
        }
        return null;
    }

    public List<Effect> getChildEffectsWithTarget(EffectTarget effectTarget) {
        ArrayList<Effect> arrayList = new ArrayList<Effect>();
        for (Effect effect : this.childEffects) {
            if (effect.getTarget() != effectTarget) continue;
            arrayList.add(effect);
        }
        return arrayList;
    }

    public void setSlot(AbilitySlot abilitySlot) {
        this.slot = abilitySlot;
    }

    public AbilitySlot getSlot() {
        return this.slot;
    }

    public void addAnimation(Animated animated) {
        this.animations.add(animated);
    }

    public void startAnimations() {
        for (Animated animated : this.animations) {
            Game.particleManager.add(animated);
        }
    }

    public void endAnimations() {
        for (Animated animated : this.animations) {
            animated.setDuration(0.0f);
        }
    }

    public void offsetAnimationPositions(float f, float f2) {
        for (Animated animated : this.animations) {
            animated.offsetPosition(f, f2);
        }
    }

    public void appendDescription(StringBuilder stringBuilder) {
        if (this.duration == 0 && !this.removeOnDeactivate) {
            return;
        }
        if (!this.hasDescription) {
            return;
        }
        stringBuilder.append("<div style=\"margin-top: 1em;\">");
        stringBuilder.append("<span style=\"font-family: medium;\">");
        stringBuilder.append(this.title).append("</span>");
        if (this.duration != 0) {
            stringBuilder.append("<p>(<span style=\"font-family: blue;\">");
            stringBuilder.append(this.duration).append("</span> Rounds Remaining)</p>");
        }
        stringBuilder.append(this.bonuses.getDescription());
        stringBuilder.append("</div>");
    }

    @Override
    public void put(String string, Object object) {
        this.scriptState.put(string, object);
    }

    @Override
    public Object get(String string) {
        return this.scriptState.get(string);
    }
}

