/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.util.Logger;

public class DelayedScriptCallback
extends Thread {
    private final Scriptable scriptable;
    private long delayInMillis;
    private String callbackFunction;
    private final List<Object> arguments;

    public DelayedScriptCallback(Scriptable scriptable, String string) {
        this.scriptable = scriptable;
        this.delayInMillis = 0L;
        this.callbackFunction = string;
        this.arguments = new ArrayList<Object>(5);
    }

    public void setDelay(float f) {
        this.delayInMillis = (long)(1000.0f * f);
    }

    public void addArgument(Object object) {
        this.arguments.add(object);
    }

    public void addArguments(Object[] objectArray) {
        for (Object object : objectArray) {
            this.arguments.add(object);
        }
    }

    @Override
    public void run() {
        if (this.delayInMillis != 0L) {
            try {
                Thread.sleep(this.delayInMillis);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        try {
            this.scriptable.executeFunction(this.callbackFunction, this.arguments.toArray());
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error while executing script " + this.scriptable.getScriptLocation() + " function " + this.callbackFunction, exception);
        }
    }
}

