/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.AIAbilitySlotSet;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.entity.Creature;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class CreatureAbilitySet
implements Saveable {
    private List<Listener> listeners;
    private final Creature parent;
    private final Map<String, Map<String, AbilityInstance>> abilities;
    private final Map<String, Map<String, AbilityWithActiveCount>> activateableAbilities;
    private final Map<String, List<AbilitySlot>> abilitySlots;
    private final List<AbilitySlot> tempAbilitySlots;

    @Override
    public JSONOrderedObject save() {
        Object[] objectArray;
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        if (this.tempAbilitySlots.size() > 0) {
            objectArray = new Object[this.tempAbilitySlots.size()];
            int n = 0;
            for (AbilitySlot abilitySlot : this.tempAbilitySlots) {
                objectArray[n] = abilitySlot.save();
                ++n;
            }
            jSONOrderedObject.put("tempSlots", objectArray);
        }
        objectArray = new ArrayList();
        for (String string : this.abilitySlots.keySet()) {
            for (AbilitySlot abilitySlot : this.abilitySlots.get(string)) {
                objectArray.add(abilitySlot.save());
            }
        }
        if (!objectArray.isEmpty()) {
            jSONOrderedObject.put("slots", objectArray.toArray());
        }
        ArrayList arrayList = new ArrayList();
        for (String string : this.abilities.keySet()) {
            for (String string2 : this.abilities.get(string).keySet()) {
                AbilityInstance abilityInstance = this.abilities.get(string).get(string2);
                if (abilityInstance.race || abilityInstance.role) continue;
                JSONOrderedObject jSONOrderedObject2 = new JSONOrderedObject();
                jSONOrderedObject2.put("abilityID", abilityInstance.abilityID);
                jSONOrderedObject2.put("levelObtained", abilityInstance.level);
                arrayList.add(jSONOrderedObject2);
            }
        }
        if (!arrayList.isEmpty()) {
            jSONOrderedObject.put("abilities", arrayList.toArray());
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) {
        if (simpleJSONObject.containsKey("abilities")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("abilities")) {
                SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
                String string = simpleJSONObject2.get("abilityID", null);
                int n = simpleJSONObject2.get("levelObtained", 0);
                this.loadAbility(Game.ruleset.getAbility(string), n, false, false);
            }
        }
        if (simpleJSONObject.containsKey("tempSlots")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("tempSlots")) {
                this.tempAbilitySlots.add(AbilitySlot.load(simpleJSONArrayEntry.getObject(), referenceHandler, this.parent));
            }
        }
        if (simpleJSONObject.containsKey("slots")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("slots")) {
                this.add(AbilitySlot.load(simpleJSONArrayEntry.getObject(), referenceHandler, this.parent));
            }
        }
    }

    public CreatureAbilitySet(Creature creature) {
        this.parent = creature;
        this.abilities = new HashMap<String, Map<String, AbilityInstance>>();
        this.activateableAbilities = new HashMap<String, Map<String, AbilityWithActiveCount>>();
        this.abilitySlots = new HashMap<String, List<AbilitySlot>>();
        this.tempAbilitySlots = new ArrayList<AbilitySlot>(2);
        this.listeners = new ArrayList<Listener>(1);
    }

    public CreatureAbilitySet(CreatureAbilitySet creatureAbilitySet, Creature creature) {
        Object object;
        Object object2;
        this.parent = creature;
        this.abilities = new HashMap<String, Map<String, AbilityInstance>>();
        this.activateableAbilities = new HashMap<String, Map<String, AbilityWithActiveCount>>();
        this.abilitySlots = new HashMap<String, List<AbilitySlot>>();
        this.listeners = new ArrayList<Listener>(1);
        for (String object3 : creatureAbilitySet.abilities.keySet()) {
            object2 = new HashMap<String, AbilityInstance>(creatureAbilitySet.abilities.get(object3));
            this.abilities.put(object3, (Map<String, AbilityInstance>)object2);
        }
        for (String string : creatureAbilitySet.activateableAbilities.keySet()) {
            object2 = new HashMap();
            for (String string2 : creatureAbilitySet.activateableAbilities.get(string).keySet()) {
                object = creatureAbilitySet.activateableAbilities.get(string).get(string2);
                object2.put(string2, new AbilityWithActiveCount(((AbilityWithActiveCount)object).abilityID, ((AbilityWithActiveCount)object).count));
            }
            this.activateableAbilities.put(string, (Map<String, AbilityWithActiveCount>)object2);
        }
        for (String string : creatureAbilitySet.abilitySlots.keySet()) {
            object2 = creatureAbilitySet.abilitySlots.get(string);
            ArrayList arrayList = new ArrayList(2);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (AbilitySlot)iterator.next();
                arrayList.add(new AbilitySlot((AbilitySlot)object, creature));
            }
            this.abilitySlots.put(string, arrayList);
        }
        this.tempAbilitySlots = new ArrayList<AbilitySlot>();
        for (AbilitySlot abilitySlot : creatureAbilitySet.tempAbilitySlots) {
            this.tempAbilitySlots.add(new AbilitySlot(abilitySlot, creature));
        }
    }

    public void add(Ability ability, int n) {
        this.addAbility(ability, n, false, false);
    }

    public void addRacialAbility(Ability ability) {
        this.addAbility(ability, 1, false, true);
    }

    public void addRoleAbility(Ability ability, int n) {
        this.addAbility(ability, n, true, false);
    }

    public void loadAbility(Ability ability, int n, boolean bl, boolean bl2) {
        Map<Object, Object> map;
        String string = ability.getType();
        if (!this.abilities.containsKey(string)) {
            map = new HashMap(4);
            this.abilities.put(string, map);
        } else {
            map = this.abilities.get(string);
        }
        map.put(ability.getID(), new AbilityInstance(ability, n, bl2, bl));
        if (ability.isActivateable()) {
            Map<Object, Object> map2;
            if (!this.activateableAbilities.containsKey(string)) {
                map2 = new HashMap(4);
                this.activateableAbilities.put(string, map2);
            } else {
                map2 = this.activateableAbilities.get(string);
            }
            map2.put(ability.getID(), new AbilityWithActiveCount(ability));
        }
        if (this.parent != null) {
            ability.executeFunction(ScriptFunctionType.onApply, this.parent);
        }
    }

    private void addAbility(Ability ability, int n, boolean bl, boolean bl2) {
        this.loadAbility(ability, n, bl, bl2);
        if (ability.isActivateable() && ability.isFixed()) {
            AbilitySlot abilitySlot = new AbilitySlot(ability, this.parent);
            this.add(abilitySlot);
        }
        this.notifyListeners();
    }

    public void addAll(CreatureAbilitySet creatureAbilitySet) {
        if (creatureAbilitySet == null) {
            return;
        }
        for (String string : creatureAbilitySet.abilities.keySet()) {
            for (String object : creatureAbilitySet.abilities.get(string).keySet()) {
                AbilityInstance abilityInstance = creatureAbilitySet.abilities.get(string).get(object);
                this.addAbility(abilityInstance.getAbility(), abilityInstance.level, abilityInstance.role, abilityInstance.race);
            }
        }
        for (String string : creatureAbilitySet.abilitySlots.keySet()) {
            for (AbilitySlot abilitySlot : creatureAbilitySet.abilitySlots.get(string)) {
                if (abilitySlot.isFixed()) continue;
                this.add(abilitySlot);
            }
        }
        this.notifyListeners();
    }

    public void remove(Ability ability) {
        Map<String, Object> map;
        if (ability.isActivateable()) {
            map = this.activateableAbilities.get(ability.getType());
            if (map == null) {
                return;
            }
            if (!map.containsKey(ability.getID())) {
                return;
            }
            map.remove(ability.getID());
        }
        if ((map = this.abilities.get(ability.getType())) == null) {
            return;
        }
        if (!map.containsKey(ability.getID())) {
            return;
        }
        map.remove(ability.getID());
        if (this.abilitySlots.containsKey(ability.getType())) {
            if (ability.isFixed()) {
                Iterator<AbilitySlot> iterator = this.abilitySlots.get(ability.getType()).iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getAbility() != ability) continue;
                    iterator.remove();
                }
            } else {
                for (AbilitySlot abilitySlot : this.abilitySlots.get(ability.getType())) {
                    if (abilitySlot.getAbility() != ability) continue;
                    abilitySlot.setAbility((String)null);
                }
            }
        }
        this.notifyListeners();
    }

    public void clear() {
        this.abilitySlots.clear();
        this.abilities.clear();
        this.activateableAbilities.clear();
        this.notifyListeners();
    }

    public boolean has(Ability ability) {
        if (!this.abilities.containsKey(ability.getType())) {
            return false;
        }
        return this.abilities.get(ability.getType()).containsKey(ability.getID());
    }

    public boolean has(String string) {
        Ability ability = Game.ruleset.getAbility(string);
        if (ability == null) {
            Logger.appendToWarningLog("CreatureAbilitySet.has(String abilityID) was called with nonexistant abilityID" + string);
            return false;
        }
        return this.has(ability);
    }

    public List<String> getAllTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.abilities.size());
        for (String string : this.abilities.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getActivateableTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.activateableAbilities.size());
        for (String string : this.activateableAbilities.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<Ability> getActivateableAbilities() {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (String string : this.activateableAbilities.keySet()) {
            for (String string2 : this.activateableAbilities.get(string).keySet()) {
                arrayList.add(Game.ruleset.getAbility(string2));
            }
        }
        return arrayList;
    }

    public void add(AbilitySlot abilitySlot) {
        Object object;
        String string = abilitySlot.getType();
        if (this.abilitySlots.containsKey(string)) {
            this.abilitySlots.get(string).add(abilitySlot);
        } else {
            object = new ArrayList<AbilitySlot>(2);
            object.add(abilitySlot);
            this.abilitySlots.put(string, (List<AbilitySlot>)object);
        }
        if (!abilitySlot.isEmpty()) {
            object = abilitySlot.getAbility();
            AbilityWithActiveCount abilityWithActiveCount = this.activateableAbilities.get(((Ability)object).getType()).get(((Ability)object).getID());
            abilityWithActiveCount.count++;
        }
        this.notifyListeners();
    }

    public int getNumberOfSlots(String string) {
        if (this.abilitySlots.containsKey(string)) {
            return this.abilitySlots.get(string).size();
        }
        return 0;
    }

    public List<Ability> getAbilitiesOfType(String string) {
        if (!this.abilities.containsKey(string)) {
            return new ArrayList<Ability>(0);
        }
        ArrayList<Ability> arrayList = new ArrayList<Ability>(this.abilities.get(string).size());
        for (String string2 : this.abilities.get(string).keySet()) {
            arrayList.add(this.abilities.get(string).get(string2).getAbility());
        }
        return arrayList;
    }

    public List<Ability> getAllAbilities() {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (String string : this.abilities.keySet()) {
            for (String string2 : this.abilities.get(string).keySet()) {
                arrayList.add(this.abilities.get(string).get(string2).getAbility());
            }
        }
        return arrayList;
    }

    public List<AbilityInstance> getAllAbilityInstances() {
        ArrayList<AbilityInstance> arrayList = new ArrayList<AbilityInstance>();
        for (String string : this.abilities.keySet()) {
            for (String string2 : this.abilities.get(string).keySet()) {
                arrayList.add(this.abilities.get(string).get(string2));
            }
        }
        return arrayList;
    }

    public List<AbilityInstance> getAbilityInstancesOfType(String string) {
        if (!this.abilities.containsKey(string)) {
            return new ArrayList<AbilityInstance>(0);
        }
        ArrayList<AbilityInstance> arrayList = new ArrayList<AbilityInstance>(this.abilities.get(string).size());
        for (String string2 : this.abilities.get(string).keySet()) {
            arrayList.add(this.abilities.get(string).get(string2));
        }
        return arrayList;
    }

    public List<AbilitySlot> getSlotsOfType(String string) {
        if (!this.abilitySlots.containsKey(string)) {
            return new ArrayList<AbilitySlot>(0);
        }
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>(this.abilitySlots.get(string).size());
        for (AbilitySlot abilitySlot : this.abilitySlots.get(string)) {
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public int getNumberOfEmptySlotsOfType(String string) {
        if (!this.abilitySlots.containsKey(string)) {
            return 0;
        }
        int n = 0;
        for (AbilitySlot abilitySlot : this.abilitySlots.get(string)) {
            if (!abilitySlot.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public List<AbilitySlot> getEmptySlotsOfType(String string) {
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        if (!this.abilitySlots.containsKey(string)) {
            return arrayList;
        }
        for (AbilitySlot abilitySlot : this.abilitySlots.get(string)) {
            if (!abilitySlot.isEmpty()) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public AbilitySlot getFirstEmptySlotOfType(String string) {
        if (!this.abilitySlots.containsKey(string)) {
            return null;
        }
        for (AbilitySlot abilitySlot : this.abilitySlots.get(string)) {
            if (!abilitySlot.isEmpty()) continue;
            return abilitySlot;
        }
        return null;
    }

    public AbilitySlot getSlotWithReadiedAbility(String string) {
        return this.getSlotWithReadiedAbility(Game.ruleset.getAbility(string));
    }

    public AbilitySlot getSlotWithReadiedAbility(Ability ability) {
        if (!this.abilitySlots.containsKey(ability.getType())) {
            return null;
        }
        for (AbilitySlot abilitySlot : this.abilitySlots.get(ability.getType())) {
            if (abilitySlot.getAbility() != ability) continue;
            return abilitySlot;
        }
        return null;
    }

    public List<AbilitySlot> getSlotsWithReadiedAbility(String string) {
        return this.getSlotsWithReadiedAbility(Game.ruleset.getAbility(string));
    }

    public List<AbilitySlot> getSlotsWithReadiedAbility(Ability ability) {
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        if (!this.abilitySlots.containsKey(ability.getType())) {
            return arrayList;
        }
        for (AbilitySlot abilitySlot : this.abilitySlots.get(ability.getType())) {
            if (abilitySlot.getAbility() != ability) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public int getNumberOfSlotsWithReadiedAbility(Ability ability) {
        if (!this.abilitySlots.containsKey(ability.getType())) {
            return 0;
        }
        int n = 0;
        for (AbilitySlot abilitySlot : this.abilitySlots.get(ability.getType())) {
            if (abilitySlot.getAbility() != ability) continue;
            ++n;
        }
        return n;
    }

    public void cancelAllEffects() {
        for (String object : this.abilitySlots.keySet()) {
            for (AbilitySlot abilitySlot : this.abilitySlots.get(object)) {
                abilitySlot.cancelAllEffects();
            }
        }
        for (AbilitySlot abilitySlot : this.tempAbilitySlots) {
            abilitySlot.cancelAllEffects();
        }
    }

    public List<AbilitySlot> cancelAllAuras() {
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        for (String object : this.abilitySlots.keySet()) {
            for (AbilitySlot abilitySlot : this.abilitySlots.get(object)) {
                if (!abilitySlot.cancelAllAuras()) continue;
                arrayList.add(abilitySlot);
            }
        }
        for (AbilitySlot abilitySlot : this.tempAbilitySlots) {
            abilitySlot.cancelAllAuras();
        }
        return arrayList;
    }

    public void trackTempAbilitySlot(AbilitySlot abilitySlot) {
        this.tempAbilitySlots.add(abilitySlot);
    }

    public boolean elapseTime(int n) {
        boolean bl = false;
        for (String object : this.abilitySlots.keySet()) {
            for (AbilitySlot abilitySlot : this.abilitySlots.get(object)) {
                abilitySlot.elapseRounds(n);
                bl = bl || abilitySlot.hasActiveEffects();
            }
        }
        Iterator<Object> iterator = this.tempAbilitySlots.iterator();
        while (iterator.hasNext()) {
            AbilitySlot abilitySlot = (AbilitySlot)iterator.next();
            abilitySlot.elapseRounds(n);
            if (abilitySlot.hasActiveEffects()) continue;
            iterator.remove();
        }
        return bl || !this.tempAbilitySlots.isEmpty();
    }

    public void fillEmptySlots() {
        for (String string : this.activateableAbilities.keySet()) {
            List<AbilitySlot> list = this.getEmptySlotsOfType(string);
            ArrayList<AbilityWithActiveCount> arrayList = new ArrayList<AbilityWithActiveCount>(this.activateableAbilities.get(string).size());
            arrayList.addAll(this.activateableAbilities.get(string).values());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AbilityWithActiveCount abilityWithActiveCount = (AbilityWithActiveCount)iterator.next();
                Ability ability = Game.ruleset.getAbility(abilityWithActiveCount.abilityID);
                if (!ability.isFixed()) continue;
                iterator.remove();
            }
            Collections.sort(arrayList);
            if (arrayList.isEmpty()) continue;
            iterator = arrayList.iterator();
            for (AbilitySlot abilitySlot : list) {
                AbilityWithActiveCount abilityWithActiveCount = (AbilityWithActiveCount)iterator.next();
                abilitySlot.setAbility(abilityWithActiveCount.abilityID);
                abilityWithActiveCount.count++;
                if (iterator.hasNext()) continue;
                iterator = arrayList.iterator();
            }
        }
    }

    public void readyAbilityInSlot(Ability ability, AbilitySlot abilitySlot) {
        if (ability != null && !ability.isActivateable()) {
            Logger.appendToWarningLog("Attempted to ready ability " + ability.getID() + " on " + this.parent.getTemplate().getID() + " but ability is not activateable.");
            return;
        }
        if (ability != null && ability.isFixed()) {
            Logger.appendToWarningLog("Attempted to ready ability " + ability.getID() + " on " + this.parent.getTemplate().getID() + " but ability is fixed.");
            return;
        }
        String string = abilitySlot.getAbilityID();
        String string2 = ability != null ? ability.getID() : null;
        AbilityWithActiveCount abilityWithActiveCount = this.activateableAbilities.get(abilitySlot.getType()).get(string);
        AbilityWithActiveCount abilityWithActiveCount2 = this.activateableAbilities.get(abilitySlot.getType()).get(string2);
        if (abilityWithActiveCount != null) {
            abilityWithActiveCount.count--;
        }
        if (abilityWithActiveCount2 != null) {
            abilityWithActiveCount2.count--;
        }
        abilitySlot.setAbility(ability);
    }

    public void readyAbilityInFirstEmptySlot(Ability ability) {
        if (!ability.isActivateable()) {
            Logger.appendToWarningLog("Attempted to ready ability " + ability.getID() + " on " + this.parent.getTemplate().getID() + " but ability is not activateable.");
            return;
        }
        AbilitySlot abilitySlot = this.getFirstEmptySlotOfType(ability.getType());
        if (abilitySlot == null) {
            Logger.appendToWarningLog("Attempted to ready ability " + ability.getID() + " on " + this.parent.getTemplate().getID() + " but no empty slots available.");
            return;
        }
        this.readyAbilityInSlot(ability, abilitySlot);
    }

    public void removeRacialAbilities() {
        ArrayList<Ability> arrayList = new ArrayList<Ability>();
        for (String object : this.abilities.keySet()) {
            for (String string : this.abilities.get(object).keySet()) {
                AbilityInstance abilityInstance = this.abilities.get(object).get(string);
                if (!abilityInstance.isRacialAbility()) continue;
                arrayList.add(abilityInstance.getAbility());
            }
        }
        for (Ability ability : arrayList) {
            this.remove(ability);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.abilitySetModified();
        }
    }

    public AIAbilitySlotSet createAISet() {
        return new AIAbilitySlotSet(this.abilitySlots);
    }

    public static interface Listener {
        public void abilitySetModified();
    }

    public class AbilityInstance {
        private final String abilityID;
        private final int level;
        private final boolean race;
        private final boolean role;

        private AbilityInstance(Ability ability, int n, boolean bl, boolean bl2) {
            this.abilityID = ability.getID();
            this.level = n;
            this.race = bl;
            this.role = bl2;
        }

        public Ability getAbility() {
            return Game.ruleset.getAbility(this.abilityID);
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isRacialAbility() {
            return this.race;
        }

        public boolean isRoleAbility() {
            return this.role;
        }

        public String toString() {
            if (this.role) {
                return "(Role) " + this.getAbility().getName();
            }
            if (this.race) {
                return "(Racial) " + this.getAbility().getName();
            }
            return this.getAbility().getName();
        }
    }

    private class AbilityWithActiveCount
    implements Comparable<AbilityWithActiveCount> {
        private final String abilityID;
        private int count;

        private AbilityWithActiveCount(Ability ability) {
            this.abilityID = ability.getID();
            this.count = 0;
        }

        private AbilityWithActiveCount(String string, int n) {
            this.abilityID = string;
            this.count = n;
        }

        @Override
        public int compareTo(AbilityWithActiveCount abilityWithActiveCount) {
            return this.count - abilityWithActiveCount.count;
        }
    }
}

