/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.AreaTargeter;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Location;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class ConeTargeter
extends AreaTargeter {
    private int coneRadius;
    private int coneAngle;
    private Point gridOrigin;
    private Point screenOrigin;
    private double lineAngle;
    private double lineLength;
    private boolean[][] visible;
    private Point gridEnd;
    private Point screenEnd;
    private boolean hasVisibilityCriterion = true;

    public ConeTargeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        super(creature, scriptable, abilitySlot);
    }

    public void setHasVisibilityCriterion(boolean bl) {
        this.hasVisibilityCriterion = bl;
    }

    public void setOrigin(Location location) {
        this.setOrigin(location.toPoint());
    }

    public void setOrigin(Point point) {
        this.gridOrigin = point;
        this.screenOrigin = AreaUtil.convertGridToScreenAndCenter(point);
        this.visible = Game.curCampaign.curArea.getMatrixOfSize();
        Game.curCampaign.curArea.getUtil().setVisibilityWithRespectToPosition(this.visible, this.gridOrigin);
    }

    public Point getEndPoint() {
        return this.gridEnd;
    }

    public double getCenterAngle() {
        return this.screenOrigin.angleTo(this.screenEnd);
    }

    public void setConeAngle(int n) {
        this.coneAngle = n;
    }

    public void setConeRadius(int n) {
        this.coneRadius = n;
    }

    @Override
    protected void computeAffectedPoints(int n, int n2, Point point) {
        this.setMouseHoverValid(true);
        List<Point> list = this.getAffectedPoints();
        this.lineAngle = AreaUtil.angle(this.screenOrigin.x, this.screenOrigin.y, n, n2);
        this.lineLength = (double)this.coneRadius - 0.75;
        double d = this.lineAngle + (double)this.coneAngle / 2.0 * (Math.PI / 180);
        double d2 = (double)this.screenOrigin.x + this.lineLength * 72.0 * Math.sin(d);
        double d3 = (double)this.screenOrigin.y + this.lineLength * 72.0 * Game.TILE_RATIO * Math.cos(d);
        d = this.lineAngle - (double)this.coneAngle / 2.0 * (Math.PI / 180);
        double d4 = (double)this.screenOrigin.x + this.lineLength * 72.0 * Math.sin(d);
        double d5 = (double)this.screenOrigin.y + this.lineLength * 72.0 * Game.TILE_RATIO * Math.cos(d);
        boolean bl = false;
        boolean bl2 = false;
        block0: for (int i = this.coneRadius; i > 0; --i) {
            for (int j = 0; j < 12 * i; ++j) {
                Point point2 = AreaUtil.convertPolarToGrid(this.gridOrigin, i, j);
                Point point3 = AreaUtil.convertGridToScreen(point2);
                if (AreaUtil.lineSegmentIntersectsHex(point3.x, point3.y, this.screenOrigin.x, this.screenOrigin.y, (int)d2, (int)d3)) {
                    bl = true;
                }
                if (bl) {
                    if (this.visibility(point2)) {
                        list.add(point2);
                    }
                    if (AreaUtil.lineSegmentIntersectsHex(point3.x, point3.y, this.screenOrigin.x, this.screenOrigin.y, (int)d4, (int)d5)) {
                        bl2 = true;
                    }
                }
                if (!bl || !bl2) continue;
                bl = false;
                bl2 = false;
                continue block0;
            }
        }
        double d6 = (double)this.screenOrigin.x + this.lineLength * 72.0 * Math.sin(this.lineAngle);
        double d7 = (double)this.screenOrigin.y + this.lineLength * 72.0 * Game.TILE_RATIO * Math.cos(this.lineAngle);
        this.screenEnd = new Point((int)d6, (int)d7);
        this.gridEnd = AreaUtil.convertScreenToGrid(this.screenEnd);
    }

    private boolean visibility(Point point) {
        if (!this.hasVisibilityCriterion) {
            return true;
        }
        if (point.x < 0 || point.x >= this.visible.length || point.y < 0 || point.y >= this.visible[0].length) {
            return false;
        }
        return this.visible[point.x][point.y];
    }

    @Override
    protected boolean updateMouseStateOnlyWhenGridPointChanges() {
        return false;
    }

    @Override
    public boolean draw(AnimationState animationState) {
        if (!super.draw(animationState)) {
            return false;
        }
        double d = (double)this.coneAngle / 2.0 * (Math.PI / 180);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)this.screenOrigin.x, (double)this.screenOrigin.y);
        for (double d2 = this.lineAngle - d; d2 <= this.lineAngle + d + 0.001; d2 += 0.09817477042468103) {
            double d3 = this.lineLength * 72.0 * Math.sin(d2);
            double d4 = this.lineLength * 72.0 * Game.TILE_RATIO * Math.cos(d2);
            GL11.glVertex2d((double)((double)this.screenOrigin.x + d3), (double)((double)this.screenOrigin.y + d4));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        return true;
    }
}

