/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.AreaTargeter;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.entity.Creature;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class CircleTargeter
extends AreaTargeter {
    private Point screenOrigin;
    private double drawRadius;
    private int radius;

    public CircleTargeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        super(creature, scriptable, abilitySlot);
    }

    public void setRadius(int n) {
        this.radius = n;
        this.drawRadius = (double)n - 0.75;
    }

    @Override
    protected void computeAffectedPoints(int n, int n2, Point point) {
        if (!this.mouseHoverValid()) {
            return;
        }
        List<Point> list = this.getAffectedPoints();
        list.add(new Point(point));
        for (int i = 1; i <= this.radius; ++i) {
            for (int j = 0; j < i * 6; ++j) {
                Point point2 = AreaUtil.convertPolarToGrid(point, i, j);
                list.add(point2);
            }
        }
        this.screenOrigin = AreaUtil.convertGridToScreenAndCenter(this.getMouseGridPosition());
    }

    @Override
    protected boolean updateMouseStateOnlyWhenGridPointChanges() {
        return true;
    }

    @Override
    public boolean draw(AnimationState animationState) {
        if (!super.draw(animationState)) {
            return false;
        }
        if (this.mouseHoverValid() && this.radius > 0) {
            GL11.glDisable((int)3553);
            GL11.glBegin((int)2);
            for (double d = 0.0; d <= 6.284185307179587; d += 0.09817477042468103) {
                double d2 = this.drawRadius * 72.0 * Math.sin(d);
                double d3 = this.drawRadius * 72.0 * Game.TILE_RATIO * Math.cos(d);
                GL11.glVertex2d((double)((double)this.screenOrigin.x + d2), (double)((double)this.screenOrigin.y + d3));
            }
            GL11.glEnd();
            GL11.glEnable((int)3553);
        }
        return true;
    }
}

