/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.EffectTarget;
import net.sf.hale.entity.Entity;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONObject;

public class Aura
extends Effect {
    private int maxRadius;
    private int minRadius;

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = super.save();
        jSONOrderedObject.put("isAura", true);
        jSONOrderedObject.put("minRadius", this.minRadius);
        jSONOrderedObject.put("maxRadius", this.maxRadius);
        return jSONOrderedObject;
    }

    public static Aura load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) {
        Aura aura = new Aura(simpleJSONObject.get("scriptLocation", null));
        aura.minRadius = simpleJSONObject.get("minRadius", 0);
        aura.maxRadius = simpleJSONObject.get("maxRadius", 0);
        return aura;
    }

    public Aura(String string) {
        super(string);
        this.minRadius = 0;
        this.maxRadius = 0;
    }

    public Aura(Aura aura, EffectTarget effectTarget) {
        super(aura, effectTarget);
        this.maxRadius = aura.maxRadius;
        this.minRadius = aura.minRadius;
    }

    public int getAuraMinRadius() {
        return this.minRadius;
    }

    public void setAuraMinRadius(int n) {
        this.minRadius = n;
    }

    public int getAuraMaxRadius() {
        return this.maxRadius;
    }

    public void setAuraMaxRadius(int n) {
        this.maxRadius = n;
    }

    public List<Point> getCurrentAffectedPoints() {
        if (!(this.getTarget() instanceof Entity)) {
            return Collections.emptyList();
        }
        int n = Game.curCampaign.curArea.getHeight();
        int n2 = Game.curCampaign.curArea.getWidth();
        Point point = ((Entity)this.getTarget()).getLocation().toPoint();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (this.minRadius <= 0) {
            arrayList.add(point);
        }
        for (int i = Math.max(1, this.minRadius); i <= this.maxRadius; ++i) {
            for (int j = 0; j < i * 6; ++j) {
                Point point2 = AreaUtil.convertPolarToGrid(point, i, j);
                if (point2.x < 0 || point2.x >= n2 || point2.y < 0 || point2.y >= n) continue;
                arrayList.add(point2);
            }
        }
        return arrayList;
    }
}

