/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;

public class AsyncScriptable
extends Thread {
    private Scriptable scriptable;
    private volatile boolean readyToExecute = false;
    private ScriptFunctionType type;
    private String function;
    private Object[] arguments;
    private long delayMillis;

    public AsyncScriptable(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    public void setDelayMillis(long l) {
        this.delayMillis = l;
    }

    public Scriptable getScriptable() {
        return this.scriptable;
    }

    public void executeAsync(String string, Object ... objectArray) {
        this.function = string;
        this.arguments = objectArray;
        this.readyToExecute = true;
        this.start();
    }

    public void executeAsync(ScriptFunctionType scriptFunctionType, Object ... objectArray) {
        this.type = scriptFunctionType;
        this.arguments = objectArray;
        this.readyToExecute = true;
        this.start();
    }

    @Override
    public void run() {
        if (!this.readyToExecute) {
            throw new IllegalStateException("Cannot use start() method of AsyncScriptable directly.  Use executeAsync instead.");
        }
        if (this.delayMillis != 0L) {
            try {
                Thread.sleep(this.delayMillis);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (this.function != null) {
            this.scriptable.executeFunction(this.function, this.arguments);
        } else {
            this.scriptable.executeFunction(this.type, this.arguments);
        }
    }
}

