/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.ability.Targeter;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.Point;
import net.sf.hale.widgets.RightClickMenu;

public abstract class AreaTargeter
extends Targeter {
    private List<Point> affectedPoints = new ArrayList<Point>();
    private List<Creature> affectedCreatures = new ArrayList<Creature>();
    private Faction.Relationship affectedCreatureRelationship;
    private boolean allowAffectedCreaturesEmpty = true;
    private boolean allowOccupiedTile = true;

    public AreaTargeter(Creature creature, Scriptable scriptable, AbilitySlot abilitySlot) {
        super(creature, scriptable, abilitySlot);
    }

    public void setAllowOccupiedTileSelection(boolean bl) {
        this.allowOccupiedTile = bl;
    }

    public void setAllowAffectedCreaturesEmpty(boolean bl) {
        this.allowAffectedCreaturesEmpty = bl;
    }

    public List<Point> getAffectedPoints() {
        return this.affectedPoints;
    }

    public List<Creature> getAffectedCreatures() {
        return this.affectedCreatures;
    }

    public void setRelationshipCriterion(String string) {
        this.affectedCreatureRelationship = Faction.Relationship.valueOf(string);
        this.affectedCreatures.clear();
        for (Point point : this.affectedPoints) {
            Creature creature = Game.curCampaign.curArea.getCreatureAtGridPoint(point);
            if (creature == null || !this.meetsRelationshipCriterion(creature)) continue;
            this.affectedCreatures.add(creature);
        }
    }

    protected boolean meetsRelationshipCriterion(Creature creature) {
        if (this.affectedCreatureRelationship == null) {
            boolean bl;
            Faction faction = Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction"));
            boolean bl2 = Game.ruleset.getDifficultyManager().friendlyFireOnPCs();
            boolean bl3 = this.getParent().getFaction() == faction && creature.getFaction() == faction;
            switch (this.getSlot().getAbility().getActionType()) {
                case Debuff: 
                case Damage: {
                    bl = true;
                }
            }
            bl = false;
            return !bl || !bl3 || bl2;
        }
        return this.getParent().getFaction().getRelationship(creature) == this.affectedCreatureRelationship;
    }

    @Override
    public boolean hasSelectedTargets() {
        return this.mouseHoverValid() && this.affectedCreaturesEmptyConditionMet();
    }

    @Override
    public void showMenu(int n, int n2) {
        Button button;
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        rightClickMenu.clear();
        rightClickMenu.setPosition(n, n2);
        rightClickMenu.addMenuLevel(this.getMenuTitle());
        if (this.getMouseActionCondition() == MouseActionList.Condition.TargetSelect) {
            button = new Button("Activate");
            button.addCallback(this.getActivateCallback());
            rightClickMenu.addButton(button);
        }
        if (this.isCancelable()) {
            button = new Button("Cancel");
            button.addCallback(this.getCancelCallback());
            rightClickMenu.addButton(button);
        }
        rightClickMenu.show();
    }

    @Override
    public void performLeftClickAction() {
        if (this.getMouseActionCondition() == MouseActionList.Condition.TargetSelect) {
            this.getActivateCallback().run();
        }
    }

    @Override
    public boolean setMousePosition(int n, int n2, Point point) {
        boolean bl = super.setMousePosition(n, n2, point);
        if (!bl && this.updateMouseStateOnlyWhenGridPointChanges()) {
            return false;
        }
        this.affectedPoints.clear();
        this.affectedCreatures.clear();
        this.computeAffectedPoints(n, n2, point);
        Iterator<Point> iterator = this.affectedPoints.iterator();
        while (iterator.hasNext()) {
            Point point2 = iterator.next();
            if (point2.x >= 0 && point2.x < Game.curCampaign.curArea.getWidth() && point2.y >= 0 && point2.y < Game.curCampaign.curArea.getHeight()) continue;
            iterator.remove();
        }
        for (Point point3 : this.affectedPoints) {
            Creature creature = Game.curCampaign.curArea.getCreatureAtGridPoint(point3);
            if (creature == null || !this.meetsRelationshipCriterion(creature)) continue;
            this.affectedCreatures.add(creature);
        }
        if (this.mouseHoverValid() && this.affectedCreaturesEmptyConditionMet() && this.occupiedTileConditionMet(point)) {
            this.setMouseActionCondition(MouseActionList.Condition.TargetSelect);
        } else {
            this.setMouseHoverValid(false);
            this.setMouseActionCondition(MouseActionList.Condition.Cancel);
        }
        return bl;
    }

    private boolean occupiedTileConditionMet(Point point) {
        if (this.allowOccupiedTile) {
            return true;
        }
        Creature creature = Game.curCampaign.curArea.getCreatureAtGridPoint(point);
        return creature == null;
    }

    private boolean affectedCreaturesEmptyConditionMet() {
        if (this.allowAffectedCreaturesEmpty) {
            return true;
        }
        return this.affectedCreatures.size() > 0;
    }

    protected abstract void computeAffectedPoints(int var1, int var2, Point var3);

    protected abstract boolean updateMouseStateOnlyWhenGridPointChanges();

    @Override
    public boolean draw(AnimationState animationState) {
        if (!super.draw(animationState)) {
            return false;
        }
        for (Point object : this.affectedPoints) {
            Game.areaViewer.drawGreyHex(object, animationState);
        }
        for (Creature creature : this.affectedCreatures) {
            Game.areaViewer.drawRedHex(creature.getLocation().toPoint(), animationState);
        }
        for (Point point : this.getAllowedPoints()) {
            Game.areaViewer.drawGreenHex(point, animationState);
        }
        return true;
    }

    private int getTargetCount(boolean bl) {
        Faction.Relationship relationship;
        if (this.getSlot() == null) {
            return 0;
        }
        switch (this.getSlot().getAbility().getActionType()) {
            case Buff: 
            case Heal: {
                relationship = Faction.Relationship.Friendly;
                break;
            }
            case Debuff: 
            case Damage: {
                relationship = Faction.Relationship.Hostile;
                break;
            }
            default: {
                return 0;
            }
        }
        int n = 0;
        for (Creature creature : this.affectedCreatures) {
            Faction.Relationship relationship2 = this.getParent().getFaction().getRelationship(creature);
            if (bl && relationship2 == relationship) {
                ++n;
                continue;
            }
            if (bl || relationship2 == relationship) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getDesirableTargetCount() {
        return this.getTargetCount(true);
    }

    @Override
    public int getUndesirableTargetCount() {
        return this.getTargetCount(false);
    }
}

