/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.area.AreaEntityList;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.BonusStackTypeList;
import net.sf.hale.entity.Creature;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class AreaEffectList
implements Saveable {
    private Map<Effect, List<Point>> effects;
    private EffectList[][] effectsAtPosition;
    private Area area;

    @Override
    public Object save() {
        JSONOrderedObject[] jSONOrderedObjectArray = new JSONOrderedObject[this.effects.size()];
        int n = 0;
        for (Effect effect : this.effects.keySet()) {
            if (effect.getTarget() == this.area) {
                jSONOrderedObjectArray[n] = effect.save();
            } else {
                jSONOrderedObjectArray[n] = new JSONOrderedObject();
                jSONOrderedObjectArray[n].put("ref", SaveGameUtil.getRef(effect));
            }
            int n2 = 0;
            JSONOrderedObject[] jSONOrderedObjectArray2 = new JSONOrderedObject[this.effects.get(effect).size()];
            for (Point point : this.effects.get(effect)) {
                jSONOrderedObjectArray2[n2] = new JSONOrderedObject();
                jSONOrderedObjectArray2[n2].put("x", point.x);
                jSONOrderedObjectArray2[n2].put("y", point.y);
                ++n2;
            }
            jSONOrderedObjectArray[n].put("points", jSONOrderedObjectArray2);
            ++n;
        }
        return jSONOrderedObjectArray;
    }

    public void load(SimpleJSONArray simpleJSONArray, ReferenceHandler referenceHandler) throws LoadGameException {
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            Effect effect = null;
            try {
                effect = simpleJSONObject.containsKey("duration") ? Effect.load(simpleJSONObject, referenceHandler, this.area) : referenceHandler.getEffect(simpleJSONObject.get("ref", null));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error loading effect ", exception);
                continue;
            }
            if (effect == null) {
                Logger.appendToWarningLog("Warning: unable to load area effect " + simpleJSONObject.get("ref", null));
                continue;
            }
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (SimpleJSONArrayEntry simpleJSONArrayEntry2 : simpleJSONObject.getArray("points")) {
                SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry2.getObject();
                Point point = new Point(simpleJSONObject2.get("x", 0), simpleJSONObject2.get("y", 0));
                arrayList.add(point);
                if (this.effectsAtPosition[point.x][point.y] == null) {
                    this.effectsAtPosition[point.x][point.y] = new EffectList();
                }
                this.effectsAtPosition[point.x][point.y].add(effect);
            }
            this.effects.put(effect, arrayList);
        }
    }

    public AreaEffectList(Area area) {
        this.area = area;
        this.effects = new HashMap<Effect, List<Point>>();
        this.effectsAtPosition = new EffectList[area.getWidth()][area.getHeight()];
    }

    public void startAnimations() {
        for (Effect effect : this.effects.keySet()) {
            effect.startAnimations();
        }
    }

    public void move(Aura aura, List<Point> list) {
        Creature creature;
        if (!this.effects.containsKey(aura)) {
            return;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>(list.size());
        for (Point object22 : list) {
            if (!this.checkCoordinates(object22.x, object22.y)) continue;
            arrayList.add(new Point(object22));
        }
        arrayList.trimToSize();
        List<Point> list2 = this.effects.get(aura);
        HashSet<Creature> hashSet = new HashSet<Creature>();
        HashSet<Creature> hashSet2 = new HashSet<Creature>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            creature = this.area.getEntities().getCreature(point.x, point.y);
            if (creature == null || creature == aura.getTarget()) continue;
            hashSet.add(creature);
        }
        for (Point point : arrayList) {
            creature = this.area.getEntities().getCreature(point.x, point.y);
            if (creature == null || creature == aura.getTarget()) continue;
            hashSet2.add(creature);
        }
        for (Creature creature2 : hashSet) {
            if (hashSet2.contains(creature2)) continue;
            aura.executeFunction(ScriptFunctionType.onTargetExit, creature2, aura);
        }
        for (Creature creature3 : hashSet2) {
            if (hashSet.contains(creature3)) continue;
            aura.executeFunction(ScriptFunctionType.onTargetEnter, creature3, aura);
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            this.effectsAtPosition[point.x][point.y].remove(aura);
        }
        for (Point point : arrayList) {
            if (this.effectsAtPosition[point.x][point.y] == null) {
                this.effectsAtPosition[point.x][point.y] = new EffectList();
            }
            this.effectsAtPosition[point.x][point.y].add(aura);
        }
        this.effects.put(aura, arrayList);
    }

    public void add(Effect effect, List<Point> list) {
        if (this.effects.containsKey(effect)) {
            return;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>(list.size());
        for (Point point : list) {
            if (!this.checkCoordinates(point.x, point.y)) continue;
            arrayList.add(new Point(point));
        }
        arrayList.trimToSize();
        this.effects.put(effect, arrayList);
        effect.executeFunction(ScriptFunctionType.onApply, effect);
        for (Point point : this.effects.get(effect)) {
            if (this.effectsAtPosition[point.x][point.y] == null) {
                this.effectsAtPosition[point.x][point.y] = new EffectList();
            }
            this.effectsAtPosition[point.x][point.y].add(effect);
            Creature creature = this.area.getEntities().getCreature(point.x, point.y);
            if (creature == null) continue;
            effect.executeFunction(ScriptFunctionType.onTargetEnter, creature, effect);
        }
        effect.startAnimations();
    }

    public void remove(Effect effect) {
        if (!this.effects.containsKey(effect)) {
            Logger.appendToWarningLog("Effect " + effect + " is not in the area effect list");
            return;
        }
        for (Point point : this.effects.get(effect)) {
            Creature creature;
            this.effectsAtPosition[point.x][point.y].remove(effect);
            if (this.effectsAtPosition[point.x][point.y].isEmpty()) {
                this.effectsAtPosition[point.x][point.y] = null;
            }
            if ((creature = this.area.getEntities().getCreature(point.x, point.y)) == null) continue;
            effect.executeFunction(ScriptFunctionType.onTargetExit, creature, effect);
        }
        this.effects.remove(effect);
        effect.endAnimations();
    }

    public boolean contains(Effect effect) {
        return this.effects.containsKey(effect);
    }

    public List<Creature> getAffectedCreatures(Effect effect, AreaEntityList areaEntityList) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        if (this.effects.get(effect) == null) {
            return arrayList;
        }
        for (Point point : this.effects.get(effect)) {
            Creature creature = areaEntityList.getCreature(point.x, point.y);
            if (creature == null) continue;
            arrayList.add(creature);
        }
        return arrayList;
    }

    public List<Effect> getEffectsAt(int n, int n2) {
        if (!this.checkCoordinates(n, n2) || this.effectsAtPosition[n][n2] == null) {
            return new ArrayList<Effect>(0);
        }
        ArrayList<Effect> arrayList = new ArrayList<Effect>(this.effectsAtPosition[n][n2].size());
        for (Effect effect : this.effectsAtPosition[n][n2]) {
            arrayList.add(effect);
        }
        return arrayList;
    }

    public boolean hasBonusAt(Bonus.Type type, int n, int n2) {
        if (!this.checkCoordinates(n, n2)) {
            return false;
        }
        if (this.effectsAtPosition[n][n2] == null) {
            return false;
        }
        for (Effect effect : this.effectsAtPosition[n][n2]) {
            if (!effect.getBonuses().hasBonusOfType(type)) continue;
            return true;
        }
        return false;
    }

    public int getBonusAt(Bonus.Type type, int n, int n2) {
        if (!this.checkCoordinates(n, n2)) {
            return 0;
        }
        if (this.effectsAtPosition[n][n2] == null) {
            return 0;
        }
        BonusStackTypeList bonusStackTypeList = new BonusStackTypeList();
        for (Effect effect : this.effectsAtPosition[n][n2]) {
            for (Bonus bonus : effect.getBonuses()) {
                if (bonus.getType() != type) continue;
                bonusStackTypeList.add(bonus);
            }
        }
        return bonusStackTypeList.getCurrentTotal();
    }

    public List<Point> getPoints(Effect effect) {
        if (!this.effects.containsKey(effect)) {
            return Collections.emptyList();
        }
        return this.getArrayListDeepCopy(this.effects.get(effect));
    }

    public void resize(int n, int n2) {
        EffectList[][] effectListArray = new EffectList[n][n2];
        HashMap<Effect, List<Point>> hashMap = new HashMap<Effect, List<Point>>();
        int n3 = Math.min(this.effectsAtPosition.length, n);
        int n4 = Math.min(this.effectsAtPosition[0].length, n2);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                effectListArray[i][j] = this.effectsAtPosition[i][j];
                if (this.effectsAtPosition[i][j] == null) continue;
                for (Effect effect : this.effectsAtPosition[i][j]) {
                    if (hashMap.containsKey(effect)) {
                        ((List)hashMap.get(effect)).add(new Point(i, j));
                        continue;
                    }
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    arrayList.add(new Point(i, j));
                    hashMap.put(effect, arrayList);
                }
            }
        }
        this.effectsAtPosition = effectListArray;
        this.effects = hashMap;
    }

    public int size() {
        return this.effects.size();
    }

    private List<Point> getArrayListDeepCopy(List<Point> list) {
        ArrayList<Point> arrayList = new ArrayList<Point>(list.size());
        for (Point point : list) {
            arrayList.add(new Point(point));
        }
        return arrayList;
    }

    private final boolean checkCoordinates(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.effectsAtPosition.length && n2 < this.effectsAtPosition[0].length;
    }

    private class EffectList
    extends ArrayList<Effect> {
        private static final long serialVersionUID = 877898924941324323L;

        private EffectList() {
            super(1);
        }
    }
}

