/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.Aura;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.NPC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class AbilitySlot
implements Saveable {
    private final String type;
    private boolean fixed;
    private String abilityID;
    private int cooldownRoundsLeft;
    private int activeRoundsLeft;
    private boolean active;
    private Creature parent;
    private List<Effect> activeEffects;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("ref", SaveGameUtil.getRef(this));
        jSONOrderedObject.put("type", this.type);
        if (this.fixed) {
            jSONOrderedObject.put("fixed", this.fixed);
        }
        if (this.abilityID != null) {
            jSONOrderedObject.put("abilityID", this.abilityID);
            if (this.active) {
                jSONOrderedObject.put("active", this.active);
            }
            if (this.activeRoundsLeft != 0) {
                jSONOrderedObject.put("activeRoundsLeft", this.activeRoundsLeft);
            }
            if (this.cooldownRoundsLeft != 0) {
                jSONOrderedObject.put("cooldownRoundsLeft", this.cooldownRoundsLeft);
            }
        }
        if (this.activeEffects.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Effect effect : this.activeEffects) {
                NPC nPC;
                if (effect.getTarget() instanceof NPC && (nPC = (NPC)effect.getTarget()).isDead()) continue;
                arrayList.add(SaveGameUtil.getRef(effect));
            }
            jSONOrderedObject.put("effects", arrayList.toArray());
        }
        return jSONOrderedObject;
    }

    public static AbilitySlot load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler, Creature creature) {
        AbilitySlot abilitySlot = new AbilitySlot(simpleJSONObject.get("type", null), creature);
        referenceHandler.add(simpleJSONObject.get("ref", null), abilitySlot);
        if (simpleJSONObject.containsKey("fixed")) {
            abilitySlot.fixed = simpleJSONObject.get("fixed", false);
        }
        if (simpleJSONObject.containsKey("abilityID")) {
            abilitySlot.abilityID = simpleJSONObject.get("abilityID", null);
            if (simpleJSONObject.containsKey("activeRoundsLeft")) {
                abilitySlot.activeRoundsLeft = simpleJSONObject.get("activeRoundsLeft", 0);
            }
            if (simpleJSONObject.containsKey("active")) {
                abilitySlot.active = simpleJSONObject.get("active", false);
            }
            if (simpleJSONObject.containsKey("cooldownRoundsLeft")) {
                abilitySlot.cooldownRoundsLeft = simpleJSONObject.get("cooldownRoundsLeft", 0);
            }
        }
        if (simpleJSONObject.containsKey("effects")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("effects")) {
                String string = simpleJSONArrayEntry.getString();
                referenceHandler.addEffectReference(abilitySlot, string);
            }
        }
        return abilitySlot;
    }

    public void loadActiveEffects(List<Effect> list) {
        this.activeEffects = list;
    }

    public AbilitySlot(String string, Creature creature) {
        this.type = string;
        this.fixed = false;
        this.abilityID = null;
        this.cooldownRoundsLeft = 0;
        this.activeRoundsLeft = 0;
        this.active = false;
        this.parent = creature;
        this.activeEffects = new ArrayList<Effect>();
    }

    public AbilitySlot(Ability ability, Creature creature) {
        this.type = ability.getType();
        this.fixed = true;
        this.abilityID = ability.getID();
        this.cooldownRoundsLeft = 0;
        this.activeRoundsLeft = 0;
        this.active = false;
        this.parent = creature;
        this.activeEffects = new ArrayList<Effect>();
    }

    public AbilitySlot(AbilitySlot abilitySlot, Creature creature) {
        this.type = abilitySlot.type;
        this.fixed = abilitySlot.fixed;
        this.abilityID = abilitySlot.abilityID;
        this.cooldownRoundsLeft = abilitySlot.cooldownRoundsLeft;
        this.activeRoundsLeft = abilitySlot.activeRoundsLeft;
        this.active = abilitySlot.active;
        this.parent = creature;
        this.activeEffects = new ArrayList<Effect>();
    }

    public String getType() {
        return this.type;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public Ability getAbility() {
        return Game.ruleset.getAbility(this.abilityID);
    }

    public String getAbilityID() {
        return this.abilityID;
    }

    public int getCooldownRoundsLeft() {
        return this.cooldownRoundsLeft;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getActiveRoundsLeft() {
        return this.activeRoundsLeft;
    }

    public Creature getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return this.abilityID == null;
    }

    public void setActiveRoundsLeft(int n) {
        this.activeRoundsLeft = n;
    }

    protected boolean setAbility(Ability ability) {
        if (ability == null) {
            return this.setAbility((String)null);
        }
        return this.setAbility(ability.getID());
    }

    protected boolean setAbility(String string) {
        if (!this.isSettable()) {
            return false;
        }
        if (this.abilityID != null && this.active) {
            if (this.getAbility().isCancelable()) {
                this.deactivate();
            } else {
                return false;
            }
        }
        this.active = false;
        this.activeRoundsLeft = 0;
        this.abilityID = string;
        return true;
    }

    public boolean isSettable() {
        if (this.fixed) {
            return false;
        }
        return this.abilityID == null || !this.active || this.getAbility().isCancelable();
    }

    public boolean hasActiveEffects() {
        return !this.activeEffects.isEmpty();
    }

    public void resetCooldown() {
        this.cooldownRoundsLeft = 0;
    }

    public boolean canActivate() {
        if (this.abilityID == null) {
            return false;
        }
        if (this.active) {
            return false;
        }
        if (this.cooldownRoundsLeft > 0) {
            return false;
        }
        if (!this.parent.timer.canPerformAction(this.getAbility().getAPCost())) {
            return false;
        }
        if (!Game.isInTurnMode() && !this.getAbility().canActivateOutsideCombat()) {
            return false;
        }
        if (this.getAbility().hasFunction(ScriptFunctionType.canActivate)) {
            Object object = this.getAbility().executeFunction(ScriptFunctionType.canActivate, this.parent);
            return Boolean.TRUE.equals(object);
        }
        return true;
    }

    public boolean canDeactivate() {
        if (this.abilityID == null) {
            return false;
        }
        return this.active && this.getAbility().isCancelable();
    }

    public void activate() {
        if (this.cooldownRoundsLeft > 0) {
            return;
        }
        if (this.getAbility().isMode()) {
            this.active = true;
            if (this.activeRoundsLeft == 0) {
                this.activeRoundsLeft = 0x3FFFFFFF;
            }
        }
        this.cooldownRoundsLeft = this.getAbility().getCooldown(this.parent) + this.activeRoundsLeft;
        this.getAbility().activate(this.getParent());
    }

    public void deactivate() {
        if (this.abilityID == null || !this.active) {
            return;
        }
        this.active = false;
        this.cooldownRoundsLeft = this.getAbility().getCooldown(this.parent);
        this.activeRoundsLeft = 0;
        Iterator<Effect> iterator = this.activeEffects.iterator();
        while (iterator.hasNext()) {
            Effect effect = iterator.next();
            if (!effect.removeOnDeactivate()) continue;
            effect.getTarget().removeEffect(effect);
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elapseRounds(int n) {
        if (this.cooldownRoundsLeft > 0) {
            this.cooldownRoundsLeft -= n;
        }
        if (this.activeRoundsLeft > 0) {
            this.activeRoundsLeft -= n;
            if (this.activeRoundsLeft <= 0) {
                this.deactivate();
            }
        }
        if (this.cooldownRoundsLeft < 0) {
            this.cooldownRoundsLeft = 0;
        }
        if (this.activeRoundsLeft < 0) {
            this.activeRoundsLeft = 0;
        }
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            int n2 = this.activeEffects.size();
            for (int i = 0; i < n2; ++i) {
                boolean bl;
                Effect effect = this.activeEffects.get(i);
                effect.elapseRounds(n);
                boolean bl2 = bl = effect.getRoundsRemaining() < 1 && !effect.removeOnDeactivate();
                if (effect.getTarget() != null) {
                    boolean bl3 = bl = bl || !effect.getTarget().isValidEffectTarget();
                    if (!bl) continue;
                    effect.getTarget().removeEffect(effect);
                    this.activeEffects.remove(i);
                    --i;
                    --n2;
                    continue;
                }
                this.activeEffects.remove(i);
                --i;
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllEffects() {
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            int n = this.activeEffects.size();
            for (int i = 0; i < n; ++i) {
                Effect effect = this.activeEffects.get(i);
                effect.getTarget().removeEffect(effect);
                if (n == this.activeEffects.size()) continue;
                --i;
                --n;
            }
            this.activeEffects.clear();
        }
        if (this.getAbility().isCancelable()) {
            this.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAllAuras() {
        boolean bl = false;
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            int n = this.activeEffects.size();
            for (int i = 0; i < n; ++i) {
                Effect effect = this.activeEffects.get(i);
                if (!(effect instanceof Aura)) continue;
                effect.getTarget().removeEffect(effect);
                this.activeEffects.remove(i);
                --i;
                --n;
                bl = true;
            }
        }
        if (bl && this.abilityID != null && this.getAbility().isCancelable()) {
            this.deactivate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Effect createEffect() {
        Effect effect = new Effect();
        effect.setSlot(this);
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            this.activeEffects.add(effect);
        }
        return effect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Effect createEffect(String string) {
        Effect effect = new Effect(string);
        effect.setSlot(this);
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            this.activeEffects.add(effect);
        }
        return effect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aura createAura(String string) {
        Aura aura = new Aura(string);
        aura.setSlot(this);
        List<Effect> list = this.activeEffects;
        synchronized (list) {
            this.activeEffects.add(aura);
        }
        return aura;
    }

    public String getLabelText() {
        int n = this.cooldownRoundsLeft - this.activeRoundsLeft;
        int n2 = this.activeRoundsLeft;
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0x1FFFFFFF) {
            stringBuilder.append("\u221e");
        } else if (n2 > 0) {
            stringBuilder.append(n2);
        }
        if (n > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.abilityID == null) {
            return "None";
        }
        return this.abilityID;
    }
}

