/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.util.Pointf;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class AbilitySelectionList {
    private final String id;
    private final String name;
    private final Map<Ability, Pointf> abilities;
    private final Map<String, Pointf> subLists;
    private List<Connector> connectors;

    public AbilitySelectionList(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        this.id = string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2);
        this.name = simpleJSONParser.get("name", null);
        if (simpleJSONParser.containsKey("subLists")) {
            this.subLists = new HashMap<String, Pointf>();
            object3 = simpleJSONParser.getObject("subLists");
            for (String object4 : ((SimpleJSONObject)object3).keySet()) {
                object2 = ((SimpleJSONObject)object3).getObject(object4);
                this.subLists.put(object4, new Pointf(((SimpleJSONObject)object2).get("x", 0.0f), ((SimpleJSONObject)object2).get("y", 0.0f)));
            }
        } else {
            this.subLists = Collections.emptyMap();
        }
        if (simpleJSONParser.containsKey("abilities")) {
            this.abilities = new HashMap<Ability, Pointf>();
            object3 = simpleJSONParser.getObject("abilities");
            for (String string3 : ((SimpleJSONObject)object3).keySet()) {
                object2 = Game.ruleset.getAbility(string3);
                if (object2 == null) {
                    throw new IllegalArgumentException("Ability " + string3 + " not found in selection list " + string);
                }
                object = ((SimpleJSONObject)object3).getObject(string3);
                this.abilities.put((Ability)object2, new Pointf(((SimpleJSONObject)object).get("x", 0.0f), ((SimpleJSONObject)object).get("y", 0.0f)));
            }
        } else {
            this.abilities = Collections.emptyMap();
        }
        if (simpleJSONParser.containsKey("connectors")) {
            this.connectors = new ArrayList<Connector>();
            object3 = simpleJSONParser.getArray("connectors");
            Iterator<Object> iterator = ((SimpleJSONArray)object3).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                object2 = simpleJSONArrayEntry.getObject();
                object = ConnectorType.valueOf(((SimpleJSONObject)object2).get("type", null));
                this.connectors.add(new Connector(((SimpleJSONObject)object2).get("x", 0.0f), ((SimpleJSONObject)object2).get("y", 0.0f), (ConnectorType)((Object)object)));
            }
        } else {
            this.connectors = Collections.emptyList();
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(Ability ability) {
        return this.abilities.containsKey(ability);
    }

    public Set<Ability> getAbilities() {
        return Collections.unmodifiableSet(this.abilities.keySet());
    }

    public Pointf getGridPosition(Ability ability) {
        return this.abilities.get(ability);
    }

    public Set<String> getSubListIDs() {
        return Collections.unmodifiableSet(this.subLists.keySet());
    }

    public List<Connector> getConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public Pointf getGridPosition(AbilitySelectionList abilitySelectionList) {
        if (!this.subLists.containsKey(abilitySelectionList.id)) {
            throw new IllegalArgumentException("SubList " + abilitySelectionList.id + " not contained in this list.");
        }
        return this.subLists.get(abilitySelectionList.id);
    }

    public class Connector {
        private final Pointf point;
        private final ConnectorType type;

        private Connector(float f, float f2, ConnectorType connectorType) {
            this.point = new Pointf(f, f2);
            this.type = connectorType;
        }

        public Pointf getPoint() {
            return this.point;
        }

        public ConnectorType getType() {
            return this.type;
        }
    }

    public static enum ConnectorType {
        OneUp,
        OneDown,
        TwoUp,
        TwoDown,
        ThreeUp,
        ThreeDown,
        FourUp,
        FourDown,
        Through;

    }
}

