/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Effect;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.ability.Spell;
import net.sf.hale.entity.Creature;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.rules.PrereqList;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Ability
extends Scriptable {
    private final String id;
    private final String name;
    private final String type;
    private final Icon icon;
    private final boolean isFixed;
    private final boolean isActivateable;
    private final boolean isMode;
    private final boolean isCancelable;
    private final boolean canActivateOutsideCombat;
    private final int cooldown;
    private final int actionPointCost;
    private final String actionPointCostDescription;
    private final PrereqList prereqs;
    private final ActionType actionType;
    private final GroupType groupType;
    private final RangeType rangeType;
    private final int aiPower;
    private final int aiPriority;
    private final String description;
    private Map<String, String> upgrades;
    private final int spellLevel;

    public static Ability createAbilityFromResource(String string, String string2) throws IllegalArgumentException {
        String string3;
        boolean bl;
        String string4;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2);
        boolean bl2 = simpleJSONParser.containsKey("isSpell") ? simpleJSONParser.get("isSpell", false) : false;
        if (!simpleJSONParser.containsKey("externalScript")) {
            if (bl2) {
                Logger.appendToWarningLog("Warning.  Script not specified for Spell " + string + " and inline scripts unsupported for spells.");
            }
            if (simpleJSONParser.containsKey("inlineScript")) {
                string4 = simpleJSONParser.get("inlineScript", null);
                bl = true;
            } else {
                string4 = null;
                bl = false;
            }
            string3 = string2;
        } else {
            string3 = simpleJSONParser.get("externalScript", null);
            string4 = ResourceManager.getScriptResourceAsString(string3);
            bl = false;
        }
        try {
            Ability ability = bl2 ? new Spell(string, string4, string3, simpleJSONParser.getObject()) : new Ability(string, string4, string3, simpleJSONParser.getObject(), bl);
            simpleJSONParser.warnOnUnusedKeys();
            return ability;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Error creating ability " + string + " from resource " + string2, illegalArgumentException);
        }
    }

    protected Ability(String string, String string2, String string3, SimpleJSONObject simpleJSONObject, boolean bl) {
        super(string2, string3, bl);
        String string42;
        this.id = string;
        this.name = simpleJSONObject.get("name", string);
        this.type = simpleJSONObject.get("type", this.getClass().getSimpleName());
        this.icon = simpleJSONObject.containsKey("icon") ? IconFactory.createIcon(simpleJSONObject.getObject("icon")) : IconFactory.emptyIcon;
        SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("description");
        this.description = simpleJSONObject2.get("base", null);
        this.upgrades = new HashMap<String, String>();
        if (simpleJSONObject2.containsKey("upgrades")) {
            SimpleJSONObject simpleJSONObject3 = simpleJSONObject2.getObject("upgrades");
            for (String string42 : simpleJSONObject3.keySet()) {
                this.upgrades.put(string42, simpleJSONObject3.get(string42, null));
            }
        }
        this.canActivateOutsideCombat = simpleJSONObject.containsKey("canActivateOutsideCombat") ? simpleJSONObject.get("canActivateOutsideCombat", false) : false;
        this.isActivateable = simpleJSONObject.containsKey("isActivateable") ? simpleJSONObject.get("isActivateable", false) : false;
        this.isFixed = simpleJSONObject.containsKey("isFixed") ? simpleJSONObject.get("isFixed", false) : false;
        this.isMode = simpleJSONObject.containsKey("isMode") ? simpleJSONObject.get("isMode", false) : false;
        this.isCancelable = simpleJSONObject.containsKey("isCancelable") ? simpleJSONObject.get("isCancelable", false) : false;
        this.spellLevel = simpleJSONObject.containsKey("spellLevel") ? simpleJSONObject.get("spellLevel", 0) : 0;
        if (!this.isActivateable && this.isMode) {
            Logger.appendToWarningLog("Ability at " + simpleJSONObject.getObjectID() + " is not activateable.  Mode=true flag will have no effect.");
        }
        if (!(this.isActivateable && this.isMode || !this.isCancelable)) {
            Logger.appendToWarningLog("Ability at " + simpleJSONObject.getObjectID() + " is not an activateable mode.  Cancelable=true flag will have no effect.");
        }
        if (!this.isActivateable && this.isFixed) {
            Logger.appendToWarningLog("Ability at " + simpleJSONObject.getObjectID() + " is not activateable.  Fixed=true flag will have no effect.");
        }
        this.cooldown = simpleJSONObject.containsKey("cooldown") ? simpleJSONObject.get("cooldown", 0) : 0;
        if (simpleJSONObject.isInteger("actionPointCost")) {
            this.actionPointCost = simpleJSONObject.get("actionPointCost", 0);
            this.actionPointCostDescription = Integer.toString(this.actionPointCost / 100);
        } else if (simpleJSONObject.isString("actionPointCost")) {
            this.actionPointCost = 0;
            this.actionPointCostDescription = simpleJSONObject.get("actionPointCost", null);
        } else {
            this.actionPointCost = 0;
            this.actionPointCostDescription = Integer.toString(this.actionPointCost / 100);
        }
        int n = 0;
        int n2 = 1;
        string42 = null;
        String string5 = null;
        String string6 = null;
        if (simpleJSONObject.containsKey("ai")) {
            SimpleJSONObject simpleJSONObject4 = simpleJSONObject.getObject("ai");
            if (simpleJSONObject4.containsKey("power")) {
                n = simpleJSONObject4.get("power", 0);
            }
            if (simpleJSONObject4.containsKey("priority")) {
                n2 = simpleJSONObject4.get("priority", 1);
            }
            if (simpleJSONObject4.containsKey("actionType")) {
                string42 = simpleJSONObject4.get("actionType", null);
                string5 = simpleJSONObject4.get("groupType", null);
                string6 = simpleJSONObject4.get("rangeType", null);
            }
        }
        this.actionType = string42 != null ? ActionType.valueOf(string42) : null;
        this.groupType = string5 != null ? GroupType.valueOf(string5) : null;
        this.rangeType = string6 != null ? RangeType.valueOf(string6) : null;
        this.aiPower = n;
        this.aiPriority = n2;
        this.prereqs = simpleJSONObject.containsKey("prereqs") ? new PrereqList(simpleJSONObject.getObject("prereqs")) : new PrereqList();
    }

    public boolean canActivateOutsideCombat() {
        return this.canActivateOutsideCombat;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public int getSpellLevel(Creature creature) {
        int n = this.spellLevel;
        if (creature == null) {
            return this.spellLevel;
        }
        for (String string : this.upgrades.keySet()) {
            if (!creature.abilities.has(string)) continue;
            n = Math.max(n, Game.ruleset.getAbility((String)string).spellLevel);
        }
        return n;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public boolean isActivateable() {
        return this.isActivateable;
    }

    public boolean isMode() {
        return this.isMode;
    }

    public boolean isCancelable() {
        return this.isCancelable;
    }

    public int getCooldown(Creature creature) {
        return this.cooldown;
    }

    public int getAPCost() {
        return this.actionPointCost;
    }

    public String getAPCostDescription() {
        return this.actionPointCostDescription;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public RangeType getUpgradedRangeType(Creature creature) {
        RangeType rangeType = this.rangeType;
        for (String string : this.upgrades.keySet()) {
            Ability ability;
            RangeType rangeType2;
            if (!creature.abilities.has(string) || (rangeType2 = (ability = Game.ruleset.getAbility(string)).getRangeType()).ordinal() <= rangeType.ordinal()) continue;
            rangeType = rangeType2;
        }
        return rangeType;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public GroupType getUpgradedGroupType(Creature creature) {
        GroupType groupType = this.groupType;
        for (String string : this.upgrades.keySet()) {
            Ability ability;
            GroupType groupType2;
            if (!creature.abilities.has(string) || (groupType2 = (ability = Game.ruleset.getAbility(string)).getGroupType()).ordinal() <= groupType.ordinal()) continue;
            groupType = groupType2;
        }
        return groupType;
    }

    public int getAIPriority() {
        return this.aiPriority;
    }

    public int getAIPower() {
        return this.aiPower;
    }

    public int getUpgradedAIPower(Creature creature) {
        int n = this.aiPower;
        for (String string : this.upgrades.keySet()) {
            if (!creature.abilities.has(string)) continue;
            Ability ability = Game.ruleset.getAbility(string);
            n = Math.max(n, ability.getAIPower());
        }
        return n;
    }

    public void activate(Creature creature) {
        creature.getEffects().executeOnAll(ScriptFunctionType.onAbilityActivated, this, creature);
        if (!(this instanceof Spell)) {
            Game.mainViewer.addMessage(creature.getTemplate().getName() + " uses " + this.getName() + ".");
        }
        Game.mainViewer.addFadeAway(this.getName(), creature.getLocation().getX(), creature.getLocation().getY(), new Color(-16711936));
        creature.timer.performAction(this.actionPointCost);
    }

    public boolean meetsPrereqs(Creature creature) {
        return this.prereqs.meetsPrereqs(creature);
    }

    private void appendUpgradesList(StringBuilder stringBuilder, Creature creature) {
        if (creature == null) {
            return;
        }
        int n = 0;
        for (String string : this.upgrades.keySet()) {
            Ability ability = Game.ruleset.getAbility(string);
            if (!creature.abilities.has(ability)) continue;
            if (n == 0) {
                stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em;\">");
                stringBuilder.append("Upgraded with ");
                ++n;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("<span style=\"font-family: medium-red\">");
            stringBuilder.append(ability.getName());
            stringBuilder.append("</span>");
        }
        if (n > 0) {
            stringBuilder.append("</div>");
        }
    }

    public void appendDetails(StringBuilder stringBuilder, Creature creature) {
        stringBuilder.append("<div style=\"font-family: medium; margin-bottom: 1em;\">");
        this.appendBaseType(stringBuilder);
        stringBuilder.append("</div>");
        this.appendUpgradesList(stringBuilder, creature);
        stringBuilder.append("<table style=\"font-family: medium; vertical-align: middle;\">");
        stringBuilder.append("<tr><td style=\"width: 10ex;\">Slot Type</td><td style=\"font-family: medium-green\">");
        stringBuilder.append(this.type).append("</td></tr>");
        if (this.isActivateable) {
            stringBuilder.append("<tr><td style=\"width: 10ex;\">AP Cost</td><td style=\"font-family: medium-blue\">");
            stringBuilder.append(this.actionPointCostDescription).append("</td></tr>");
            if (this.cooldown > 0) {
                stringBuilder.append("<tr><td style=\"width: 10ex;\">Cooldown</td><td style=\"font-family: medium-red\">");
                stringBuilder.append(this.cooldown).append(" Rounds</td></tr>");
            }
        }
        stringBuilder.append("</table>");
        this.prereqs.appendDescription(stringBuilder, creature);
    }

    public void appendUpgradesDescription(StringBuilder stringBuilder, Creature creature) {
        if (creature == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.upgrades.keySet()) {
            if (!creature.abilities.has(string)) continue;
            arrayList.add(this.upgrades.get(string));
        }
        for (String string : arrayList) {
            stringBuilder.append("<div style=\"margin-top: 1em\">");
            stringBuilder.append(string);
            stringBuilder.append("</div>");
        }
    }

    public String toString() {
        return this.name;
    }

    private void appendBaseType(StringBuilder stringBuilder) {
        if (this.isActivateable) {
            stringBuilder.append("<p><span style=\"font-family: medium-italic-red\">Active</span> Ability</p>");
            if (this.isMode) {
                stringBuilder.append("<p>");
                if (this.isCancelable) {
                    stringBuilder.append("<span style=\"font-family: medium-italic-blue\">Cancelable</span> ");
                }
                stringBuilder.append("Mode</p>");
            }
        } else {
            stringBuilder.append("<p><span style=\"font-family: medium-italic-red\">Passive</span> Ability</p>");
        }
    }

    public void setSpellDuration(Effect effect, Creature creature) {
    }

    public static enum RangeType {
        Personal,
        Touch,
        Short,
        Long;

    }

    public static enum GroupType {
        Single,
        Multiple;

    }

    public static enum ActionType {
        Buff,
        Heal,
        Debuff,
        Damage,
        Summon,
        Tactical;

    }
}

