/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilityActivateCallback;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Targeter;
import net.sf.hale.util.Logger;
import net.sf.hale.widgets.RightClickMenu;
import net.sf.hale.widgets.RightClickMenuLevel;

public class AIAbilitySlotSet {
    private List<AbilitySlot> sortedSlots = new ArrayList<AbilitySlot>();

    public AIAbilitySlotSet(Map<String, List<AbilitySlot>> map) {
        for (String string : map.keySet()) {
            for (AbilitySlot abilitySlot : map.get(string)) {
                if (!abilitySlot.canActivate() && !abilitySlot.canDeactivate()) continue;
                this.sortedSlots.add(abilitySlot);
            }
        }
        Collections.sort(this.sortedSlots, new AbilityComparator());
    }

    public int getNumAbilities() {
        return this.sortedSlots.size();
    }

    public List<AbilitySlot> getAllAbilitySlots() {
        return this.sortedSlots;
    }

    public List<AbilitySlot> getWithActionTypes(String[] stringArray) {
        HashSet<Ability.ActionType> hashSet = new HashSet<Ability.ActionType>();
        for (String string : stringArray) {
            try {
                hashSet.add(Ability.ActionType.valueOf(string));
            }
            catch (Exception exception) {
                Logger.appendToWarningLog("Error in AI ability set, action type " + string + " not found.");
            }
        }
        ArrayList arrayList = new ArrayList();
        for (AbilitySlot abilitySlot : this.sortedSlots) {
            if (!hashSet.contains((Object)abilitySlot.getAbility().getActionType())) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public List<AbilitySlot> getWithActionType(String string) {
        Ability.ActionType actionType;
        try {
            actionType = Ability.ActionType.valueOf(string);
        }
        catch (Exception exception) {
            Logger.appendToWarningLog("Error in AI ability set, action type " + string + " not found.");
            return Collections.emptyList();
        }
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        for (AbilitySlot abilitySlot : this.sortedSlots) {
            if (abilitySlot.getAbility().getActionType() != actionType) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public List<AbilitySlot> getWithGroupType(String string) {
        Ability.GroupType groupType;
        try {
            groupType = Ability.GroupType.valueOf(string);
        }
        catch (Exception exception) {
            Logger.appendToWarningLog("Error in AI ability set, group type " + string + " not found.");
            return Collections.emptyList();
        }
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        for (AbilitySlot abilitySlot : this.sortedSlots) {
            if (abilitySlot.getAbility().getGroupType() != groupType) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public List<AbilitySlot> getWithRangeType(String string) {
        Ability.RangeType rangeType;
        try {
            rangeType = Ability.RangeType.valueOf(string);
        }
        catch (Exception exception) {
            Logger.appendToWarningLog("Error in AI ability set, range type " + string + " not found.");
            return Collections.emptyList();
        }
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        for (AbilitySlot abilitySlot : this.sortedSlots) {
            if (abilitySlot.getAbility().getRangeType() != rangeType) continue;
            arrayList.add(abilitySlot);
        }
        return arrayList;
    }

    public void sortByRangeType(List<AbilitySlot> list, String string) {
        if (string.equals("CLOSEST")) {
            Collections.sort(list, new RangeSorter(1));
        } else if (string.equals("FURTHEST")) {
            Collections.sort(list, new RangeSorter(-1));
        } else {
            throw new IllegalArgumentException("Range type sort order must be either CLOSEST or FURTHEST");
        }
    }

    public void sortByGroupType(List<AbilitySlot> list, String string) {
        if (string.equals("SINGLE")) {
            Collections.sort(list, new GroupSorter(1));
        } else if (string.equals("MULTIPLE")) {
            Collections.sort(list, new GroupSorter(-1));
        } else {
            throw new IllegalArgumentException("Group type sort order must be either SINGLE or MULTIPLE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Targeter activateAndGetTargeter(AbilitySlot abilitySlot, String[] stringArray) {
        Targeter targeter = this.tryActivateSlotAndGetTargeter(abilitySlot);
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        if (targeter == null && (rightClickMenu.isOpen() || rightClickMenu.isOpening())) {
            Object object = rightClickMenu;
            synchronized (object) {
                rightClickMenu.hide();
            }
            object = rightClickMenu.getLowestMenuLevel();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                for (int j = 0; j < ((RightClickMenuLevel)((Object)object)).getNumSelections(); ++j) {
                    String string2 = ((RightClickMenuLevel)((Object)object)).getSelectionText(j);
                    if (!string2.equals(string)) continue;
                    ((RightClickMenuLevel)((Object)object)).activateSelection(j);
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (!bl) {
                ((RightClickMenuLevel)((Object)object)).activateSelection(Game.dice.rand(0, ((RightClickMenuLevel)((Object)object)).getNumSelections() - 1));
            }
        }
        return Game.areaListener.getTargeterManager().getCurrentTargeter();
    }

    public Targeter activateAndGetTargeter(AbilitySlot abilitySlot, String string) {
        String[] stringArray = new String[]{string};
        return this.activateAndGetTargeter(abilitySlot, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Targeter activateAndGetTargeter(AbilitySlot abilitySlot) {
        Targeter targeter = this.tryActivateSlotAndGetTargeter(abilitySlot);
        RightClickMenu rightClickMenu = Game.mainViewer.getMenu();
        if (targeter == null && (rightClickMenu.isOpen() || rightClickMenu.isOpening())) {
            Object object = rightClickMenu;
            synchronized (object) {
                rightClickMenu.hide();
            }
            object = rightClickMenu.getLowestMenuLevel();
            int n = ((RightClickMenuLevel)((Object)object)).getNumSelections();
            ((RightClickMenuLevel)((Object)object)).activateSelection(Game.dice.rand(0, n - 1));
        }
        return Game.areaListener.getTargeterManager().getCurrentTargeter();
    }

    private Targeter tryActivateSlotAndGetTargeter(AbilitySlot abilitySlot) {
        if (abilitySlot.canActivate()) {
            new AbilityActivateCallback(abilitySlot, ScriptFunctionType.onActivate).run();
        } else if (abilitySlot.canDeactivate()) {
            new AbilityActivateCallback(abilitySlot, ScriptFunctionType.onDeactivate).run();
        }
        return Game.areaListener.getTargeterManager().getCurrentTargeter();
    }

    private class AbilityComparator
    implements Comparator<AbilitySlot> {
        private AbilityComparator() {
        }

        @Override
        public int compare(AbilitySlot abilitySlot, AbilitySlot abilitySlot2) {
            return abilitySlot2.getAbility().getAIPriority() * abilitySlot2.getAbility().getUpgradedAIPower(abilitySlot2.getParent()) - abilitySlot.getAbility().getAIPriority() * abilitySlot.getAbility().getUpgradedAIPower(abilitySlot.getParent());
        }
    }

    private class RangeSorter
    implements Comparator<AbilitySlot> {
        private int sense;

        private RangeSorter(int n) {
            this.sense = n;
        }

        @Override
        public int compare(AbilitySlot abilitySlot, AbilitySlot abilitySlot2) {
            return this.sense * (abilitySlot.getAbility().getUpgradedRangeType(abilitySlot.getParent()).ordinal() - abilitySlot2.getAbility().getUpgradedRangeType(abilitySlot2.getParent()).ordinal());
        }
    }

    private class GroupSorter
    implements Comparator<AbilitySlot> {
        private int sense;

        private GroupSorter(int n) {
            this.sense = n;
        }

        @Override
        public int compare(AbilitySlot abilitySlot, AbilitySlot abilitySlot2) {
            return this.sense * (abilitySlot.getAbility().getUpgradedGroupType(abilitySlot.getParent()).ordinal() - abilitySlot2.getAbility().getUpgradedGroupType(abilitySlot2.getParent()).ordinal());
        }
    }
}

