/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.LinkedList;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.Targeter;

public class TargeterManager {
    private Targeter currentTargeter;
    private LinkedList<Targeter> queuedTargeters = new LinkedList();

    public boolean isInTargetMode() {
        return this.currentTargeter != null;
    }

    public void addTargeter(Targeter targeter) {
        AbilitySlot abilitySlot = targeter.getSlot();
        if (abilitySlot != null && this.isInTargetMode()) {
            if (abilitySlot == this.currentTargeter.getSlot()) {
                return;
            }
            for (Targeter targeter2 : this.queuedTargeters) {
                if (abilitySlot != targeter2.getSlot()) continue;
                return;
            }
        }
        if (this.isInTargetMode()) {
            this.queuedTargeters.add(targeter);
        } else {
            this.setTargeter(targeter);
        }
    }

    public void endCurrentTargeter() {
        if (this.currentTargeter == null) {
            return;
        }
        if (!this.currentTargeter.hasSelectedTargets()) {
            return;
        }
        this.nextTargeter();
    }

    public void cancelCurrentTargeter() {
        if (this.currentTargeter == null) {
            return;
        }
        if (!this.currentTargeter.isCancelable()) {
            return;
        }
        this.nextTargeter();
    }

    public void checkCurrentTargeter() {
        if (this.currentTargeter != null && !this.currentTargeter.checkValid()) {
            this.cancelCurrentTargeter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextTargeter() {
        block4: {
            while (this.queuedTargeters.size() > 0) {
                boolean bl = this.setTargeter(this.queuedTargeters.getFirst());
                this.queuedTargeters.removeFirst();
                if (!bl) continue;
                break block4;
            }
            this.setTargeter(null);
            TargeterManager targeterManager = this;
            synchronized (targeterManager) {
                this.notifyAll();
            }
            Game.areaListener.computeMouseState();
        }
    }

    private boolean setTargeter(Targeter targeter) {
        if (targeter == null) {
            this.currentTargeter = null;
        } else {
            if (!targeter.checkValid()) {
                return false;
            }
            this.currentTargeter = targeter;
            targeter.setMousePosition(Game.areaListener.getLastMouseX(), Game.areaListener.getLastMouseY(), Game.mainViewer.getMouseGridPoint());
        }
        Game.mainViewer.updateInterface();
        Game.areaListener.computeMouseState();
        return true;
    }

    public Targeter getCurrentTargeter() {
        return this.currentTargeter;
    }
}

