/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.HashMap;
import java.util.Map;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SimpleJSONObject;

public class ScriptState
implements Saveable {
    public Map<String, Object> state = new HashMap<String, Object>();

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        for (String string : this.state.keySet()) {
            jSONOrderedObject.put(string, this.state.get(string));
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        for (String string : simpleJSONObject.keySet()) {
            if (simpleJSONObject.isString(string)) {
                this.state.put(string, simpleJSONObject.get(string, null));
                continue;
            }
            if (simpleJSONObject.isInteger(string)) {
                this.state.put(string, simpleJSONObject.get(string, 0));
                continue;
            }
            if (simpleJSONObject.isFloat(string)) {
                this.state.put(string, Float.valueOf(simpleJSONObject.get(string, 0.0f)));
                continue;
            }
            if (!simpleJSONObject.isBoolean(string)) continue;
            this.state.put(string, simpleJSONObject.get(string, false));
        }
    }

    public ScriptState(ScriptState scriptState) {
        this();
        for (String string : scriptState.state.keySet()) {
            this.state.put(string, scriptState.state.get(string));
        }
    }

    public ScriptState() {
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public Object get(String string) {
        return this.state.get(string);
    }

    public void put(String string, Object object) {
        if (object instanceof String) {
            this.state.put(string, object);
        } else if (object instanceof Number) {
            this.state.put(string, object);
        } else if (object instanceof Boolean) {
            this.state.put(string, object);
        } else {
            throw new IllegalArgumentException("Only strings, numbers, or booleans may be stored in script state.");
        }
    }
}

