/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.io.IOException;
import net.sf.hale.AIScriptInterface;
import net.sf.hale.CombatRunner;
import net.sf.hale.Cutscene;
import net.sf.hale.DelayedAttackCallback;
import net.sf.hale.Game;
import net.sf.hale.HasScriptState;
import net.sf.hale.Party;
import net.sf.hale.ability.AbilityActivateCallback;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.CircleTargeter;
import net.sf.hale.ability.ConeTargeter;
import net.sf.hale.ability.DelayedScriptCallback;
import net.sf.hale.ability.LineTargeter;
import net.sf.hale.ability.ListTargeter;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.area.Area;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.CreatedItemModel;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.NPC;
import net.sf.hale.entity.PC;
import net.sf.hale.interfacelock.InterfaceLock;
import net.sf.hale.particle.AngleDistributionBase;
import net.sf.hale.particle.Animation;
import net.sf.hale.particle.CircleParticleGenerator;
import net.sf.hale.particle.DistanceDistributionBase;
import net.sf.hale.particle.DistributionBase;
import net.sf.hale.particle.EquallySpacedAngleDistribution;
import net.sf.hale.particle.FixedAngleDistribution;
import net.sf.hale.particle.FixedDistribution;
import net.sf.hale.particle.FixedDistributionWithBase;
import net.sf.hale.particle.GaussianAngleDistribution;
import net.sf.hale.particle.GaussianDistribution;
import net.sf.hale.particle.GaussianDistributionWithBase;
import net.sf.hale.particle.LineParticleGenerator;
import net.sf.hale.particle.ParticleGenerator;
import net.sf.hale.particle.RectParticleGenerator;
import net.sf.hale.particle.SpeedDistributionBase;
import net.sf.hale.particle.UniformAngleDistribution;
import net.sf.hale.particle.UniformArcDistribution;
import net.sf.hale.particle.UniformDistribution;
import net.sf.hale.particle.UniformDistributionWithBase;
import net.sf.hale.particle.VelocityTowardsPointDistribution;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.rules.Attack;
import net.sf.hale.rules.Campaign;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Date;
import net.sf.hale.rules.Dice;
import net.sf.hale.rules.Faction;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.QuestEntry;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.rules.WorldMapLocation;
import net.sf.hale.rules.XP;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.view.CampaignConclusionPopup;
import net.sf.hale.view.ConversationPopup;
import net.sf.hale.view.CutscenePopup;
import net.sf.hale.widgets.HTMLPopup;

public class ScriptInterface
implements HasScriptState {
    public static boolean SpawnRandomEncounters = true;
    public static AIScriptInterface ai;

    public static void setEncounterSpawningEnabled(boolean bl) {
        SpawnRandomEncounters = bl;
    }

    public static void writeMessageLog() {
        try {
            FileUtil.writeStringToFile(new File("message.html"), Game.mainViewer.getMessageBoxContents());
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error writing message log", iOException);
        }
    }

    public static void addMessage(String string) {
        Game.mainViewer.addMessage(string);
    }

    public static void addMessage(String string, String string2) {
        Game.mainViewer.addMessage(string, string2);
    }

    public static void addEncounterToArea(String string, int n, int n2) {
        Encounter encounter = Game.curCampaign.getEncounter(string, new Location(Game.curCampaign.curArea, n, n2));
        encounter.checkSpawnCreatures();
        Game.curCampaign.curArea.setEntityVisibility();
        Game.areaListener.getCombatRunner().checkAIActivation();
    }

    public static void addItemToArea(Item item, Location location) {
        item.setLocation(location);
        Game.curCampaign.curArea.addItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rangedTouchAttack(Creature creature, Creature creature2) {
        boolean bl;
        block6: {
            bl = false;
            try {
                DelayedAttackCallback delayedAttackCallback = Game.areaListener.getCombatRunner().creatureTouchAttack(creature, creature2, true);
                if (delayedAttackCallback == null) break block6;
                DelayedAttackCallback delayedAttackCallback2 = delayedAttackCallback;
                synchronized (delayedAttackCallback2) {
                    while (delayedAttackCallback.isAlive()) {
                        delayedAttackCallback.wait();
                    }
                }
                bl = delayedAttackCallback.isAttackHit();
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error performing ranged touch attack.", exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean meleeTouchAttack(Creature creature, Creature creature2) {
        boolean bl;
        block6: {
            bl = false;
            try {
                DelayedAttackCallback delayedAttackCallback = Game.areaListener.getCombatRunner().creatureTouchAttack(creature, creature2, false);
                if (delayedAttackCallback == null) break block6;
                DelayedAttackCallback delayedAttackCallback2 = delayedAttackCallback;
                synchronized (delayedAttackCallback2) {
                    while (delayedAttackCallback.isAlive()) {
                        delayedAttackCallback.wait();
                    }
                }
                bl = delayedAttackCallback.isAttackHit();
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error performing melee touch attack.", exception);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean singleAttackAnimate(Creature creature, Creature creature2) {
        boolean bl;
        block6: {
            bl = false;
            try {
                DelayedAttackCallback delayedAttackCallback = Game.areaListener.getCombatRunner().creatureSingleAttackAnimate(creature, creature2, Inventory.Slot.MainHand);
                if (delayedAttackCallback == null) break block6;
                DelayedAttackCallback delayedAttackCallback2 = delayedAttackCallback;
                synchronized (delayedAttackCallback2) {
                    while (delayedAttackCallback.isAlive()) {
                        delayedAttackCallback.wait();
                    }
                }
                bl = delayedAttackCallback.isAttackHit();
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
        }
        return bl;
    }

    public static Attack getAttack(Creature creature, Creature creature2, String string) {
        Attack attack = creature.performSingleAttack(creature2, Inventory.Slot.valueOf(string));
        attack.computeFlankingBonus(Game.curCampaign.curArea.getEntities());
        attack.computeIsHit();
        return attack;
    }

    public static Attack getMainHandAttack(Creature creature, Creature creature2) {
        return ScriptInterface.getAttack(creature, creature2, Inventory.Slot.MainHand.toString());
    }

    public static Attack getOffHandAttack(Creature creature, Creature creature2) {
        return ScriptInterface.getAttack(creature, creature2, Inventory.Slot.OffHand.toString());
    }

    public static void singleAttack(Creature creature, Point point) {
        ScriptInterface.singleAttack(creature, Game.curCampaign.curArea.getCreatureAtGridPoint(point));
    }

    public static void singleAttack(Creature creature, Creature creature2) {
        Game.areaListener.getCombatRunner().creatureSingleAttack(creature, creature2, Inventory.Slot.MainHand);
    }

    public static void singleAttack(Creature creature, Creature creature2, String string) {
        Game.areaListener.getCombatRunner().creatureSingleAttack(creature, creature2, Inventory.Slot.valueOf(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean standardAttack(Creature creature, Creature creature2) {
        boolean bl;
        block13: {
            bl = false;
            try {
                Object object;
                DelayedAttackCallback delayedAttackCallback = null;
                if (creature.timer.canAttack()) {
                    delayedAttackCallback = Game.areaListener.getCombatRunner().creatureStandardAttack(creature, creature2);
                }
                if (delayedAttackCallback != null) {
                    object = delayedAttackCallback;
                    synchronized (object) {
                        while (delayedAttackCallback.isAlive()) {
                            delayedAttackCallback.wait();
                        }
                    }
                    bl = delayedAttackCallback.isAttackHit();
                }
                if (creature instanceof PC) break block13;
                object = Game.areaListener.getTargeterManager();
                synchronized (object) {
                    while (Game.areaListener.getTargeterManager().isInTargetMode()) {
                        Game.areaListener.getTargeterManager().wait();
                    }
                }
                Thread.sleep(Game.config.getCombatDelay() * 3);
            }
            catch (InterruptedException interruptedException) {
                bl = false;
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error executing standard attack", exception);
                return false;
            }
        }
        return bl;
    }

    public static boolean creatureCanTouchTarget(Creature creature, Creature creature2) {
        if (creature2 == null || creature == null) {
            return false;
        }
        if (creature == creature2) {
            return true;
        }
        return creature.getLocation().getDistance(creature2) <= 1;
    }

    public static Creature createSummon(String string, Creature creature, int n) {
        NPC nPC = EntityManager.getNPC(string);
        nPC.setFaction(creature.getFaction());
        if (creature.isPlayerFaction()) {
            Game.curCampaign.party.addSummon(nPC);
        } else {
            nPC.setEncounter(creature.getEncounter());
            creature.getEncounter().getCreaturesInArea().add(nPC);
        }
        nPC.setSummoned(n);
        return nPC;
    }

    public static void finishSummon(NPC nPC, Location location) {
        nPC.resetTime();
        if (location.isPassable() && location.getCreature() == null) {
            nPC.setLocation(location);
            location.getArea().getEntities().addEntity(nPC);
        }
        if (Game.isInTurnMode()) {
            Game.areaListener.getCombatRunner().insertCreature(nPC);
        }
        Game.mainViewer.updateInterface();
        Game.areaListener.getCombatRunner().checkAIActivation();
    }

    public static void finishSummon(NPC nPC, Point point) {
        ScriptInterface.finishSummon(nPC, new Location(Game.curCampaign.curArea, point));
    }

    public static void performSearchChecksForCreature(Creature creature, int n) {
        if (!creature.stats.isHidden()) {
            return;
        }
        for (Creature creature2 : creature.getLocation().getArea().getEntities().getCreaturesWithinRadius(creature.getLocation().getX(), creature.getLocation().getY(), Game.curCampaign.curArea.getVisibilityRadius())) {
            if (creature2.getFaction().getRelationship(creature.getFaction()) != Faction.Relationship.Hostile || !creature2.hasVisibility(creature.getLocation()) || !creature2.performSearchCheck(creature, n)) continue;
            Game.mainViewer.addFadeAway("Spotted", creature.getLocation().getX(), creature.getLocation().getY(), new Color(-5527127));
            break;
        }
    }

    public static boolean creatureCanAttackTarget(Creature creature, Creature creature2) {
        if (creature2 == null || creature == null) {
            return false;
        }
        if (creature == creature2) {
            return false;
        }
        if (!creature.timer.canAttack()) {
            return false;
        }
        return creature.canAttack(creature2.getLocation());
    }

    public static Currency getPartyCurrency() {
        return Game.curCampaign.partyCurrency;
    }

    public static Party getParty() {
        return Game.curCampaign.party;
    }

    public static void moveCreature(Creature creature, int n, int n2) {
        creature.setLocation(new Location(creature.getLocation().getArea(), n, n2));
        Game.areaListener.getCombatRunner().checkAIActivation();
    }

    public static void showMerchant(String string) {
        Merchant merchant = Game.curCampaign.getMerchant(string);
        if (merchant == null) {
            Logger.appendToErrorLog("Error locating merchant: " + string);
            return;
        }
        Game.mainViewer.setMerchant(merchant);
        Game.mainViewer.merchantWindow.setVisible(true);
    }

    public static boolean hasQuestEntry(String string) {
        return Game.curCampaign.questEntries.hasEntry(string);
    }

    public static QuestEntry getQuestEntry(String string) {
        if (Game.curCampaign.questEntries.hasEntry(string)) {
            return Game.curCampaign.questEntries.getEntry(string);
        }
        QuestEntry questEntry = new QuestEntry(string);
        Game.curCampaign.questEntries.addEntry(questEntry);
        return questEntry;
    }

    public static void addPartyXP(int n) {
        XP.addPartyXP(n);
    }

    public static void runExternalScript(String string, String string2) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        scriptable.executeFunction(string2, new Object[0]);
    }

    public static void runExternalScript(String string, String string2, Object object) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        scriptable.executeFunction(string2, object);
    }

    public static void runExternalScript(String string, String string2, Object[] objectArray) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        scriptable.executeFunction(string2, objectArray);
    }

    public static void runExternalScriptWait(String string, String string2, float f) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        delayedScriptCallback.setDelay(f);
        delayedScriptCallback.start();
    }

    public static void runExternalScriptWait(String string, String string2, float f, Object object) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        delayedScriptCallback.setDelay(f);
        delayedScriptCallback.addArgument(object);
        delayedScriptCallback.start();
    }

    public static void runExternalScriptWait(String string, String string2, float f, Object[] objectArray) {
        String string3 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string3, string, false);
        DelayedScriptCallback delayedScriptCallback = new DelayedScriptCallback(scriptable, string2);
        delayedScriptCallback.setDelay(f);
        delayedScriptCallback.addArguments(objectArray);
        delayedScriptCallback.start();
    }

    public static void revealAllWorldMapLocations() {
        for (WorldMapLocation worldMapLocation : Game.curCampaign.worldMapLocations) {
            if (worldMapLocation.isRevealed()) continue;
            worldMapLocation.setRevealed(true);
        }
        Game.mainViewer.addMessage("link", "A new location has been added to your world map.");
    }

    public static void revealWorldMapLocation(String string) {
        WorldMapLocation worldMapLocation = Game.curCampaign.getWorldMapLocation(string);
        if (worldMapLocation != null) {
            if (!worldMapLocation.isRevealed()) {
                worldMapLocation.setRevealed(true);
                Game.mainViewer.addMessage("link", "A new location has been added to your world map.");
            }
        } else {
            Logger.appendToErrorLog("Error revealing world map location.  " + string + " not found.");
        }
    }

    public static void activateTransition(String string) {
        Transition transition = Game.curCampaign.getAreaTransition(string);
        if (transition == null) {
            Logger.appendToErrorLog("Error activating area transition.  " + string + " not found.");
        } else {
            transition.activate();
        }
    }

    public static CircleTargeter createCircleTargeter(Creature creature, Scriptable scriptable) {
        return new CircleTargeter(creature, scriptable, null);
    }

    public static ListTargeter createListTargeter(Creature creature, Scriptable scriptable) {
        return new ListTargeter(creature, scriptable, null);
    }

    public static LineTargeter createLineTargeter(Creature creature, Scriptable scriptable) {
        return new LineTargeter(creature, scriptable, null);
    }

    public static ConeTargeter createConeTargeter(Creature creature, Scriptable scriptable) {
        return new ConeTargeter(creature, scriptable, null);
    }

    public static CircleTargeter createCircleTargeter(AbilitySlot abilitySlot) {
        return new CircleTargeter(abilitySlot.getParent(), abilitySlot.getAbility(), abilitySlot);
    }

    public static ListTargeter createListTargeter(AbilitySlot abilitySlot) {
        return new ListTargeter(abilitySlot.getParent(), abilitySlot.getAbility(), abilitySlot);
    }

    public static LineTargeter createLineTargeter(AbilitySlot abilitySlot) {
        return new LineTargeter(abilitySlot.getParent(), abilitySlot.getAbility(), abilitySlot);
    }

    public static ConeTargeter createConeTargeter(AbilitySlot abilitySlot) {
        return new ConeTargeter(abilitySlot.getParent(), abilitySlot.getAbility(), abilitySlot);
    }

    public static AbilityActivateCallback createButtonCallback(AbilitySlot abilitySlot, String string) {
        AbilityActivateCallback abilityActivateCallback = new AbilityActivateCallback(abilitySlot, string);
        return abilityActivateCallback;
    }

    public static void addMenuButton(String string, AbilityActivateCallback abilityActivateCallback) {
        Button button = new Button(string);
        button.addCallback((Runnable)abilityActivateCallback);
        Game.mainViewer.getMenu().addButton(button);
    }

    public static void showMenu() {
        Game.mainViewer.getMenu().show();
    }

    public static boolean addMenuLevel(String string) {
        return Game.mainViewer.getMenu().addMenuLevel(string);
    }

    public static void hideOpenWindows() {
        Game.mainViewer.closeAllWindows();
    }

    public static void startConversation(Entity entity, Entity entity2, String string) {
        String string2 = ResourceManager.getScriptResourceAsString(string);
        Scriptable scriptable = new Scriptable(string2, string, false);
        ConversationPopup conversationPopup = new ConversationPopup(entity, entity2, scriptable);
        conversationPopup.startConversation();
    }

    public static void showCutscene(String string) {
        Cutscene cutscene = Game.ruleset.getCutscene(string);
        if (cutscene == null) {
            Logger.appendToWarningLog("Cutscene " + string + " not found");
            return;
        }
        CutscenePopup cutscenePopup = new CutscenePopup((Widget)Game.mainViewer, cutscene);
        Game.mainViewer.showPopup(cutscenePopup);
    }

    public static HTMLPopup createHTMLPopup(String string) {
        try {
            HTMLPopup hTMLPopup = new HTMLPopup(string);
            return hTMLPopup;
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error creating HTML popup", exception);
            return null;
        }
    }

    public static CombatRunner combatRunner() {
        return Game.areaListener.getCombatRunner();
    }

    public static Campaign campaign() {
        return Game.curCampaign;
    }

    public static Ruleset ruleset() {
        return Game.ruleset;
    }

    public static Area currentArea() {
        return Game.curCampaign.curArea;
    }

    public static Area getArea(String string) {
        return Game.curCampaign.getArea(string);
    }

    public static Dice dice() {
        return Game.dice;
    }

    public static Date date() {
        return Game.curCampaign.getDate();
    }

    public static boolean isInCombatMode() {
        return Game.isInTurnMode();
    }

    public void sleepStandardDelay(int n) {
        try {
            Thread.sleep(Game.config.getCombatDelay() * n);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public ParticleGenerator createParticleGenerator(String string, String string2, String string3, float f) {
        if (string.equalsIgnoreCase("Point")) {
            return new ParticleGenerator(ParticleGenerator.Mode.valueOf(string2), string3, f);
        }
        if (string.equalsIgnoreCase("Line")) {
            return new LineParticleGenerator(ParticleGenerator.Mode.valueOf(string2), string3, f);
        }
        if (string.equalsIgnoreCase("Rect")) {
            return new RectParticleGenerator(ParticleGenerator.Mode.valueOf(string2), string3, f);
        }
        if (string.equalsIgnoreCase("Circle")) {
            return new CircleParticleGenerator(ParticleGenerator.Mode.valueOf(string2), string3, f);
        }
        return null;
    }

    public Animation createAnimation(String string) {
        return new Animation(string);
    }

    public Animation createAnimation(String string, float f) {
        try {
            return new Animation(string, f);
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error creating animation.", exception);
            return null;
        }
    }

    public Animation getBaseAnimation(String string) {
        return Game.particleManager.getAnimation(string);
    }

    public ParticleGenerator getBaseParticleGenerator(String string) {
        return Game.particleManager.getParticleGenerator(string);
    }

    public void runAnimationWait(Animation animation) {
        Game.particleManager.add(animation);
        try {
            Thread.sleep((long)(animation.getSecondsRemaining() * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void runAnimationNoWait(Animation animation) {
        Game.particleManager.add(animation);
    }

    public void runParticleGeneratorWait(ParticleGenerator particleGenerator) {
        Game.particleManager.add(particleGenerator);
        try {
            Thread.sleep((long)(particleGenerator.getTimeLeft() * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void runParticleGeneratorNoWait(ParticleGenerator particleGenerator) {
        Game.particleManager.add(particleGenerator);
    }

    public EquallySpacedAngleDistribution getEquallySpacedAngleDistribution(float f, float f2, float f3, float f4, float f5) {
        return new EquallySpacedAngleDistribution(f, f2, f3, f4, f5);
    }

    public FixedDistribution getFixedDistribution(float f) {
        return new FixedDistribution(f);
    }

    public GaussianDistribution getGaussianDistribution(float f, float f2) {
        return new GaussianDistribution(f, f2);
    }

    public GaussianDistributionWithBase getGaussianDistributionWithBase(DistributionBase distributionBase, float f, float f2, float f3) {
        return new GaussianDistributionWithBase(distributionBase, f, f2, f3);
    }

    public DistanceDistributionBase getDistanceDistributionBase(Point point) {
        return new DistanceDistributionBase(point);
    }

    public SpeedDistributionBase getSpeedDistributionBase() {
        return new SpeedDistributionBase();
    }

    public AngleDistributionBase getAngleDistributionBase() {
        return new AngleDistributionBase();
    }

    public VelocityTowardsPointDistribution getVelocityTowardsPointDistribution(Point point, float f) {
        return new VelocityTowardsPointDistribution(point, f);
    }

    public UniformAngleDistribution getUniformAngleDistribution(float f, float f2) {
        return new UniformAngleDistribution(f, f2);
    }

    public GaussianAngleDistribution getGaussianAngleDistribution(float f, float f2) {
        return new GaussianAngleDistribution(f, f2);
    }

    public UniformArcDistribution getUniformArcDistribution(float f, float f2, float f3, float f4) {
        return new UniformArcDistribution(f, f2, f3, f4);
    }

    public FixedAngleDistribution getFixedAngleDistribution(float f, float f2, float f3) {
        return new FixedAngleDistribution(f, f2, f3);
    }

    public UniformDistribution getUniformDistribution(float f, float f2) {
        return new UniformDistribution(f, f2);
    }

    public UniformDistributionWithBase getUniformDistributionWithBase(DistributionBase distributionBase, float f, float f2, float f3) {
        return new UniformDistributionWithBase(distributionBase, f, f2, f3);
    }

    public FixedDistributionWithBase getFixedDistributionWithBase(DistributionBase distributionBase, float f, float f2) {
        return new FixedDistributionWithBase(distributionBase, f, f2);
    }

    @Override
    public void put(String string, Object object) {
        Game.curCampaign.scriptState.put(string, object);
    }

    @Override
    public Object get(String string) {
        return Game.curCampaign.scriptState.get(string);
    }

    public void lockInterface(float f) {
        InterfaceLock interfaceLock = new InterfaceLock(null, (long)(1000.0f * f));
        Game.interfaceLocker.add(interfaceLock);
        Game.interfaceLocker.interruptMovement();
    }

    public void clearRevealedAreas() {
        Game.timer.clearTemporarySightAreas();
    }

    public void revealArea(int n, int n2, int n3, int n4) {
        Game.timer.addTemporarySightArea(new Point(n, n2), n3, n4);
    }

    public void setFactionRelationship(String string, String string2, String string3) {
        Faction.CustomRelationship customRelationship = new Faction.CustomRelationship(string, string2, string3);
        customRelationship.setFactionRelationships();
        Game.curCampaign.addCustomRelationship(customRelationship);
        Game.areaListener.getCombatRunner().checkAIActivation();
    }

    public void unlockInterface() {
        Game.interfaceLocker.clear();
    }

    public void scrollToPosition(int n, int n2) {
        Point point = AreaUtil.convertGridToScreenAndCenter(n, n2);
        Game.areaViewer.addDelayedScrollToScreenPoint(point);
    }

    public void scrollToCreature(String string) {
        Game.areaViewer.addDelayedScrollToCreature(Game.curCampaign.curArea.getEntityWithID(string));
    }

    public void scrollToCreature(Entity entity) {
        Game.areaViewer.addDelayedScrollToCreature(entity);
    }

    public void exitToMainMenu() {
        Game.mainViewer.exitToMainMenu();
    }

    public void shakeScreen() {
        Game.areaViewer.addScreenShake();
    }

    public CampaignConclusionPopup showCampaignConclusionPopup() {
        CampaignConclusionPopup campaignConclusionPopup = new CampaignConclusionPopup((Widget)Game.mainViewer);
        return campaignConclusionPopup;
    }

    public NPC getNPC(String string) {
        return EntityManager.getNPC(string);
    }

    public Item getItem(String string, Quality quality) {
        return EntityManager.getItem(string, quality);
    }

    public Item getItem(String string, String string2) {
        return EntityManager.getItem(string, string2);
    }

    public CreatedItemModel getCreatedItemModel(String string, String string2) {
        return new CreatedItemModel(string, string2);
    }
}

