/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.SaveWriter;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONParser;

public class SavedParty {
    private final List<String> characters;
    private final int currencyInCP;
    private final int maxLevel;
    private final int minLevel;
    private final String id;
    private final String name;
    private final String resourceLocation;

    public SavedParty(String string, String string2) {
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(new File(string));
        this.resourceLocation = string;
        this.id = string2;
        this.name = simpleJSONParser.get("name", string2);
        this.currencyInCP = simpleJSONParser.get("currency", 0);
        this.maxLevel = simpleJSONParser.get("maxLevel", 0);
        this.minLevel = simpleJSONParser.get("minLevel", 0);
        this.characters = new ArrayList<String>();
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("characters");
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            this.characters.add(simpleJSONArrayEntry.getString());
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    public SavedParty(List<String> list, String string, int n, int n2, int n3) {
        this.name = string;
        this.currencyInCP = n3;
        this.maxLevel = n2;
        this.minLevel = n;
        this.characters = new ArrayList<String>(list);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");
        this.id = string + "-" + simpleDateFormat.format(Calendar.getInstance().getTime());
        this.resourceLocation = Game.getPartiesBaseDirectory() + this.id + ResourceType.JSON.getExtension();
    }

    public int size() {
        return this.characters.size();
    }

    public List<String> getCharacterIDs() {
        return Collections.unmodifiableList(this.characters);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCurrency() {
        return this.currencyInCP;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void writeToFile() {
        File file = new File(this.resourceLocation);
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", this.name);
        jSONOrderedObject.put("currency", this.currencyInCP);
        jSONOrderedObject.put("maxLevel", this.maxLevel);
        jSONOrderedObject.put("minLevel", this.minLevel);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.characters) {
            arrayList.add(string);
        }
        jSONOrderedObject.put("characters", arrayList.toArray());
        try {
            file.createNewFile();
            PrintWriter printWriter = new PrintWriter(file);
            SaveWriter.writeJSON(jSONOrderedObject, printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error writing party", exception);
        }
    }

    public void deleteFile() {
        File file = new File(this.resourceLocation);
        file.delete();
    }
}

