/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.NPC;
import net.sf.hale.entity.PC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Party
implements Iterable<PC>,
Saveable {
    public static final int MaxQuickBarSlots = 100;
    private boolean recomputePortraits = true;
    private String name;
    private final List<PC> characters = new ArrayList<PC>();
    private final List<NPC> summons = new ArrayList<NPC>();
    private int selectedCharacterIndex = -1;
    private boolean defeated;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", this.name);
        jSONOrderedObject.put("selectedCharacter", this.selectedCharacterIndex);
        if (this.defeated) {
            jSONOrderedObject.put("defeated", this.defeated);
        }
        Object[] objectArray = new Object[this.characters.size()];
        int n = 0;
        for (Creature creature : this.characters) {
            objectArray[n] = SaveGameUtil.getRef(creature);
            ++n;
        }
        jSONOrderedObject.put("characters", objectArray);
        if (this.summons.size() > 0) {
            Object[] objectArray2 = new Object[this.summons.size()];
            for (n = 0; n < this.summons.size(); ++n) {
                objectArray2[n] = SaveGameUtil.getRef(this.summons.get(n));
            }
            jSONOrderedObject.put("summons", objectArray2);
        }
        return jSONOrderedObject;
    }

    public static Party load(SimpleJSONObject simpleJSONObject, ReferenceHandler referenceHandler) {
        Creature creature;
        String string;
        Party party = new Party();
        party.name = simpleJSONObject.get("name", null);
        party.selectedCharacterIndex = simpleJSONObject.get("selectedCharacter", 0);
        if (simpleJSONObject.containsKey("defeated")) {
            party.defeated = simpleJSONObject.get("defeated", false);
        }
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("characters")) {
            string = simpleJSONArrayEntry.getString();
            creature = (PC)referenceHandler.getEntity(string);
            creature.setFaction(Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction")));
            party.characters.add((PC)creature);
        }
        if (simpleJSONObject.containsKey("summons")) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("summons")) {
                string = simpleJSONArrayEntry.getString();
                creature = (NPC)referenceHandler.getEntity(string);
                if (creature == null) {
                    Logger.appendToWarningLog("When loading, summoned creature " + string + " not found.");
                    continue;
                }
                creature.setFaction(Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction")));
                party.summons.add((NPC)creature);
            }
        }
        return party;
    }

    public void movePartyMember(PC pC, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Cannot move a creature by 0.");
        }
        int n2 = this.characters.indexOf(pC);
        int n3 = n2 + n;
        if (n3 < n2) {
            this.characters.add(n3, pC);
            this.characters.remove(n2 + 1);
        } else if (n3 > n2) {
            this.characters.add(n3 + 1, pC);
            this.characters.remove(n2);
        }
        this.recomputePortraits = true;
    }

    public boolean isPCPartyMember(Creature creature) {
        if (!creature.isPlayerFaction()) {
            return false;
        }
        if (creature.isSummoned()) {
            return false;
        }
        for (Creature creature2 : this.characters) {
            if (creature != creature2) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDefeated(boolean bl) {
        this.defeated = bl;
        if (bl) {
            for (Creature creature : this.characters) {
                creature.takeDamage(20 - creature.getCurrentHitPoints(), "Effect");
            }
            for (Creature creature : this.summons) {
                creature.takeDamage(-creature.getCurrentHitPoints(), "Effect");
            }
        }
    }

    public boolean isDefeated() {
        return this.defeated;
    }

    public void setSelected(Creature creature) {
        int n = this.characters.indexOf(creature);
        if (n != -1) {
            this.selectedCharacterIndex = n;
        }
    }

    public void setFirstMemberSelected() {
        this.selectedCharacterIndex = 0;
    }

    public PC get(int n) {
        return this.characters.get(n);
    }

    public PC getSelected() {
        return this.characters.get(this.selectedCharacterIndex);
    }

    public int getSelectedIndex() {
        return this.selectedCharacterIndex;
    }

    public int size() {
        return this.characters.size();
    }

    public void addSummon(NPC nPC) {
        this.summons.add(nPC);
    }

    public void add(PC pC) {
        pC.setFaction(Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction")));
        this.characters.add(pC);
        this.recomputePortraits = true;
    }

    public void removeSummon(Creature creature) {
        int n = this.summons.indexOf(creature);
        if (n != -1) {
            this.summons.remove(n);
        }
    }

    public void remove(Creature creature) {
        int n = this.characters.indexOf(creature);
        if (n != -1) {
            this.characters.remove(n);
        }
        this.recomputePortraits = true;
    }

    public int getQuantity(String string) {
        int n = 0;
        for (Creature creature : this.characters) {
            n += creature.inventory.getTotalQuantity(string);
        }
        return n;
    }

    public boolean hasItem(String string, int n) {
        int n2 = 0;
        for (Creature creature : this.characters) {
            n2 += creature.inventory.getTotalQuantity(string);
        }
        return n2 >= n;
    }

    public void removeItem(String string) {
        for (Creature creature : this.characters) {
            if (creature.inventory.remove(string, 1) <= 0) continue;
            return;
        }
    }

    public void removeItem(String string, int n) {
        int n2 = 0;
        int n3 = n;
        for (Creature creature : this.characters) {
            if ((n3 = n - (n2 += creature.inventory.remove(string, n3))) != 0) continue;
            return;
        }
    }

    public boolean isCurrentlyMoving() {
        for (Creature creature : this.characters) {
            if (!creature.isCurrentlyMoving()) continue;
            return true;
        }
        return false;
    }

    public boolean recomputePortraits() {
        boolean bl = this.recomputePortraits;
        this.recomputePortraits = false;
        return bl;
    }

    public void validateItems() {
        for (PC pC : this.characters) {
            pC.inventory.validateItems();
        }
    }

    @Override
    public Iterator<PC> iterator() {
        return new PartyIterator();
    }

    public ListIterator<Creature> allCreaturesIterator() {
        return new AllCreaturesIterator();
    }

    private class PartyIterator
    implements Iterator<PC> {
        private int iteratorIndex = 0;

        private PartyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iteratorIndex < Party.this.characters.size();
        }

        @Override
        public PC next() {
            PC pC = (PC)Party.this.characters.get(this.iteratorIndex);
            ++this.iteratorIndex;
            return pC;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The party may not be modified through its iterator");
        }
    }

    private class AllCreaturesIterator
    implements ListIterator<Creature> {
        private int iteratorIndex = 0;
        private int charactersSize;

        private AllCreaturesIterator() {
            this.charactersSize = Party.this.characters.size();
        }

        @Override
        public boolean hasNext() {
            return this.iteratorIndex < this.charactersSize + Party.this.summons.size();
        }

        @Override
        public Creature next() {
            Creature creature = this.iteratorIndex < Party.this.characters.size() ? (Creature)Party.this.characters.get(this.iteratorIndex) : (Creature)Party.this.summons.get(this.iteratorIndex - this.charactersSize);
            ++this.iteratorIndex;
            return creature;
        }

        @Override
        public int nextIndex() {
            return this.iteratorIndex + 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.iteratorIndex > 0;
        }

        @Override
        public Creature previous() {
            --this.iteratorIndex;
            if (this.iteratorIndex < Party.this.characters.size()) {
                return (Creature)Party.this.characters.get(this.iteratorIndex);
            }
            return (Creature)Party.this.summons.get(this.iteratorIndex - this.charactersSize);
        }

        @Override
        public int previousIndex() {
            return this.iteratorIndex - 1;
        }

        @Override
        public void set(Creature creature) {
            throw new UnsupportedOperationException("The party may not be modified through its iterator");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The party may not be modified through its iterator");
        }

        @Override
        public void add(Creature creature) {
            throw new UnsupportedOperationException("The party may not be modified through its iterator");
        }
    }
}

