/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Widget;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.interfacelock.MovementHandler;
import net.sf.hale.mainmenu.InGameMenu;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveGameUtil;

public class Keybindings {
    public static final String UseQuickbarSlot = "UseQuickbarSlot";
    private Map<Integer, Binding> bindingsByKey;

    public Keybindings() {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        arrayList.add(new ToggleWindow((Widget)Game.mainViewer.characterWindow, "CharacterWindow"));
        arrayList.add(new ToggleWindow((Widget)Game.mainViewer.inventoryWindow, "InventoryWindow"));
        arrayList.add(new ToggleWindow((Widget)Game.mainViewer.logWindow, "LogWindow"));
        arrayList.add(new ToggleWindow((Widget)Game.mainViewer.miniMapWindow, "MiniMap"));
        arrayList.add(new ToggleQuickbarPopup());
        arrayList.add(new ToggleWindow((Widget)Game.mainViewer.scriptConsole, "ScriptConsole"));
        arrayList.add(new CancelMovement());
        arrayList.add(new ShowMenu());
        arrayList.add(new EndTurn());
        arrayList.add(new Quicksave());
        arrayList.add(new ToggleMovementMode());
        for (int i = 0; i < 10; ++i) {
            arrayList.add(new UseQuickbarSlot(i));
        }
        this.bindingsByKey = new HashMap<Integer, Binding>();
        for (Binding binding : arrayList) {
            int n = Game.config.getKeyForAction(binding.getActionName());
            if (this.bindingsByKey.containsKey(n)) {
                Logger.appendToWarningLog("Warning: duplicate key binding for " + this.bindingsByKey.get(n).getActionName() + ", " + binding.getActionName());
            }
            if (n == -1) continue;
            this.bindingsByKey.put(n, binding);
        }
    }

    public boolean isCloseQuickbarPopupKey(int n) {
        return n == Game.config.getKeyForAction("ToggleQuickbarPopup");
    }

    public boolean checkToggleScriptConsole(int n) {
        if (n == Game.config.getKeyForAction("ToggleScriptConsole")) {
            this.bindingsByKey.get(n).run();
            return true;
        }
        return false;
    }

    public void fireKeyEvent(int n) {
        if (this.bindingsByKey.containsKey(n)) {
            this.bindingsByKey.get(n).run();
        }
    }

    public static class UseQuickbarSlot
    extends Binding {
        private final int index;

        private UseQuickbarSlot(int n) {
            this.index = n;
        }

        @Override
        public String getActionName() {
            return Keybindings.UseQuickbarSlot + this.index;
        }

        @Override
        public void run() {
            Game.mainViewer.getQuickbarViewer().getButtonAtViewIndex(this.index).activateSlot(Game.mainViewer.mouseX - 2, Game.mainViewer.mouseY - 25);
        }
    }

    public static class Quicksave
    extends Binding {
        @Override
        public void run() {
            Game.mainViewer.updateInterface();
            if (Game.isInTurnMode() || Game.curCampaign.party.isDefeated()) {
                Game.mainViewer.addMessage("red", "You cannot save the game while in combat mode.");
                return;
            }
            File file = SaveGameUtil.getNextQuickSaveFile();
            try {
                SaveGameUtil.saveGame(file);
                Game.mainViewer.addMessage("link", "Quicksave successful.");
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error when quicksaving to " + file.getPath(), exception);
                Game.mainViewer.addMessage("red", "Error saving game!");
                file.delete();
            }
        }
    }

    public static class EndTurn
    extends Binding {
        @Override
        public void run() {
            if (Game.mainViewer.getMainPane().isEndTurnEnabled()) {
                Game.areaListener.nextTurn();
            }
        }
    }

    public static class ShowMenu
    extends Binding {
        @Override
        public void run() {
            InGameMenu inGameMenu = new InGameMenu((Widget)Game.mainViewer);
            inGameMenu.openPopupCentered();
        }
    }

    public static class CancelMovement
    extends Binding {
        @Override
        public void run() {
            Game.mainViewer.getMainPane().cancelAllOrders();
        }
    }

    public static class ToggleMovementMode
    extends Binding {
        @Override
        public void run() {
            if (Game.interfaceLocker.getMovementMode() == MovementHandler.Mode.Party) {
                Game.interfaceLocker.setMovementMode(MovementHandler.Mode.Single);
            } else {
                Game.interfaceLocker.setMovementMode(MovementHandler.Mode.Party);
            }
            Game.mainViewer.getMainPane().setMovementModeIcon();
        }
    }

    public static class ToggleQuickbarPopup
    extends Binding {
        @Override
        public void run() {
            Game.mainViewer.getQuickbarViewer().showQuickbarPopup();
        }
    }

    public static class ToggleWindow
    extends Binding {
        private final Widget window;
        private final String windowName;

        public ToggleWindow(Widget widget, String string) {
            this.window = widget;
            this.windowName = string;
        }

        @Override
        public String getActionName() {
            return "Toggle" + this.windowName;
        }

        @Override
        public void run() {
            this.window.setVisible(!this.window.isVisible());
        }
    }

    public static abstract class Binding
    implements Runnable {
        public String getActionName() {
            return this.getClass().getSimpleName();
        }
    }
}

