/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class GameTimer {
    private List<TemporarySightArea> sightAreas = new ArrayList<TemporarySightArea>();
    private long lastRoundTime;

    public void addTemporarySightArea(Point point, int n, int n2) {
        TemporarySightArea temporarySightArea = new TemporarySightArea();
        int n3 = Game.curCampaign.curArea.getWidth();
        int n4 = Game.curCampaign.curArea.getHeight();
        temporarySightArea.points = new ArrayList();
        if (point.x >= 0 && point.y >= 0 && point.x < n3 && point.y < n4) {
            temporarySightArea.points.add(point);
        }
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < i * 6; ++j) {
                Point point2 = AreaUtil.convertPolarToGrid(point, i, j);
                if (point2.x < 0 || point2.y < 0 || point2.x >= n3 || point2.y >= n4) continue;
                temporarySightArea.points.add(point2);
            }
        }
        temporarySightArea.roundsRemaining = n2;
        this.sightAreas.add(temporarySightArea);
        Game.curCampaign.curArea.getUtil().setPartyVisibility();
    }

    public void clearTemporarySightAreas() {
        this.sightAreas.clear();
        Game.curCampaign.curArea.getUtil().setPartyVisibility();
    }

    public void updateTime(long l) {
        if (Game.isInTurnMode()) {
            this.lastRoundTime = l;
        } else if (l - this.lastRoundTime > (long)Game.curCampaign.getDate().roundMillis) {
            this.lastRoundTime = l;
            Game.areaListener.nextTurn();
            for (int i = 0; i < this.sightAreas.size(); ++i) {
                TemporarySightArea temporarySightArea = this.sightAreas.get(i);
                if (temporarySightArea.roundsRemaining == 0) continue;
                temporarySightArea.roundsRemaining--;
                if (temporarySightArea.roundsRemaining != 0) continue;
                this.sightAreas.remove(i);
                --i;
            }
        }
    }

    public void getTemporaryVisibilityAreas(boolean[][] blArray) {
        for (int i = 0; i < this.sightAreas.size(); ++i) {
            TemporarySightArea temporarySightArea = this.sightAreas.get(i);
            for (Point point : temporarySightArea.points) {
                blArray[point.x][point.y] = true;
            }
        }
    }

    public void resetTime() {
        this.lastRoundTime = System.currentTimeMillis();
    }

    private class TemporarySightArea {
        private List<Point> points;
        private int roundsRemaining;

        private TemporarySightArea() {
        }
    }
}

