/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.theme.ThemeManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sf.hale.AIScriptInterface;
import net.sf.hale.AreaListener;
import net.sf.hale.Config;
import net.sf.hale.GameTimer;
import net.sf.hale.ScriptInterface;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.interfacelock.InterfaceLocker;
import net.sf.hale.loading.AsyncTextureLoader;
import net.sf.hale.loading.LoadGameLoadingTaskList;
import net.sf.hale.loading.LoadingWaitPopup;
import net.sf.hale.mainmenu.ErrorPopup;
import net.sf.hale.mainmenu.MainMenu;
import net.sf.hale.mainmenu.MainMenuAction;
import net.sf.hale.particle.ParticleManager;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Campaign;
import net.sf.hale.rules.Dice;
import net.sf.hale.rules.Ruleset;
import net.sf.hale.util.JSEngineManager;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.view.AreaViewer;
import net.sf.hale.view.MainViewer;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class Game {
    public static final int TILE_SIZE = 72;
    public static final int TILE_WIDTH = 54;
    public static final double TILE_RATIO = Math.sqrt(3.0) * 54.0 / 72.0;
    public static final int ICON_SIZE = 45;
    private static NumberFormat numberFormat;
    public static Config config;
    public static Campaign curCampaign;
    public static Entity selectedEntity;
    public static Ruleset ruleset;
    public static ParticleManager particleManager;
    public static ScriptInterface scriptInterface;
    public static JSEngineManager scriptEngineManager;
    public static MainViewer mainViewer;
    public static AreaListener areaListener;
    public static AreaViewer areaViewer;
    public static GameTimer timer;
    public static Dice dice;
    public static List<DisplayMode> allDisplayModes;
    public static DisplayMode displayMode;
    public static LWJGLRenderer renderer;
    public static ThemeManager themeManager;
    public static InterfaceLocker interfaceLocker;
    public static MouseActionList mouseActions;
    public static AsyncTextureLoader textureLoader;
    private static boolean turnMode;
    public static OSType osType;
    private static String configBaseDirectory;
    private static String charactersBaseDirectory;
    private static String partiesBaseDirectory;
    private static String saveBaseDirectory;
    private static String logBaseDirectory;
    public static final String MAIN_COMMAND = "net.sf.hale.Game";

    public static boolean isInTurnMode() {
        return turnMode;
    }

    public static void setTurnMode(boolean bl) {
        turnMode = bl;
    }

    public static NumberFormat numberFormat(int n) {
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat;
    }

    public static String getConfigBaseDirectory() {
        return configBaseDirectory;
    }

    public static String getCharactersBaseDirectory() {
        return charactersBaseDirectory;
    }

    public static String getPartiesBaseDirectory() {
        return partiesBaseDirectory;
    }

    public static String getSaveBaseDirectory() {
        return saveBaseDirectory;
    }

    public static String getLogBaseDirectory() {
        return logBaseDirectory;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("os.name").toLowerCase();
        osType = string.contains("win") ? OSType.Windows : (string.contains("mac") ? OSType.Mac : OSType.Unix);
        Game.initializeOSSpecific(osType);
        EquippableItemTemplate.initializeTypesMap();
        ResourceManager.registerCorePackage();
        numberFormat = NumberFormat.getInstance();
        config = new Config(Game.getConfigBaseDirectory() + "config.json");
        dice = new Dice();
        scriptEngineManager = new JSEngineManager();
        scriptInterface = new ScriptInterface();
        particleManager = new ParticleManager();
        timer = new GameTimer();
        interfaceLocker = new InterfaceLocker();
        ScriptInterface.ai = new AIScriptInterface();
        Display.setTitle((String)"Hale");
        Game.setDisplayIcon();
        textureLoader = new AsyncTextureLoader();
        try {
            allDisplayModes = Config.getUsableDisplayModes();
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error registering display modes.", exception);
        }
        Config.createGameDisplay();
        try {
            MainMenuAction mainMenuAction = new MainMenuAction(MainMenuAction.Action.ShowMainMenu);
            while (mainMenuAction.getAction() != MainMenuAction.Action.Exit) {
                mainMenuAction = Game.performAction(mainMenuAction);
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Uncaught exception in game.", exception);
        }
        Display.destroy();
    }

    public static List<Thread> getActiveThreads() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
        int n = threadGroup.enumerate(threadArray);
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (int i = 0; i < n; ++i) {
            Thread thread2 = threadArray[i];
            if (thread2.isDaemon() || thread2 == thread) continue;
            arrayList.add(thread2);
        }
        return arrayList;
    }

    private static ByteBuffer loadIcon(InputStream inputStream) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error loading display icon", iOException);
            return null;
        }
        byte[] byArray = new byte[bufferedImage.getWidth() * bufferedImage.getHeight() * 4];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                int n = bufferedImage.getRGB(j, i);
                for (int k = 0; k < 3; ++k) {
                    byArray[(i * bufferedImage.getWidth() + j) * 4 + k] = (byte)(n >> (2 - k) * 8 & 0xFF);
                }
                byArray[(i * bufferedImage.getWidth() + j) * 4 + 3] = (byte)(n >> 24 & 0xFF);
            }
        }
        return ByteBuffer.wrap(byArray);
    }

    private static void setDisplayIcon() {
        InputStream inputStream = ResourceManager.getStream("gui/hale128.png");
        InputStream inputStream2 = ResourceManager.getStream("gui/hale64.png");
        InputStream inputStream3 = ResourceManager.getStream("gui/hale32.png");
        InputStream inputStream4 = ResourceManager.getStream("gui/hale16.png");
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{Game.loadIcon(inputStream), Game.loadIcon(inputStream2), Game.loadIcon(inputStream3), Game.loadIcon(inputStream4)};
        Display.setIcon((ByteBuffer[])byteBufferArray);
    }

    public static void initializeOSSpecific(OSType oSType) {
        switch (oSType) {
            case Windows: {
                String string = System.getProperty("user.home") + "\\My Documents\\My Games\\hale\\";
                configBaseDirectory = string + "\\config\\";
                charactersBaseDirectory = string + "\\characters\\";
                partiesBaseDirectory = string + "\\parties\\";
                saveBaseDirectory = string + "\\saves\\";
                logBaseDirectory = string + "\\log\\";
                Game.createTimerAccuracyThread();
                break;
            }
            default: {
                String string = System.getenv("XDG_DATA_HOME");
                String string2 = System.getenv("XDG_CONFIG_HOME");
                if (string == null || string.length() == 0) {
                    string = System.getProperty("user.home") + "/.local/share";
                }
                if (string2 == null || string2.length() == 0) {
                    string2 = System.getProperty("user.home") + "/.config";
                }
                string = string + "/hale/";
                configBaseDirectory = string2 = string2 + "/hale/";
                charactersBaseDirectory = string + "characters/";
                partiesBaseDirectory = string + "parties/";
                saveBaseDirectory = string + "saves/";
                logBaseDirectory = string + "log/";
            }
        }
        new File(configBaseDirectory).mkdirs();
        new File(charactersBaseDirectory).mkdirs();
        new File(partiesBaseDirectory).mkdirs();
        new File(saveBaseDirectory).mkdirs();
        new File(logBaseDirectory).mkdirs();
    }

    private static void createTimerAccuracyThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Timer accuracy thread error", exception);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private static void destroyDisplay() {
        SpriteManager.clear();
        themeManager.destroy();
        Display.destroy();
    }

    private static MainMenuAction performAction(MainMenuAction mainMenuAction) {
        mainMenuAction.runPreActionCallback();
        switch (mainMenuAction.getAction()) {
            case Exit: {
                return mainMenuAction;
            }
            case Restart: {
                Game.destroyDisplay();
                Config.createGameDisplay();
                break;
            }
            case ShowMainMenu: {
                MainMenu mainMenu = new MainMenu();
                if (mainMenuAction.getErrorPopupMessages().size() > 0) {
                    ErrorPopup errorPopup = new ErrorPopup((Widget)mainMenu, mainMenuAction.getErrorPopupMessages());
                    errorPopup.openPopupCentered();
                }
                mainMenuAction = mainMenu.mainLoop();
                if (curCampaign != null) {
                    MainMenu.writeLastOpenCampaign(curCampaign.getID());
                }
                return mainMenuAction;
            }
            case NewGame: {
                EntityManager.clear();
                Game.curCampaign.curArea.addPlayerCharacters();
                mainViewer = new MainViewer();
                Game.curCampaign.curArea.setEntityVisibility();
                return mainViewer.runCampaign(true);
            }
            case LoadGame: {
                Object object;
                LoadGameLoadingTaskList loadGameLoadingTaskList = null;
                try {
                    mainViewer = new MainViewer();
                    loadGameLoadingTaskList = new LoadGameLoadingTaskList(SaveGameUtil.getSaveFile(mainMenuAction.getLoadGameFile()));
                    loadGameLoadingTaskList.start();
                    object = new LoadingWaitPopup((Widget)mainViewer, "Loading Saved Game");
                    ((LoadingWaitPopup)((Object)object)).setLoadingTaskList(loadGameLoadingTaskList);
                    ((LoadingWaitPopup)((Object)object)).setBGSprite(SpriteManager.getSpriteAnyExtension("loadingscreen"));
                    object.openPopupCentered();
                    mainViewer.runLoadingLoop(loadGameLoadingTaskList, (LoadingWaitPopup)((Object)object));
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error loading saved game: " + mainMenuAction.getLoadGameFile(), exception);
                }
                if (loadGameLoadingTaskList != null && loadGameLoadingTaskList.isCompletedSuccessfully()) {
                    mainViewer.addMessage("link", "Save file loaded successfully.");
                    return mainViewer.runCampaign(false);
                }
                object = new MainMenuAction(MainMenuAction.Action.ShowMainMenu);
                ((MainMenuAction)object).addErrorPopupMessage("Unable to load the save file \"" + mainMenuAction.getLoadGameFile() + "\".");
                ((MainMenuAction)object).addErrorPopupMessage("");
                ((MainMenuAction)object).addErrorPopupMessage("Try exiting and restarting the game, then loading");
                ((MainMenuAction)object).addErrorPopupMessage("the file again.  If the problem persists, then the");
                ((MainMenuAction)object).addErrorPopupMessage("save file is corrupt or from an incompatible");
                ((MainMenuAction)object).addErrorPopupMessage("version and cannot be loaded.");
                return object;
            }
        }
        return new MainMenuAction(MainMenuAction.Action.ShowMainMenu);
    }

    public static String getProgramCommand() throws IOException {
        String string = System.getProperty("java.home") + "/bin/java";
        List<String> list = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer stringBuffer = new StringBuffer();
        for (String stringArray2 : list) {
            if (stringArray2.contains("-agentlib")) continue;
            stringBuffer.append(stringArray2);
            stringBuffer.append(" ");
        }
        StringBuffer stringBuffer2 = new StringBuffer("\"" + string + "\" " + stringBuffer);
        String[] stringArray = MAIN_COMMAND.split(" ");
        if (stringArray[0].endsWith(".jar")) {
            stringBuffer2.append("-jar " + new File(stringArray[0]).getPath());
        } else {
            stringBuffer2.append("-cp \"" + System.getProperty("java.class.path") + "\" " + stringArray[0]);
        }
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer2.append(" ");
            stringBuffer2.append(stringArray[i]);
        }
        return stringBuffer2.toString();
    }

    static {
        turnMode = false;
    }

    public static enum OSType {
        Unix,
        Windows,
        Mac;

    }
}

