/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class DifficultyManager {
    private final Map<String, DifficultyLevel> levels;
    private String currentDifficulty;

    public DifficultyManager() {
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("difficultyLevels", ResourceType.JSON);
        this.levels = new LinkedHashMap<String, DifficultyLevel>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONParser.getArray("difficultyLevels")) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            String string = simpleJSONObject.get("name", null);
            boolean bl = simpleJSONObject.get("criticalHitsOnPCs", false);
            boolean bl2 = simpleJSONObject.get("friendlyFireOnPCs", false);
            int n = simpleJSONObject.get("damageFactorOnPCs", 100);
            DifficultyLevel difficultyLevel = new DifficultyLevel(bl, bl2, n);
            this.levels.put(string, difficultyLevel);
        }
        this.currentDifficulty = simpleJSONParser.get("defaultDifficulty", null);
        simpleJSONParser.warnOnUnusedKeys();
    }

    public String getDifficultyDescription(String string) {
        if (!this.levels.containsKey(string)) {
            throw new IllegalArgumentException("Difficulty " + string + " not found");
        }
        DifficultyLevel difficultyLevel = this.levels.get(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div>");
        if (difficultyLevel.criticalHitsOnPCs) {
            stringBuilder.append("Normal Critical Hits on Players");
        } else {
            stringBuilder.append("No Critical Hits On Players");
        }
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"margin-top: 0.5em\">");
        if (difficultyLevel.friendlyFireOnPCs) {
            stringBuilder.append("Normal Friendly Fire on Players from Area Spells");
        } else {
            stringBuilder.append("No Friendly Fire on Players from Area Spells");
        }
        stringBuilder.append("</div>");
        stringBuilder.append("<div style=\"margin-top: 0.5em\">");
        stringBuilder.append("Players take ");
        stringBuilder.append(Integer.toString(difficultyLevel.damageFactorOnPCs));
        stringBuilder.append("% damage");
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    public void setCurrentDifficulty(String string) {
        if (!this.levels.containsKey(string)) {
            throw new IllegalArgumentException("Difficulty level " + string + " not found.");
        }
        this.currentDifficulty = string;
        if (Game.curCampaign != null) {
            Game.curCampaign.setCurrentDifficulty(this.currentDifficulty);
        }
    }

    public String getCurrentDifficulty() {
        return this.currentDifficulty;
    }

    public Set<String> getDifficultyLevels() {
        return Collections.unmodifiableSet(this.levels.keySet());
    }

    public int getDamageFactorOnPCs() {
        return this.levels.get(this.currentDifficulty).damageFactorOnPCs;
    }

    public boolean criticalHitsOnPCs() {
        return this.levels.get(this.currentDifficulty).criticalHitsOnPCs;
    }

    public boolean friendlyFireOnPCs() {
        return this.levels.get(this.currentDifficulty).friendlyFireOnPCs;
    }

    private class DifficultyLevel {
        private final boolean criticalHitsOnPCs;
        private final boolean friendlyFireOnPCs;
        private final int damageFactorOnPCs;

        private DifficultyLevel(boolean bl, boolean bl2, int n) {
            this.criticalHitsOnPCs = bl;
            this.friendlyFireOnPCs = bl2;
            this.damageFactorOnPCs = n;
        }
    }
}

