/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ScriptInterface;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Attack;

public class DelayedAttackCallback
extends Thread {
    private long delayMillis;
    private Attack mainAttack;
    private Attack offHandAttack;
    private List<Runnable> callbacks;

    public DelayedAttackCallback(long l, Attack attack, Attack attack2) {
        this.delayMillis = l;
        this.mainAttack = attack;
        this.offHandAttack = attack2;
        this.callbacks = new ArrayList<Runnable>();
    }

    public boolean isAttackHit() {
        if (this.mainAttack != null && this.offHandAttack != null) {
            return this.mainAttack.isHit() || this.offHandAttack.isHit();
        }
        if (this.mainAttack != null) {
            return this.mainAttack.isHit();
        }
        if (this.offHandAttack != null) {
            return this.offHandAttack.isHit();
        }
        return false;
    }

    public void addCallback(Runnable runnable) {
        this.callbacks.add(runnable);
    }

    private void performAttack(Attack attack) {
        Creature creature = attack.getAttacker();
        Creature creature2 = attack.getDefender();
        creature2.getEffects().executeOnAll(ScriptFunctionType.onDefense, attack);
        creature.getEffects().executeOnAll(ScriptFunctionType.onAttack, attack);
        if (attack.getWeapon() != null) {
            if (attack.getWeapon().getTemplate().hasScript()) {
                attack.getWeapon().getTemplate().getScript().executeFunction(ScriptFunctionType.onAttack, attack.getWeapon(), attack);
            }
            attack.getWeapon().getEffects().executeOnAll(ScriptFunctionType.onAttack, attack);
        }
        boolean bl = attack.computeIsHit();
        Game.mainViewer.addMessage("black", attack.getMessage());
        if (bl) {
            if (attack.causesDamage()) {
                int n = 0;
                if (!attack.damageNegated()) {
                    n = attack.computeAppliedDamage();
                    creature2.takeDamage(attack.getDamage());
                    if (creature2.getFaction().isHostile(creature) && creature2.getEncounter() != null) {
                        creature2.getEncounter().checkAddHostile(creature);
                    }
                }
                creature2.getEffects().executeOnAll(ScriptFunctionType.onDefenseHit, attack, n);
                creature.getEffects().executeOnAll(ScriptFunctionType.onAttackHit, attack, n);
                if (attack.getWeapon() != null) {
                    if (attack.getWeapon().getTemplate().hasScript()) {
                        attack.getWeapon().getTemplate().getScript().executeFunction(ScriptFunctionType.onAttackHit, attack.getWeapon(), attack, n);
                    }
                    attack.getWeapon().getEffects().executeOnAll(ScriptFunctionType.onAttackHit, attack, n);
                }
            }
        } else {
            Game.mainViewer.addFadeAway("Miss", creature.getLocation().getX(), creature.getLocation().getY(), new Color(-5527127));
        }
        if (attack.isRanged() && !creature.stats.has(Bonus.Type.AoOFromRangedImmunity)) {
            Game.areaListener.getCombatRunner().provokeAttacksOfOpportunity(creature, null);
        }
        ScriptInterface.performSearchChecksForCreature(creature, Game.ruleset.getValue("HideAttackPenalty"));
        Game.mainViewer.updateEntity(creature);
        Game.mainViewer.updateEntity(creature2);
        Game.mainViewer.updateInterface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.delayMillis != 0L) {
                Thread.sleep(this.delayMillis);
            }
            if (this.mainAttack != null) {
                this.performAttack(this.mainAttack);
            }
            if (this.offHandAttack != null) {
                this.performAttack(this.offHandAttack);
            }
            for (Runnable runnable : this.callbacks) {
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        DelayedAttackCallback delayedAttackCallback = this;
        synchronized (delayedAttackCallback) {
            this.notifyAll();
        }
    }
}

