/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Cutscene {
    private String id;
    private List<Frame> frames;
    private int textAreaWidth;
    private int textAreaHeight;
    private String callbackScript;
    private String callbackFunction;

    public Cutscene(String string, String string2) {
        this.id = string;
        this.frames = Collections.emptyList();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2);
        simpleJSONParser.setWarnOnMissingKeys(true);
        this.textAreaWidth = simpleJSONParser.get("textAreaWidth", 0);
        this.textAreaHeight = simpleJSONParser.get("textAreaHeight", 0);
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("frames");
        this.frames = new ArrayList<Frame>(simpleJSONArray.size());
        simpleJSONParser.setWarnOnMissingKeys(false);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            this.frames.add(new Frame(simpleJSONArrayEntry.getObject()));
        }
        this.callbackScript = simpleJSONParser.get("callbackScript", null);
        this.callbackFunction = simpleJSONParser.get("callbackFunction", null);
        simpleJSONParser.warnOnUnusedKeys();
    }

    public String getCallbackScript() {
        return this.callbackScript;
    }

    public String getCallbackFunction() {
        return this.callbackFunction;
    }

    public String getID() {
        return this.id;
    }

    public int getNumFrames() {
        return this.frames.size();
    }

    public List<Frame> getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public class Frame {
        private String bgImage;
        private String text;
        private int textAreaWidth;
        private int textAreaHeight;

        private Frame(SimpleJSONObject simpleJSONObject) {
            String string;
            this.bgImage = simpleJSONObject.get("background", null);
            this.textAreaWidth = simpleJSONObject.get("textAreaWidth", Cutscene.this.textAreaWidth);
            this.textAreaHeight = simpleJSONObject.get("textAreaHeight", Cutscene.this.textAreaHeight);
            this.text = simpleJSONObject.get("text", null);
            if (this.text == null && (string = simpleJSONObject.get("textFile", null)) != null) {
                this.text = ResourceManager.getResourceAsString("cutscenes/" + string);
            }
        }

        public int getTextAreaWidth() {
            return this.textAreaWidth;
        }

        public int getTextAreaHeight() {
            return this.textAreaHeight;
        }

        public String getBGImage() {
            return this.bgImage;
        }

        public String getText() {
            return this.text;
        }
    }
}

