/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.theme.ThemeManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.resource.URLResourceStreamHandler;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class Config {
    private int resolutionX;
    private int resolutionY;
    private final boolean fullscreen;
    private final boolean showFPS;
    private final boolean capFPS;
    private final boolean combatAutoScroll;
    private final int toolTipDelay;
    private final long randSeed;
    private final boolean randSeedSet;
    private final boolean scriptConsoleEnabled;
    private final boolean debugMode;
    private final boolean warningMode;
    private final int combatDelay;
    private final long checkForUpdatesInterval;
    private final String versionID = FileUtil.getHalfMD5Sum(new File("hale.jar"));
    private final Map<String, Integer> keyBindingActions;

    public long getCheckForUpdatesInterval() {
        return this.checkForUpdatesInterval;
    }

    public boolean randSeedSet() {
        return this.randSeedSet;
    }

    public long getRandSeed() {
        return this.randSeed;
    }

    public int getCombatDelay() {
        return this.combatDelay;
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public boolean autoScrollDuringCombat() {
        return this.combatAutoScroll;
    }

    public boolean showFPS() {
        return this.showFPS;
    }

    public boolean getFullscreen() {
        return this.fullscreen;
    }

    public boolean capFPS() {
        return this.capFPS;
    }

    public boolean isScriptConsoleEnabled() {
        return this.scriptConsoleEnabled;
    }

    public boolean isDebugModeEnabled() {
        return this.debugMode;
    }

    public boolean isWarningModeEnabled() {
        return this.warningMode;
    }

    public int getTooltipDelay() {
        return this.toolTipDelay;
    }

    public String getVersionID() {
        return this.versionID;
    }

    public int getKeyForAction(String string) {
        Integer n = this.keyBindingActions.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public List<String> getKeyActionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.keyBindingActions.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public Config(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            this.createConfigFile(string);
        }
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(file);
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("Resolution");
        Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray.iterator();
        this.resolutionX = iterator.next().getInt(800);
        this.resolutionY = iterator.next().getInt(600);
        this.fullscreen = simpleJSONParser.get("Fullscreen", false);
        SimpleJSONArray simpleJSONArray2 = simpleJSONParser.getArray("EditorResolution");
        iterator = simpleJSONArray2.iterator();
        this.showFPS = simpleJSONParser.get("ShowFPS", false);
        this.combatAutoScroll = simpleJSONParser.get("CombatAutoScroll", true);
        this.capFPS = simpleJSONParser.get("CapFPS", false);
        this.toolTipDelay = simpleJSONParser.get("TooltipDelay", 400);
        this.combatDelay = simpleJSONParser.get("CombatDelay", 150);
        this.scriptConsoleEnabled = simpleJSONParser.get("ScriptConsoleEnabled", false);
        this.debugMode = simpleJSONParser.get("DebugMode", false);
        this.warningMode = simpleJSONParser.get("WarningMode", false);
        this.checkForUpdatesInterval = simpleJSONParser.get("CheckForUpdatesInterval", 86400000);
        if (simpleJSONParser.containsKey("RandomSeed")) {
            this.randSeedSet = true;
            this.randSeed = simpleJSONParser.get("RandomSeed", 0);
        } else {
            this.randSeedSet = false;
            this.randSeed = 0L;
        }
        this.keyBindingActions = new HashMap<String, Integer>();
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("Keybindings");
        for (String string2 : simpleJSONObject.keySet()) {
            String string3 = simpleJSONObject.get(string2, null);
            if (string3.length() > 0) {
                this.keyBindingActions.put(string2, Event.getKeyCodeForName((String)string3));
                continue;
            }
            this.keyBindingActions.put(string2, -1);
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void createConfigFile(String string) {
        try {
            FileUtil.copyFile(new File("docs/defaultConfig.json"), new File(string));
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error creating configuration file.", iOException);
        }
    }

    public static void writeCheckForUpdatesTime(long l) {
        try {
            FileUtil.writeStringToFile(new File(Game.getConfigBaseDirectory() + "lastUpdateTime.txt"), Long.toString(l));
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error writing last update time to file", iOException);
        }
    }

    public static long getLastCheckForUpdatesTime() {
        File file = new File(Game.getConfigBaseDirectory() + "lastUpdateTime.txt");
        if (file.canRead()) {
            String string = null;
            try {
                string = FileUtil.readFileAsString(Game.getConfigBaseDirectory() + "lastUpdateTime.txt");
            }
            catch (IOException iOException) {
                Logger.appendToErrorLog("Error reading last update time", iOException);
            }
            if (string != null) {
                try {
                    return Long.parseLong(string);
                }
                catch (Exception exception) {
                    Logger.appendToErrorLog("Error parsing last update time", exception);
                }
            }
        }
        return 0L;
    }

    public static List<DisplayMode> getUsableDisplayModes() throws LWJGLException {
        DisplayMode displayMode = Display.getDesktopDisplayMode();
        DisplayMode[] displayModeArray = Display.getAvailableDisplayModes();
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        for (DisplayMode displayMode2 : displayModeArray) {
            if (displayMode2.getBitsPerPixel() != displayMode.getBitsPerPixel() || !displayMode2.isFullscreenCapable() || displayMode2.getWidth() < 800 || displayMode2.getHeight() < 600) continue;
            boolean bl = true;
            for (DisplayMode displayMode3 : arrayList) {
                if (displayMode3.getWidth() != displayMode2.getWidth() || displayMode3.getHeight() != displayMode2.getHeight()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(displayMode2);
        }
        Collections.sort(arrayList, new Comparator<DisplayMode>(){

            @Override
            public int compare(DisplayMode displayMode, DisplayMode displayMode2) {
                if (displayMode.getWidth() > displayMode2.getWidth()) {
                    return 1;
                }
                if (displayMode.getWidth() < displayMode2.getWidth()) {
                    return -1;
                }
                if (displayMode.getHeight() > displayMode2.getHeight()) {
                    return 1;
                }
                return -1;
            }
        });
        return arrayList;
    }

    public static int getMatchingDisplayMode(int n, int n2) {
        for (int i = 0; i < Game.allDisplayModes.size(); ++i) {
            DisplayMode displayMode = Game.allDisplayModes.get(i);
            if (displayMode.getWidth() != n || displayMode.getHeight() != n2) continue;
            return i;
        }
        return -1;
    }

    public static void createGameDisplay() {
        if (!Config.createDisplay(Game.config.getResolutionX(), Game.config.getResolutionY())) {
            Game.config.resolutionX = 800;
            Game.config.resolutionY = 600;
        }
    }

    private static boolean createDisplay(int n, int n2) {
        boolean bl = false;
        try {
            int n3 = Config.getMatchingDisplayMode(n, n2);
            if (n3 == -1) {
                Logger.appendToErrorLog("No display mode available with configuration: " + n + "x" + n2 + ".  Falling back to 800x600.");
                n3 = Config.getMatchingDisplayMode(800, 600);
                if (n3 == -1) {
                    Logger.appendToErrorLog("Unable to find display mode for fallback 800x600 display.  Exiting.");
                    System.exit(1);
                }
            } else {
                bl = true;
            }
            Game.displayMode = Game.allDisplayModes.get(n3);
            Display.setDisplayMode((DisplayMode)Game.displayMode);
            Display.setFullscreen((boolean)Game.config.getFullscreen());
            Display.create();
            Game.renderer = new LWJGLRenderer();
        }
        catch (LWJGLException lWJGLException) {
            Logger.appendToErrorLog("Error creating display.", lWJGLException);
            System.exit(0);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Game.config.getResolutionX(), (double)Game.config.getResolutionY(), (double)0.0, (double)0.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)33880);
        GL11.glHint((int)3152, (int)4353);
        URL uRL = null;
        try {
            uRL = new URL("resource", "localhost", -1, "gui/theme.xml", new URLResourceStreamHandler());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.appendToErrorLog("Error creating URL for theme file", malformedURLException);
        }
        try {
            Game.themeManager = ThemeManager.createThemeManager(uRL, (Renderer)Game.renderer);
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Error creating theme manager", iOException);
        }
        return bl;
    }
}

