/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.DelayedAttackCallback;
import net.sf.hale.Game;
import net.sf.hale.ability.AsyncScriptable;
import net.sf.hale.ability.ListTargeter;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Scriptable;
import net.sf.hale.ability.Targeter;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Weapon;
import net.sf.hale.icon.SimpleIcon;
import net.sf.hale.interfacelock.EntityAttackAnimation;
import net.sf.hale.interfacelock.EntityOffsetAnimation;
import net.sf.hale.interfacelock.InterfaceAILock;
import net.sf.hale.interfacelock.InterfaceCombatLock;
import net.sf.hale.interfacelock.InterfaceLock;
import net.sf.hale.interfacelock.InterfaceTargeterLock;
import net.sf.hale.interfacelock.MovementHandler;
import net.sf.hale.mainmenu.InGameMenu;
import net.sf.hale.particle.Animation;
import net.sf.hale.rules.Attack;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;

public class CombatRunner {
    private final List<Creature> creatures = new ArrayList<Creature>();
    private int activeCreatureIndex = -1;
    private boolean combatModeInitiating = false;
    private int combatStartRound;

    public void nextCombatTurn() {
        if (this.combatModeInitiating && !Game.isInTurnMode()) {
            Game.setTurnMode(true);
            this.startCombat();
        }
        this.runTurn();
    }

    public List<Creature> getThreateningCreatures(Creature creature) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        if (!Game.isInTurnMode()) {
            return arrayList;
        }
        if (creature.stats.isHidden()) {
            return arrayList;
        }
        for (Creature creature2 : this.creatures) {
            if (creature2 == creature || creature2.isDead() || creature2.isDying() || !creature2.getFaction().isHostile(creature) || !creature2.threatensLocation(creature.getLocation())) continue;
            arrayList.add(creature2);
        }
        return arrayList;
    }

    private List<Creature> getThreateningCreaturesAtNextPosition(Creature creature) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        if (!Game.isInTurnMode()) {
            return arrayList;
        }
        if (creature.stats.isHidden()) {
            return arrayList;
        }
        for (Creature creature2 : this.creatures) {
            if (creature2 == creature || creature2.isDead() || creature2.isDying() || !creature2.getFaction().isHostile(creature) || !creature2.threatensLocation(creature.getLocation()) || !creature2.canTakeMoveAoOIgnoringLocation(creature)) continue;
            arrayList.add(creature2);
        }
        return arrayList;
    }

    public boolean provokeAttacksOfOpportunity(Creature creature, MovementHandler.Mover mover) {
        boolean bl = false;
        boolean bl2 = false;
        List<Creature> list = mover == null ? this.getThreateningCreatures(creature) : this.getThreateningCreaturesAtNextPosition(creature);
        for (Creature creature2 : list) {
            Object object;
            if (mover != null) {
                creature2.takeMoveAoO(creature);
            }
            Game.mainViewer.addMessage("green", creature2.getTemplate().getName() + " gets an Attack of Opportunity against " + creature.getTemplate().getName());
            TakeAoOCallback takeAoOCallback = new TakeAoOCallback(creature2, creature);
            if (creature2 instanceof PC) {
                bl = true;
                object = new ListTargeter(creature2, null, null);
                ((Targeter)object).addAllowedPoint(creature.getLocation());
                ((Targeter)object).setMenuTitle("Attack of Opportunity");
                ((Targeter)object).setActivateCallback(takeAoOCallback);
                ((Targeter)object).setCheckValidCallback(new CheckAoOCallback(creature));
                Game.areaListener.getTargeterManager().addTargeter((Targeter)object);
                if (mover != null) {
                    mover.incrementPauseCount();
                    takeAoOCallback.moverToUnPause = mover;
                    CancelAoOCallback cancelAoOCallback = new CancelAoOCallback();
                    cancelAoOCallback.moverToUnPause = mover;
                    ((Targeter)object).setCancelCallback(cancelAoOCallback);
                }
                if (!Game.config.autoScrollDuringCombat() || bl2) continue;
                Game.areaViewer.addDelayedScrollToCreature(creature2);
                bl2 = true;
                continue;
            }
            if (!creature2.getTemplate().hasScript()) continue;
            if (creature2.getTemplate().getScript().hasFunction(ScriptFunctionType.takeAttackOfOpportunity)) {
                object = creature2.getTemplate().getScript().executeFunction(ScriptFunctionType.takeAttackOfOpportunity, creature2, creature);
                if (!Boolean.TRUE.equals(object)) continue;
                takeAoOCallback.takeAoO();
                continue;
            }
            takeAoOCallback.takeAoO();
        }
        if (bl) {
            Game.interfaceLocker.add(new InterfaceTargeterLock(creature));
            return true;
        }
        return false;
    }

    private void startCombat() {
        this.creatures.clear();
        Game.timer.resetTime();
        ArrayList<CreatureWithInitiative> arrayList = new ArrayList<CreatureWithInitiative>();
        for (Entity comparable : Game.curCampaign.curArea.getEntities()) {
            if (!(comparable instanceof Creature)) continue;
            Creature creature = (Creature)comparable;
            creature.timer.endTurn();
            arrayList.add(new CreatureWithInitiative(creature));
        }
        Collections.sort(arrayList);
        for (CreatureWithInitiative creatureWithInitiative : arrayList) {
            this.creatures.add(creatureWithInitiative.creature);
        }
        Game.mainViewer.getPortraitArea().disableAllLevelUp();
        Game.curCampaign.getDate().incrementRound();
        this.activeCreatureIndex = -1;
        this.combatModeInitiating = false;
    }

    public boolean checkAIActivation() {
        boolean bl = false;
        for (Creature creature : Game.curCampaign.party) {
            bl = bl || this.checkAIActivation(creature);
        }
        if (bl && !this.combatModeInitiating) {
            this.combatModeInitiating = true;
            Game.mainViewer.addMessage("link", "Hostile creature spotted.  Combat initiated.");
            Game.interfaceLocker.add(new InterfaceCombatLock(Game.curCampaign.party.getSelected(), Game.config.getCombatDelay() * 6));
            this.combatStartRound = Game.curCampaign.getDate().getTotalRoundsElapsed();
        }
        return bl;
    }

    private boolean checkAIActivation(Creature creature) {
        Object object2;
        Encounter encounter = creature.getEncounter();
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        arrayList.add(creature);
        if (encounter != null) {
            encounter.setAIActive(true);
            for (Object object2 : encounter) {
                arrayList.add((Creature)object2);
            }
        }
        List<Creature> list = AreaUtil.getVisibleCreatures(creature, Faction.Relationship.Hostile);
        object2 = list.iterator();
        while (object2.hasNext()) {
            Creature creature2 = object2.next();
            if (encounter != null) {
                encounter.addHostile(creature2);
            }
            if (creature2.getEncounter() == null) continue;
            creature2.getEncounter().setAIActive(true);
            if (!creature.stats.isHidden()) {
                creature2.getEncounter().addHostiles(arrayList);
            }
            if (encounter == null) continue;
            encounter.addHostiles(creature2.getEncounter().getCreaturesInArea());
        }
        return !Game.isInTurnMode() && list.size() > 0;
    }

    private DelayedAttackCallback creatureAttack(Attack attack, Attack attack2, boolean bl) {
        if (attack == null) {
            Logger.appendToErrorLog("Error attempting to attack.");
            return null;
        }
        Creature creature = attack.getAttacker();
        Creature creature2 = attack.getDefender();
        attack.computeFlankingBonus(Game.curCampaign.curArea.getEntities());
        if (bl) {
            Object object;
            long l = 0L;
            if (attack.isRanged()) {
                Object object2;
                if (!(creature instanceof PC) && Game.config.autoScrollDuringCombat()) {
                    object = creature.getLocation().getScreenPoint();
                    object2 = creature2.getLocation().getScreenPoint();
                    int n = (((Point)object).x + ((Point)object2).x) / 2;
                    int n2 = (((Point)object).y + ((Point)object2).y) / 2;
                    Game.areaViewer.addDelayedScrollToScreenPoint(new Point(n, n2));
                }
                object = null;
                object2 = attack.getWeapon();
                switch (((Weapon)object2).getTemplate().getWeaponType()) {
                    case Thrown: {
                        object = attack.getWeapon().getTemplate().getProjectileIcon();
                        break;
                    }
                    default: {
                        Ammo ammo = creature.inventory.getEquippedQuiver();
                        if (ammo == null) break;
                        object = ammo.getTemplate().getProjectileIcon();
                    }
                }
                if (object != null) {
                    Animation animation = new Animation((SimpleIcon)object);
                    animation.setAlpha(1.0f);
                    Point point = creature.getLocation().toPoint();
                    Point point2 = creature2.getLocation().toPoint();
                    float f = (float)point.screenDistance(point2);
                    float f2 = (float)point.angleTo(point2);
                    float f3 = 576.0f;
                    animation.setPosition(creature.getLocation().getCenteredScreenPoint());
                    animation.setVelocityMagnitudeAngle(f3, f2);
                    animation.setDuration(f / f3);
                    animation.setRotation(f2 * 180.0f / (float)Math.PI);
                    Game.particleManager.add(animation);
                    l = (long)(1000.0 * (double)f / (double)f3);
                }
            } else {
                object = new EntityAttackAnimation(creature, creature2);
                creature.setOffsetAnimation((EntityOffsetAnimation)object);
                Game.particleManager.addEntityOffsetAnimation((EntityOffsetAnimation)object);
                l = Game.config.getCombatDelay();
            }
            DelayedAttackCallback delayedAttackCallback = new DelayedAttackCallback(l, attack, attack2);
            delayedAttackCallback.start();
            object = new InterfaceLock(creature, 2L * (long)Game.config.getCombatDelay());
            Game.interfaceLocker.add((InterfaceLock)object);
            return delayedAttackCallback;
        }
        DelayedAttackCallback delayedAttackCallback = new DelayedAttackCallback(0L, attack, attack2);
        delayedAttackCallback.run();
        return delayedAttackCallback;
    }

    public DelayedAttackCallback creatureStandardAttack(Creature creature, Creature creature2) {
        if (creature2 == null || creature == null) {
            return null;
        }
        if (!creature.canAttack(creature2.getLocation())) {
            return null;
        }
        if (!creature.timer.canAttack()) {
            return null;
        }
        Attack attack = creature.performMainHandAttack(creature2);
        Attack attack2 = null;
        if (creature.getOffHandWeapon() != null) {
            attack2 = creature.performOffHandAttack(creature2);
        }
        return this.creatureAttack(attack, attack2, true);
    }

    private DelayedAttackCallback creatureAoOAttack(Creature creature, Creature creature2) {
        if (creature2 == null) {
            return null;
        }
        Attack attack = creature.performSingleAttack(creature2, Inventory.Slot.MainHand);
        return this.creatureAttack(attack, null, true);
    }

    public void creatureSingleAttack(Creature creature, Creature creature2, Inventory.Slot slot) {
        this.creatureAttack(creature.performSingleAttack(creature2, slot), null, false);
    }

    public DelayedAttackCallback creatureSingleAttackAnimate(Creature creature, Creature creature2, Inventory.Slot slot) {
        if (creature2 == null) {
            return null;
        }
        if (!creature.threatensLocation(creature2.getLocation())) {
            return null;
        }
        return this.creatureAttack(creature.performSingleAttack(creature2, slot), null, true);
    }

    public DelayedAttackCallback creatureTouchAttack(Creature creature, Creature creature2, boolean bl) {
        Attack attack = new Attack(creature, creature2, bl);
        if (bl) {
            return this.creatureAttack(attack, null, false);
        }
        return this.creatureAttack(attack, null, true);
    }

    public boolean checkContinueCombat() {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        for (Creature creature : this.creatures) {
            if (!this.creatureIsCombatant(creature)) continue;
            arrayList.add(creature);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!((Creature)arrayList.get(i)).getFaction().isHostile((Entity)arrayList.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean creatureIsCombatant(Creature creature) {
        if (creature.isDead() || creature.isDying()) {
            return false;
        }
        return creature.isPlayerFaction() || creature.isAIActive();
    }

    private void runTurn() {
        boolean bl = this.checkContinueCombat();
        while (bl && !this.isPartyDefeated()) {
            Object object;
            Creature creature = this.lastActiveCreature();
            if (creature != null) {
                creature.timer.endTurn();
            }
            Creature creature2 = this.nextCreatureInQueue();
            if (!creature2.timer.isWaitedOnce()) {
                creature2.elapseTime(1);
            } else {
                creature2.timer.reset();
            }
            if (creature2.isDead() || creature2.isDying() || creature2.stats.isHelpless()) continue;
            Game.selectedEntity = creature2;
            if (Game.config.autoScrollDuringCombat()) {
                Game.areaViewer.addDelayedScrollToCreature(creature2);
            }
            creature2.searchForHidingCreatures();
            if (creature2.isAIActive()) {
                this.checkAIActivation(creature2);
            }
            if (creature2 instanceof PC) {
                Game.curCampaign.party.setSelected(creature2);
                Game.curCampaign.curArea.getUtil().setPartyVisibility();
                break;
            }
            if (!creature2.getTemplate().hasScript() || !creature2.isAIActive()) continue;
            try {
                object = creature2.getTemplate().getScript();
                AsyncScriptable asyncScriptable = new AsyncScriptable((Scriptable)object);
                asyncScriptable.setDelayMillis(Game.config.getCombatDelay() * 3);
                asyncScriptable.executeAsync(ScriptFunctionType.runTurn, creature2);
                Game.interfaceLocker.add(new InterfaceAILock(creature2, asyncScriptable));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error running AI script " + creature2.getTemplate().getScript(), exception);
            }
            if (!bl) break;
            object = new InterfaceCombatLock(creature2, Game.config.getCombatDelay() * 6);
            Game.interfaceLocker.add((InterfaceLock)object);
            break;
        }
        if (this.isPartyDefeated()) {
            this.setGameOver();
        } else if (!bl) {
            this.exitCombat();
        }
        Game.mainViewer.updateInterface();
    }

    public void activeCreatureWait(int n) {
        Creature creature = this.creatures.get(this.activeCreatureIndex);
        if (creature.stats.isHelpless() || creature.isDying() || creature.isDead()) {
            return;
        }
        int n2 = this.activeCreatureIndex + 1;
        int n3 = 0;
        int n4 = n;
        while (n4 > 0) {
            if (n2 >= this.creatures.size()) {
                n2 = 0;
            }
            if (n2 == this.activeCreatureIndex) {
                return;
            }
            Creature creature2 = this.creatures.get(n2);
            if (!creature2.isDead() && creature2.isAIActive() || creature2.isPlayerFaction()) {
                --n4;
            }
            ++n3;
            ++n2;
        }
        int n5 = this.activeCreatureIndex + n3;
        int n6 = this.activeCreatureIndex - 1;
        if (n5 >= this.creatures.size()) {
            n5 -= this.creatures.size() - 1;
            n6 = this.activeCreatureIndex;
        }
        this.creatures.remove(this.activeCreatureIndex);
        this.creatures.add(n5, creature);
        creature.timer.waitTurn();
        this.activeCreatureIndex = n6;
        this.nextCombatTurn();
        Game.mainViewer.updateInterface();
    }

    private boolean isPartyDefeated() {
        for (Creature creature : Game.curCampaign.party) {
            if (creature.isDead() || creature.isDying()) continue;
            return false;
        }
        return true;
    }

    private void setGameOver() {
        Game.mainViewer.addMessage("link", "You have been defeated.");
        Game.setTurnMode(false);
        Game.curCampaign.party.setDefeated(true);
        InGameMenu inGameMenu = new InGameMenu((Widget)Game.mainViewer);
        inGameMenu.openPopupCentered();
    }

    public void exitCombat() {
        for (Creature object : this.creatures) {
            if (!object.isDead()) continue;
            object.abilities.cancelAllEffects();
        }
        if (Game.isInTurnMode()) {
            Game.mainViewer.addMessage("link", "Combat has ended.");
        }
        Game.setTurnMode(false);
        Game.mainViewer.getPortraitArea().enableAllLevelUp();
        for (Creature creature : Game.curCampaign.party) {
            if (creature.isDying() && !creature.isDead()) {
                int n = -creature.getCurrentHitPoints();
                creature.healDamage(n);
            }
            creature.timer.reset();
        }
        int n = Game.curCampaign.getDate().getTotalRoundsElapsed() - this.combatStartRound;
        for (Encounter encounter : Game.curCampaign.curArea.getEncounters()) {
            encounter.checkAwardXP(n);
        }
        Game.selectedEntity = Game.curCampaign.party.getSelected();
        Game.mainViewer.updateInterface();
        Game.timer.resetTime();
    }

    public List<Creature> getNextCreatures(int n) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>(n);
        int n2 = this.activeCreatureIndex;
        while (arrayList.size() < n) {
            Creature creature = this.creatures.get(n2);
            if (!creature.isDead() && (creature.isAIActive() || creature.isPlayerFaction())) {
                arrayList.add(this.creatures.get(n2));
            }
            if (++n2 != this.creatures.size()) continue;
            n2 = 0;
        }
        return arrayList;
    }

    public void insertCreature(Creature creature) {
        this.creatures.add(this.activeCreatureIndex + 1, creature);
    }

    public Creature lastActiveCreature() {
        if (this.activeCreatureIndex == -1) {
            return null;
        }
        return this.creatures.get(this.activeCreatureIndex);
    }

    public Creature getActiveCreature() {
        if (this.activeCreatureIndex == -1) {
            return null;
        }
        return this.creatures.get(this.activeCreatureIndex);
    }

    private Creature nextCreatureInQueue() {
        ++this.activeCreatureIndex;
        if (this.activeCreatureIndex == this.creatures.size()) {
            this.activeCreatureIndex = 0;
            Game.curCampaign.getDate().incrementRound();
        }
        return this.creatures.get(this.activeCreatureIndex);
    }

    private class CheckDefeatedAfterAoOCallback
    implements Runnable {
        private Creature target;

        private CheckDefeatedAfterAoOCallback(Creature creature) {
            this.target = creature;
        }

        @Override
        public void run() {
            if (CombatRunner.this.isPartyDefeated()) {
                CombatRunner.this.setGameOver();
            }
        }
    }

    private class TakeAoOCallback
    implements Runnable {
        private Creature parent;
        private Creature target;
        private MovementHandler.Mover moverToUnPause;

        private TakeAoOCallback(Creature creature, Creature creature2) {
            this.parent = creature;
            this.target = creature2;
        }

        @Override
        public void run() {
            Game.areaListener.getTargeterManager().endCurrentTargeter();
            Game.mainViewer.getMenu().hide();
            this.takeAoO();
            if (this.moverToUnPause != null) {
                this.moverToUnPause.decrementPauseCount();
            }
        }

        private void takeAoO() {
            this.parent.takeAttackOfOpportunity();
            DelayedAttackCallback delayedAttackCallback = CombatRunner.this.creatureAoOAttack(this.parent, this.target);
            delayedAttackCallback.addCallback(new CheckDefeatedAfterAoOCallback(this.target));
        }
    }

    private class CancelAoOCallback
    implements Runnable {
        private MovementHandler.Mover moverToUnPause;

        private CancelAoOCallback() {
        }

        @Override
        public void run() {
            Game.areaListener.getTargeterManager().cancelCurrentTargeter();
            Game.mainViewer.getMenu().hide();
            if (this.moverToUnPause != null) {
                this.moverToUnPause.decrementPauseCount();
            }
        }
    }

    private class CheckAoOCallback
    implements Targeter.CheckValidCallback {
        private Creature target;

        private CheckAoOCallback(Creature creature) {
            this.target = creature;
        }

        @Override
        public boolean isValid() {
            return !this.target.isDead();
        }
    }

    private class CreatureWithInitiative
    implements Comparable<CreatureWithInitiative> {
        private Creature creature;
        private int initiative;

        private CreatureWithInitiative(Creature creature) {
            this.creature = creature;
            this.initiative = creature.stats.get(Bonus.Type.Initiative) + Game.dice.d100();
        }

        @Override
        public int compareTo(CreatureWithInitiative creatureWithInitiative) {
            int n;
            int n2 = this.initiative;
            int n3 = creatureWithInitiative.initiative;
            if (n2 > n3) {
                return -1;
            }
            if (n2 < n3) {
                return 1;
            }
            int n4 = this.creature.stats.get(Bonus.Type.Initiative);
            if (n4 > (n = creatureWithInitiative.creature.stats.get(Bonus.Type.Initiative))) {
                return -1;
            }
            if (n4 < n) {
                return 1;
            }
            return Game.dice.d3() - 2;
        }
    }
}

