/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.ThemeInfo;
import net.sf.hale.CombatRunner;
import net.sf.hale.Game;
import net.sf.hale.TargeterManager;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.ability.Targeter;
import net.sf.hale.area.Area;
import net.sf.hale.defaultability.DefaultAbility;
import net.sf.hale.defaultability.MouseActionList;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.NPC;
import net.sf.hale.entity.PC;
import net.sf.hale.interfacelock.InterfaceCombatLock;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.view.AreaViewer;

public class AreaListener {
    private int lastMouseX;
    private int lastMouseY;
    private Point curGridPoint;
    private MouseActionList.Condition curMouseCondition;
    private ThemeInfo themeInfo;
    private Area area;
    private final AreaViewer areaViewer;
    private final CombatRunner combatRunner;
    private boolean mouseDragStartValid;
    private Point mouseDragStart;
    private boolean mouseClickedWithoutDragging = true;
    private TargeterManager targeterManager;

    public AreaListener(Area area, AreaViewer areaViewer) {
        this.areaViewer = areaViewer;
        this.setArea(area);
        this.combatRunner = new CombatRunner();
        this.targeterManager = new TargeterManager();
        this.mouseDragStart = new Point();
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public void setThemeInfo(ThemeInfo themeInfo) {
        this.themeInfo = themeInfo;
    }

    public CombatRunner getCombatRunner() {
        return this.combatRunner;
    }

    public AreaViewer getAreaViewer() {
        return this.areaViewer;
    }

    public void checkKillEntity(Entity entity) {
        if (!(entity instanceof Creature)) {
            return;
        }
        if (entity.getLocation().getArea() != this.area) {
            return;
        }
        Creature creature = (Creature)entity;
        if (!this.area.getEntities().containsEntity(creature)) {
            return;
        }
        if (creature.isSummoned() && creature.getCurrentHitPoints() <= 0) {
            boolean bl = false;
            if (creature.isPlayerFaction()) {
                if (this.combatRunner.lastActiveCreature() == creature) {
                    bl = true;
                }
                Game.curCampaign.party.removeSummon(creature);
            }
            Game.mainViewer.addMessage("red", creature.getTemplate().getName() + " is unsummoned.");
            this.area.getEntities().removeEntity(creature);
            if (bl) {
                Game.interfaceLocker.add(new InterfaceCombatLock(creature, 500L));
            }
            creature.getTemplate().getScript().executeFunction(ScriptFunctionType.onCreatureDeath, creature);
            creature.endAllAnimations();
            creature.getEffects().executeOnAllAuraChildren(ScriptFunctionType.onTargetExit);
            creature.getEffects().executeOnAll(ScriptFunctionType.onTargetExit, creature);
        } else if (!creature.isPlayerFaction() && creature.getCurrentHitPoints() <= 0) {
            Game.mainViewer.addMessage("red", creature.getTemplate().getName() + " is dead.");
            this.area.getEntities().removeEntity(creature);
            if (creature instanceof NPC) {
                NPC nPC = (NPC)creature;
                ItemList itemList = nPC.getTemplate().generateLoot();
                for (ItemList.Entry entry : itemList) {
                    Item item = entry.createItem();
                    item.setLocation(entity.getLocation());
                    this.area.addItem(item, entry.getQuantity());
                }
            }
            if (creature.getTemplate().getScript() != null) {
                creature.getTemplate().getScript().executeFunction(ScriptFunctionType.onCreatureDeath, creature);
            }
            creature.endAllAnimations();
            creature.getEffects().executeOnAllAuraChildren(ScriptFunctionType.onTargetExit);
            creature.getEffects().executeOnAll(ScriptFunctionType.onTargetExit, creature);
        } else if (creature.isPlayerFaction() && creature.getCurrentHitPoints() <= 0) {
            creature.timer.endTurn();
        }
        if (Game.isInTurnMode() && !this.combatRunner.checkContinueCombat()) {
            this.combatRunner.exitCombat();
        }
    }

    public void nextTurn() {
        this.area.getUtil().setPartyVisibility();
        this.areaViewer.mouseHoverValid = true;
        if (Game.isInTurnMode()) {
            this.combatRunner.nextCombatTurn();
        } else {
            Game.curCampaign.getDate().incrementRound();
            for (Entity entity : Game.curCampaign.curArea.getEntities()) {
                Creature creature;
                if (!(entity instanceof Creature) || !(creature = (Creature)entity).isPlayerFaction() && !creature.isAIActive()) continue;
                creature.elapseTime(1);
            }
            Game.selectedEntity = Game.curCampaign.party.getSelected();
            Game.mainViewer.updateInterface();
        }
    }

    public TargeterManager getTargeterManager() {
        return this.targeterManager;
    }

    public boolean handleEvent(Event event) {
        if (event.getType() == Event.Type.MOUSE_MOVED) {
            this.lastMouseX = event.getMouseX();
            this.lastMouseY = event.getMouseY();
            this.computeMouseState();
        }
        if (this.curGridPoint == null) {
            return true;
        }
        Location location = new Location(this.area, this.curGridPoint.x, this.curGridPoint.y);
        switch (event.getType()) {
            case MOUSE_BTNDOWN: {
                this.mouseClickedWithoutDragging = true;
                if (Game.curCampaign.party.isCurrentlyMoving() || event.getMouseButton() != 1) break;
                if (this.targeterManager.isInTargetMode()) {
                    this.targeterManager.getCurrentTargeter().showMenu(event.getMouseX() - 2, event.getMouseY() - 25);
                    break;
                }
                if (Game.interfaceLocker.locked()) break;
                Game.mouseActions.showDefaultAbilitiesMenu(Game.curCampaign.party.getSelected(), location, event.getMouseX() - 2, event.getMouseY() - 25);
                break;
            }
            case MOUSE_BTNUP: {
                PC pC;
                DefaultAbility defaultAbility;
                if (event.getMouseButton() != 0) break;
                if (this.mouseDragStartValid) {
                    this.mouseDragStartValid = false;
                    break;
                }
                if (Game.curCampaign.party.isCurrentlyMoving() && this.mouseClickedWithoutDragging) {
                    Game.mainViewer.getMainPane().cancelAllOrders();
                    break;
                }
                if (this.targeterManager.isInTargetMode() && this.mouseClickedWithoutDragging) {
                    this.targeterManager.getCurrentTargeter().performLeftClickAction();
                    break;
                }
                if (this.curMouseCondition == null || !this.mouseClickedWithoutDragging || (defaultAbility = this.curMouseCondition.getAbility()) == null || !defaultAbility.canActivate(pC = Game.curCampaign.party.getSelected(), location)) break;
                defaultAbility.activate(pC, location);
                break;
            }
            case MOUSE_DRAGGED: {
                this.mouseClickedWithoutDragging = false;
                if (this.mouseDragStartValid) {
                    this.mouseDragStartValid = false;
                    this.areaViewer.scroll(-2 * (event.getMouseX() - this.mouseDragStart.x), -2 * (event.getMouseY() - this.mouseDragStart.y));
                    break;
                }
                this.mouseDragStart.x = event.getMouseX();
                this.mouseDragStart.y = event.getMouseY();
                this.mouseDragStartValid = true;
            }
        }
        return true;
    }

    public void computeMouseState() {
        Object object;
        int n = this.lastMouseX + this.areaViewer.getScrollX() - this.areaViewer.getX();
        int n2 = this.lastMouseY + this.areaViewer.getScrollY() - this.areaViewer.getY();
        this.curGridPoint = AreaUtil.convertScreenToGrid(n, n2);
        if (this.curGridPoint.x < 0) {
            this.curGridPoint.x = 0;
        } else if (this.curGridPoint.x >= this.area.getWidth()) {
            this.curGridPoint.x = this.area.getWidth() - 1;
        }
        if (this.curGridPoint.y < 0) {
            this.curGridPoint.y = 0;
        } else if (this.curGridPoint.y >= this.area.getHeight()) {
            this.curGridPoint.y = this.area.getHeight() - 1;
        }
        Game.mainViewer.getMouseOver().setPoint(this.curGridPoint);
        this.areaViewer.mouseHoverTile.x = this.curGridPoint.x;
        this.areaViewer.mouseHoverTile.y = this.curGridPoint.y;
        if (this.targeterManager.isInTargetMode()) {
            object = this.targeterManager.getCurrentTargeter();
            if (((Targeter)object).getParent() instanceof PC) {
                ((Targeter)object).setMousePosition(n, n2, this.curGridPoint);
                this.areaViewer.mouseHoverValid = ((Targeter)object).mouseHoverValid();
                this.curMouseCondition = ((Targeter)object).getMouseActionCondition();
                ((Targeter)object).setTitleText();
            }
        } else if (Game.interfaceLocker.locked()) {
            this.curMouseCondition = MouseActionList.Condition.Cancel;
            this.areaViewer.mouseHoverValid = false;
            Game.mainViewer.clearTargetTitleText();
        } else {
            object = new Location(this.area, this.curGridPoint.x, this.curGridPoint.y);
            this.curMouseCondition = Game.mouseActions.getDefaultMouseCondition(Game.curCampaign.party.getSelected(), (Location)object);
            this.areaViewer.mouseHoverValid = this.curMouseCondition != MouseActionList.Condition.Cancel;
            Game.mainViewer.clearTargetTitleText();
        }
        object = Game.mouseActions.getMouseCursor(this.curMouseCondition);
        this.areaViewer.setMouseCursor(this.themeInfo.getMouseCursor((String)object));
    }

    public int getMouseGUIX() {
        return this.lastMouseX;
    }

    public int getMouseGUIY() {
        return this.lastMouseY;
    }

    public int getLastMouseX() {
        return this.lastMouseX + this.areaViewer.getScrollX() - this.areaViewer.getX();
    }

    public int getLastMouseY() {
        return this.lastMouseY + this.areaViewer.getScrollY() - this.areaViewer.getY();
    }
}

