/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Path;
import net.sf.hale.util.AreaUtil;

public class AITargetSet {
    private final List<TargetInfo> targets = new ArrayList<TargetInfo>();

    public AITargetSet(Creature creature, List<Creature> list) {
        int n = creature.getMainHandWeapon().getTemplate().getMaxRange();
        for (Creature creature2 : list) {
            int n2;
            Path path = null;
            if (creature.getMainHandWeapon().isMelee()) {
                n2 = AreaUtil.distance(creature.getLocation().getX(), creature.getLocation().getY(), creature2.getLocation().getX(), creature2.getLocation().getY());
                if (n2 > n) {
                    path = creature.getLocation().getArea().getUtil().findShortestPath(creature, creature2.getLocation().toPoint(), n);
                    n2 = path != null ? path.length() + 1 : Integer.MAX_VALUE;
                }
            } else {
                path = creature.getLocation().getArea().getUtil().findShortestPathIgnoreCreatures(creature, creature2.getLocation().toPoint());
                n2 = path != null ? path.length() + 1 : Integer.MAX_VALUE;
            }
            if (n2 >= Integer.MAX_VALUE) continue;
            if (path == null) {
                path = new Path(creature2.getLocation().getArea());
            }
            TargetInfo targetInfo = new TargetInfo(creature2, n2, path);
            this.targets.add(targetInfo);
        }
    }

    public Path getPath(int n) {
        return this.targets.get(n).path;
    }

    public Creature getTarget(int n) {
        return this.targets.get(n).target;
    }

    public int getDistance(int n) {
        return this.targets.get(n).distance;
    }

    public int size() {
        return this.targets.size();
    }

    public void sortFewestAoOsFirst() {
        Collections.sort(this.targets, new AoOSorter());
    }

    public void sortClosestFirst() {
        Collections.sort(this.targets, new DistanceSorter());
    }

    private class TargetInfo {
        private final Creature target;
        private final int distance;
        private final Path path;

        private TargetInfo(Creature creature, int n, Path path) {
            this.target = creature;
            this.distance = n;
            this.path = path;
        }
    }

    private class AoOSorter
    implements Comparator<TargetInfo> {
        private AoOSorter() {
        }

        @Override
        public int compare(TargetInfo targetInfo, TargetInfo targetInfo2) {
            return targetInfo.path.getNumAoOs() - targetInfo2.path.getNumAoOs();
        }
    }

    private class DistanceSorter
    implements Comparator<TargetInfo> {
        private DistanceSorter() {
        }

        @Override
        public int compare(TargetInfo targetInfo, TargetInfo targetInfo2) {
            return targetInfo.distance - targetInfo2.distance;
        }
    }
}

