/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.AITargetSet;
import net.sf.hale.Game;
import net.sf.hale.bonus.Stat;
import net.sf.hale.defaultability.Move;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.Path;
import net.sf.hale.interfacelock.MovementHandler;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class AIScriptInterface {
    public static Path getMovementPath(Creature creature, int n, int n2) {
        Move move = new Move();
        if (!move.canMove(creature, creature.getLocation().getInSameArea(n, n2), 0)) {
            return null;
        }
        return move.getComputedPath();
    }

    public static Path getMovementPath(Creature creature, Location location) {
        Move move = new Move();
        if (!move.canMove(creature, location, 0)) {
            return null;
        }
        return move.getComputedPath();
    }

    public static boolean moveTowards(Creature creature, int n, int n2, int n3) {
        return AIScriptInterface.moveTowards(creature, new Location(creature.getLocation().getArea(), n, n2), n3, true);
    }

    public static boolean moveTowards(Creature creature, int n, int n2, int n3, boolean bl) {
        return AIScriptInterface.moveTowards(creature, new Location(creature.getLocation().getArea(), n, n2), n3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveTowards(Creature creature, Location location, int n, boolean bl) {
        Move move = new Move();
        move.setTruncatePath(false);
        if (!move.canMove(creature, location, n)) {
            return false;
        }
        if (!move.moveTowards(creature, location, n, bl)) {
            return false;
        }
        MovementHandler.Mover mover = move.getMover();
        if (mover == null) {
            return false;
        }
        try {
            MovementHandler.Mover mover2 = mover;
            synchronized (mover2) {
                while (!mover.isFinished()) {
                    mover.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean moveTowards(Creature creature, Location location, int n) {
        return AIScriptInterface.moveTowards(creature, location, n, true);
    }

    public static Point findClosestEmptyTile(Point point, int n) {
        if (AIScriptInterface.checkEmpty(point)) {
            return point;
        }
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < i * 6; ++j) {
                Point point2 = AreaUtil.convertPolarToGrid(point, i, j);
                if (!AIScriptInterface.checkEmpty(point2)) continue;
                return point2;
            }
        }
        return null;
    }

    private static boolean checkEmpty(Point point) {
        if (!Game.curCampaign.curArea.isPassable(point.x, point.y)) {
            return false;
        }
        return Game.curCampaign.curArea.getCreatureAtGridPoint(point) == null;
    }

    public static void provokeAttacksOfOpportunity(Creature creature) {
        Game.areaListener.getCombatRunner().provokeAttacksOfOpportunity(creature, null);
    }

    public static Creature findCreatureWithMostDamage(Creature creature, String string) {
        List<Creature> list = AIScriptInterface.getLiveVisibleCreatures(creature, string);
        int n = Integer.MIN_VALUE;
        Creature creature2 = null;
        for (Creature creature3 : list) {
            int n2 = creature3.stats.get(Stat.MaxHP) - creature3.getCurrentHitPoints();
            if (n2 <= n) continue;
            creature2 = creature3;
            n = n2;
        }
        return creature2;
    }

    public static Creature findCreatureWithMostMaxHP(Creature creature, String string) {
        List<Creature> list = AIScriptInterface.getLiveVisibleCreatures(creature, string);
        int n = 0;
        Creature creature2 = null;
        for (Creature creature3 : list) {
            if (creature3.stats.get(Stat.MaxHP) <= n) continue;
            creature2 = creature3;
            n = creature3.stats.get(Stat.MaxHP);
        }
        return creature2;
    }

    public static Creature findNearestCreature(Creature creature, String string) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        List<Creature> list = AIScriptInterface.getLiveVisibleCreatures(creature, string);
        int n = Integer.MAX_VALUE;
        for (Creature creature2 : list) {
            int n2 = AreaUtil.distance(creature.getLocation().getX(), creature.getLocation().getY(), creature2.getLocation().getX(), creature2.getLocation().getY());
            if (n2 < n) {
                arrayList.clear();
                n = n2;
                arrayList.add(creature2);
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(creature2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return (Creature)arrayList.get(Game.dice.rand(0, arrayList.size() - 1));
    }

    public static AITargetSet getPotentialAttackTargets(Creature creature) {
        List<Creature> list = AIScriptInterface.getLiveVisibleCreatures(creature, Faction.Relationship.Hostile.toString());
        return new AITargetSet(creature, list);
    }

    public static List<Creature> getAttackableCreatures(Creature creature) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        Encounter encounter = creature.getEncounter();
        List<Creature> list = encounter != null ? encounter.getHostiles() : AIScriptInterface.getLiveVisibleCreatures(creature, "Hostile");
        for (Creature creature2 : list) {
            if (creature2.isDying() || creature2.isDead() || !creature.canAttack(creature2.getLocation()) || creature2.stats.isHidden()) continue;
            arrayList.add(creature2);
        }
        return arrayList;
    }

    public static List<Creature> getTouchableCreatures(Creature creature, String string) {
        Point[] pointArray;
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        Faction faction = creature.getFaction();
        Faction.Relationship relationship = null;
        if (string != null) {
            relationship = Faction.Relationship.valueOf(string);
        }
        for (Point point : pointArray = AreaUtil.getAdjacentTiles(creature.getLocation().getX(), creature.getLocation().getY())) {
            Creature creature2 = Game.curCampaign.curArea.getCreatureAtGridPoint(point);
            if (creature2 == null) continue;
            Faction.Relationship relationship2 = faction.getRelationship(creature2.getFaction());
            if (relationship != null && relationship2 != relationship) continue;
            arrayList.add(creature2);
        }
        Creature creature3 = Game.curCampaign.curArea.getCreatureAtGridPoint(creature.getLocation().getX(), creature.getLocation().getY());
        if (creature3 != null && (relationship == null || faction.getRelationship(faction) == relationship)) {
            arrayList.add(creature3);
        }
        return arrayList;
    }

    public static List<Creature> getVisibleCreaturesWithinRange(Creature creature, String string, int n) {
        Faction.Relationship relationship = null;
        if (string != null) {
            relationship = Faction.Relationship.valueOf(string);
        }
        List<Creature> list = AreaUtil.getVisibleCreatures(creature, relationship);
        Iterator<Creature> iterator = list.iterator();
        while (iterator.hasNext()) {
            Creature creature2 = iterator.next();
            if (AreaUtil.distance(creature2.getLocation().getX(), creature2.getLocation().getY(), creature.getLocation().getX(), creature.getLocation().getY()) * 5 <= n) continue;
            iterator.remove();
        }
        return list;
    }

    public static List<Creature> getAllCreaturesWithinRange(Creature creature, String string, int n) {
        Faction.Relationship relationship = null;
        if (string != null) {
            relationship = Faction.Relationship.valueOf(string);
        }
        List<Creature> list = Game.curCampaign.curArea.getEntities().getCreaturesWithinRadius(creature.getLocation().getX(), creature.getLocation().getY(), n / 5);
        if (relationship != null) {
            Iterator<Creature> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (creature.getFaction().getRelationship(iterator.next().getFaction()) == relationship) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public static List<Creature> getLiveVisibleCreatures(Creature creature, String string) {
        Faction.Relationship relationship = null;
        if (string != null) {
            relationship = Faction.Relationship.valueOf(string);
        }
        Encounter encounter = creature.getEncounter();
        List<Creature> list = relationship == Faction.Relationship.Hostile && encounter != null ? encounter.getHostiles() : AreaUtil.getVisibleCreatures(creature, relationship);
        Iterator<Creature> iterator = list.iterator();
        while (iterator.hasNext()) {
            Creature creature2 = iterator.next();
            if (!creature2.isDead() && !creature2.isDying() && !creature2.stats.isHidden()) continue;
            iterator.remove();
        }
        return list;
    }

    public static void sortCreatureListClosestFirst(Creature creature, List<Creature> list) {
        Collections.sort(list, new CreatureSorter(creature));
    }

    private static class CreatureSorter
    implements Comparator<Creature> {
        private Creature parent;

        private CreatureSorter(Creature creature) {
            this.parent = creature;
        }

        @Override
        public int compare(Creature creature, Creature creature2) {
            return AreaUtil.distance(creature.getLocation().getX(), creature.getLocation().getY(), this.parent.getLocation().getX(), this.parent.getLocation().getY()) - AreaUtil.distance(creature2.getLocation().getX(), creature2.getLocation().getY(), this.parent.getLocation().getX(), this.parent.getLocation().getY());
        }
    }
}

