/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.Gradient;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twl.theme.AnimatedImage;
import de.matthiasmann.twl.theme.ComposedImage;
import de.matthiasmann.twl.theme.EmptyImage;
import de.matthiasmann.twl.theme.GridImage;
import de.matthiasmann.twl.theme.HasBorder;
import de.matthiasmann.twl.theme.ImageAdjustments;
import de.matthiasmann.twl.theme.ParameterMapImpl;
import de.matthiasmann.twl.theme.ParserUtil;
import de.matthiasmann.twl.theme.RepeatImage;
import de.matthiasmann.twl.theme.StateSelectImage;
import de.matthiasmann.twl.utils.AbstractMathInterpreter;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelect;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twl.utils.XMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageManager {
    final ParameterMapImpl constants;
    private final Renderer renderer;
    private final TreeMap<String, Image> images;
    private final TreeMap<String, MouseCursor> cursors;
    private final MathInterpreter mathInterpreter;
    private Texture currentTexture;
    static final EmptyImage NONE = new EmptyImage(0, 0);
    private static final MouseCursor INHERIT_CURSOR = new MouseCursor(){};
    private static final int[] SPLIT_WEIGHTS_3 = new int[]{0, 1, 0};
    private static final int[] SPLIT_WEIGHTS_1 = new int[]{1};

    ImageManager(ParameterMapImpl constants, Renderer renderer) {
        this.constants = constants;
        this.renderer = renderer;
        this.images = new TreeMap();
        this.cursors = new TreeMap();
        this.mathInterpreter = new MathInterpreter();
        this.images.put("none", NONE);
        this.cursors.put("os-default", MouseCursor.OS_DEFAULT);
        this.cursors.put("inherit", INHERIT_CURSOR);
    }

    Image getImage(String name) {
        return this.images.get(name);
    }

    Image getReferencedImage(XMLParser xmlp) throws XmlPullParserException {
        String ref = xmlp.getAttributeNotNull("ref");
        return this.getReferencedImage(xmlp, ref);
    }

    Image getReferencedImage(XMLParser xmlp, String ref) throws XmlPullParserException {
        if (ref.endsWith(".*")) {
            throw xmlp.error("wildcard mapping not allowed");
        }
        Image img = this.images.get(ref);
        if (img == null) {
            throw xmlp.error("referenced image \"" + ref + "\" not found");
        }
        return img;
    }

    MouseCursor getReferencedCursor(XMLParser xmlp, String ref) throws XmlPullParserException {
        MouseCursor cursor = this.cursors.get(ref);
        if (cursor == null) {
            throw xmlp.error("referenced cursor \"" + ref + "\" not found");
        }
        return this.unwrapCursor(cursor);
    }

    Map<String, Image> getImages(String ref, String name) {
        return ParserUtil.resolve(this.images, ref, name, null);
    }

    public MouseCursor getCursor(String name) {
        return this.unwrapCursor(this.cursors.get(name));
    }

    Map<String, MouseCursor> getCursors(String ref, String name) {
        return ParserUtil.resolve(this.cursors, ref, name, INHERIT_CURSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseImages(XMLParser xmlp, URL baseUrl) throws XmlPullParserException, IOException {
        xmlp.require(2, null, null);
        Texture texture = null;
        String fileName = xmlp.getAttributeValue(null, "file");
        if (fileName != null) {
            String fmt = xmlp.getAttributeValue(null, "format");
            String filter = xmlp.getAttributeValue(null, "filter");
            xmlp.getAttributeValue(null, "comment");
            try {
                texture = this.renderer.loadTexture(new URL(baseUrl, fileName), fmt, filter);
                if (texture == null) {
                    throw new NullPointerException("loadTexture returned null");
                }
            }
            catch (IOException ex) {
                throw xmlp.error("Unable to load image file: " + fileName, ex);
            }
        }
        this.currentTexture = texture;
        try {
            xmlp.nextTag();
            while (!xmlp.isEndTag()) {
                String name = xmlp.getAttributeNotNull("name");
                this.checkImageName(name, xmlp);
                String tagName = xmlp.getName();
                if ("cursor".equals(xmlp.getName())) {
                    this.parseCursor(xmlp, name);
                } else {
                    Image image = this.parseImage(xmlp, tagName);
                    this.images.put(name, image);
                }
                xmlp.require(3, null, tagName);
                xmlp.nextTag();
            }
        }
        finally {
            this.currentTexture = null;
            if (texture != null) {
                texture.themeLoadingDone();
            }
        }
    }

    private MouseCursor unwrapCursor(MouseCursor cursor) {
        return cursor == INHERIT_CURSOR ? null : cursor;
    }

    private void checkImageName(String name, XMLParser xmlp) throws XmlPullParserException, XmlPullParserException {
        ParserUtil.checkNameNotEmpty(name, xmlp);
        if (this.images.containsKey(name)) {
            throw xmlp.error("image \"" + name + "\" already defined");
        }
    }

    private static Border getBorder(Image image, Border border) {
        if (border == null && image instanceof HasBorder) {
            border = ((HasBorder)((Object)image)).getBorder();
        }
        return border;
    }

    private void parseCursor(XMLParser xmlp, String name) throws IOException, XmlPullParserException {
        MouseCursor cursor;
        String ref = xmlp.getAttributeValue(null, "ref");
        if (ref != null) {
            cursor = this.cursors.get(ref);
            if (cursor == null) {
                throw xmlp.error("referenced cursor \"" + ref + "\" not found");
            }
        } else {
            ImageParams imageParams = new ImageParams();
            this.parseRectFromAttribute(xmlp, imageParams);
            int hotSpotX = xmlp.parseIntFromAttribute("hotSpotX");
            int hotSpotY = xmlp.parseIntFromAttribute("hotSpotY");
            String imageRefStr = xmlp.getAttributeValue(null, "imageRef");
            Image imageRef = null;
            if (imageRefStr != null) {
                imageRef = this.getReferencedImage(xmlp, imageRefStr);
            }
            if ((cursor = this.currentTexture.createCursor(imageParams.x, imageParams.y, imageParams.w, imageParams.h, hotSpotX, hotSpotY, imageRef)) == null) {
                cursor = MouseCursor.OS_DEFAULT;
            }
        }
        this.cursors.put(name, cursor);
        xmlp.nextTag();
    }

    private Image parseImage(XMLParser xmlp, String tagName) throws XmlPullParserException, IOException {
        ImageParams params = new ImageParams();
        params.condition = ParserUtil.parseCondition(xmlp);
        return this.parseImageNoCond(xmlp, tagName, params);
    }

    private Image parseImageNoCond(XMLParser xmlp, String tagName, ImageParams params) throws XmlPullParserException, IOException {
        this.parseStdAttributes(xmlp, params);
        Image image = this.parseImageDelegate(xmlp, tagName, params);
        return this.adjustImage(image, params);
    }

    private Image adjustImage(Image image, ImageParams params) {
        Border border = ImageManager.getBorder(image, params.border);
        if (params.tintColor != null && !Color.WHITE.equals(params.tintColor)) {
            image = image.createTintedVersion(params.tintColor);
        }
        if (params.repeatX || params.repeatY) {
            image = new RepeatImage(image, border, params.repeatX, params.repeatY);
        }
        Border imgBorder = ImageManager.getBorder(image, null);
        if (border != null && border != imgBorder || params.inset != null || params.center || params.condition != null || params.sizeOverwriteH >= 0 || params.sizeOverwriteV >= 0) {
            image = new ImageAdjustments(image, border, params.inset, params.sizeOverwriteH, params.sizeOverwriteV, params.center, params.condition);
        }
        return image;
    }

    private Image parseImageDelegate(XMLParser xmlp, String tagName, ImageParams params) throws XmlPullParserException, IOException {
        if ("area".equals(tagName)) {
            return this.parseArea(xmlp, params);
        }
        if ("alias".equals(tagName)) {
            return this.parseAlias(xmlp);
        }
        if ("composed".equals(tagName)) {
            return this.parseComposed(xmlp, params);
        }
        if ("select".equals(tagName)) {
            return this.parseStateSelect(xmlp, params);
        }
        if ("grid".equals(tagName)) {
            return this.parseGrid(xmlp, params);
        }
        if ("animation".equals(tagName)) {
            return this.parseAnimation(xmlp, params);
        }
        if ("gradient".equals(tagName)) {
            return this.parseGradient(xmlp, params);
        }
        throw xmlp.error("Unexpected '" + tagName + "'");
    }

    private Image parseComposed(XMLParser xmlp, ImageParams params) throws IOException, XmlPullParserException {
        ArrayList<Image> layers = new ArrayList<Image>();
        xmlp.nextTag();
        while (!xmlp.isEndTag()) {
            xmlp.require(2, null, null);
            String tagName = xmlp.getName();
            Image image = this.parseImage(xmlp, tagName);
            layers.add(image);
            params.border = ImageManager.getBorder(image, params.border);
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
        }
        switch (layers.size()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return (Image)layers.get(0);
            }
        }
        return new ComposedImage(layers.toArray(new Image[layers.size()]), params.border);
    }

    private Image parseStateSelect(XMLParser xmlp, ImageParams params) throws IOException, XmlPullParserException {
        ArrayList<Image> stateImages = new ArrayList<Image>();
        ArrayList<StateExpression> conditions = new ArrayList<StateExpression>();
        xmlp.nextTag();
        boolean last = false;
        while (!last && !xmlp.isEndTag()) {
            ImageAdjustments ia;
            xmlp.require(2, null, null);
            StateExpression cond = ParserUtil.parseCondition(xmlp);
            String tagName = xmlp.getName();
            Image image = this.parseImageNoCond(xmlp, tagName, new ImageParams());
            params.border = ImageManager.getBorder(image, params.border);
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
            boolean bl = last = cond == null;
            if (image instanceof ImageAdjustments && (ia = (ImageAdjustments)image).isSimple()) {
                cond = ImageManager.and(cond, ia.condition);
                image = ia.image;
            }
            if (StateSelect.isUseOptimizer() && image instanceof StateSelectImage) {
                ImageManager.inlineSelect((StateSelectImage)image, cond, stateImages, conditions);
                continue;
            }
            stateImages.add(image);
            if (cond == null) continue;
            conditions.add(cond);
        }
        if (conditions.isEmpty()) {
            System.err.println(xmlp.getFilePosition() + ": state select image needs atleast 1 condition");
            if (stateImages.isEmpty()) {
                return NONE;
            }
            return (Image)stateImages.get(0);
        }
        StateSelect select = new StateSelect(conditions);
        StateSelectImage image = new StateSelectImage(select, params.border, stateImages.toArray(new Image[stateImages.size()]));
        return image;
    }

    private static void inlineSelect(StateSelectImage src, StateExpression cond, ArrayList<Image> stateImages, ArrayList<StateExpression> conditions) {
        int n = src.images.length;
        int m = src.select.getNumExpressions();
        for (int i = 0; i < n; ++i) {
            StateExpression imgCond = i < m ? src.select.getExpression(i) : null;
            imgCond = ImageManager.and(imgCond, cond);
            stateImages.add(src.images[i]);
            if (imgCond == null) continue;
            conditions.add(imgCond);
        }
        if (n == m && cond != null) {
            stateImages.add(NONE);
            conditions.add(cond);
        }
    }

    private static StateExpression and(StateExpression imgCond, StateExpression cond) {
        if (imgCond == null) {
            imgCond = cond;
        } else if (cond != null) {
            imgCond = new StateExpression.Logic('+', imgCond, cond);
        }
        return imgCond;
    }

    private Image parseArea(XMLParser xmlp, ImageParams params) throws IOException, XmlPullParserException {
        Image image;
        this.parseRectFromAttribute(xmlp, params);
        this.parseRotationFromAttribute(xmlp, params);
        boolean tiled = xmlp.parseBoolFromAttribute("tiled", false);
        int[] splitx = ImageManager.parseSplit2(xmlp, "splitx", Math.abs(params.w));
        int[] splity = ImageManager.parseSplit2(xmlp, "splity", Math.abs(params.h));
        if (splitx != null || splity != null) {
            boolean noCenter = xmlp.parseBoolFromAttribute("nocenter", false);
            int columns = splitx != null ? 3 : 1;
            int rows = splity != null ? 3 : 1;
            Image[] imageParts = new Image[columns * rows];
            for (int r = 0; r < rows; ++r) {
                int imgH;
                int imgY;
                if (splity != null) {
                    imgY = params.h < 0 ? params.y - params.h - splity[r + 1] : params.y + splity[r];
                    imgH = (splity[r + 1] - splity[r]) * Integer.signum(params.h);
                } else {
                    imgY = params.y;
                    imgH = params.h;
                }
                for (int c = 0; c < columns; ++c) {
                    int imgW;
                    int imgX;
                    if (splitx != null) {
                        imgX = params.w < 0 ? params.x - params.w - splitx[c + 1] : params.x + splitx[c];
                        imgW = (splitx[c + 1] - splitx[c]) * Integer.signum(params.w);
                    } else {
                        imgX = params.x;
                        imgW = params.w;
                    }
                    boolean isCenter = r == rows / 2 && c == columns / 2;
                    Image img = noCenter && isCenter ? new EmptyImage(imgW, imgH) : this.createImage(xmlp, imgX, imgY, imgW, imgH, params.tintColor, isCenter & tiled, params.rot);
                    switch (params.rot) {
                        default: {
                            int idx = r * columns + c;
                            break;
                        }
                        case CLOCKWISE_90: {
                            int idx = c * rows + (rows - 1 - r);
                            break;
                        }
                        case CLOCKWISE_180: {
                            int idx = (rows - 1 - r) * columns + (columns - 1 - c);
                            break;
                        }
                        case CLOCKWISE_270: {
                            int idx = (columns - 1 - c) * rows + r;
                        }
                    }
                    imageParts[idx] = img;
                }
            }
            switch (params.rot) {
                case CLOCKWISE_90: 
                case CLOCKWISE_270: {
                    image = new GridImage(imageParts, splity != null ? SPLIT_WEIGHTS_3 : SPLIT_WEIGHTS_1, splitx != null ? SPLIT_WEIGHTS_3 : SPLIT_WEIGHTS_1, params.border);
                    break;
                }
                default: {
                    image = new GridImage(imageParts, splitx != null ? SPLIT_WEIGHTS_3 : SPLIT_WEIGHTS_1, splity != null ? SPLIT_WEIGHTS_3 : SPLIT_WEIGHTS_1, params.border);
                    break;
                }
            }
        } else {
            image = this.createImage(xmlp, params.x, params.y, params.w, params.h, params.tintColor, tiled, params.rot);
        }
        xmlp.nextTag();
        params.tintColor = null;
        if (tiled) {
            params.repeatX = false;
            params.repeatY = false;
        }
        return image;
    }

    private Image parseAlias(XMLParser xmlp) throws XmlPullParserException, XmlPullParserException, IOException {
        Image image = this.getReferencedImage(xmlp);
        xmlp.nextTag();
        return image;
    }

    private static int[] parseSplit2(XMLParser xmlp, String attribName, int size) throws XmlPullParserException {
        String splitStr = xmlp.getAttributeValue(null, attribName);
        if (splitStr != null) {
            int comma = splitStr.indexOf(44);
            if (comma < 0) {
                throw xmlp.error(attribName + " requires 2 values");
            }
            try {
                int[] result = new int[4];
                int start = 0;
                for (int i = 0; i < 2; ++i) {
                    String part = TextUtil.trim(splitStr, start, comma);
                    if (part.length() == 0) {
                        throw new NumberFormatException("empty string");
                    }
                    int off = 0;
                    int sign = 1;
                    switch (part.charAt(0)) {
                        case 'B': 
                        case 'R': 
                        case 'b': 
                        case 'r': {
                            off = size;
                            sign = -1;
                        }
                        case 'L': 
                        case 'T': 
                        case 'l': 
                        case 't': {
                            part = TextUtil.trim(part, 1);
                        }
                    }
                    int value = Integer.parseInt(part);
                    result[i + 1] = Math.max(0, Math.min(size, off + sign * value));
                    start = comma + 1;
                    comma = splitStr.length();
                }
                if (result[1] > result[2]) {
                    int tmp = result[1];
                    result[1] = result[2];
                    result[2] = tmp;
                }
                result[3] = size;
                return result;
            }
            catch (NumberFormatException ex) {
                throw xmlp.error("Unable to parse " + attribName + ": \"" + splitStr + "\"", ex);
            }
        }
        return null;
    }

    private void parseSubImages(XMLParser xmlp, Image[] textures) throws XmlPullParserException, IOException {
        int idx = 0;
        while (xmlp.isStartTag()) {
            if (idx == textures.length) {
                throw xmlp.error("Too many sub images");
            }
            String tagName = xmlp.getName();
            textures[idx++] = this.parseImage(xmlp, tagName);
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
        }
        if (idx != textures.length) {
            throw xmlp.error("Not enough sub images");
        }
    }

    private Image parseGrid(XMLParser xmlp, ImageParams params) throws IOException, XmlPullParserException {
        try {
            int[] weightsX = ParserUtil.parseIntArrayFromAttribute(xmlp, "weightsX");
            int[] weightsY = ParserUtil.parseIntArrayFromAttribute(xmlp, "weightsY");
            Image[] textures = new Image[weightsX.length * weightsY.length];
            xmlp.nextTag();
            this.parseSubImages(xmlp, textures);
            GridImage image = new GridImage(textures, weightsX, weightsY, params.border);
            return image;
        }
        catch (IllegalArgumentException ex) {
            throw xmlp.error("Invalid value", ex);
        }
    }

    private void parseAnimElements(XMLParser xmlp, String tagName, ArrayList<AnimatedImage.Element> frames) throws XmlPullParserException, IOException {
        if ("repeat".equals(tagName)) {
            frames.add(this.parseAnimRepeat(xmlp));
        } else if ("frame".equals(tagName)) {
            frames.add(this.parseAnimFrame(xmlp));
        } else if ("frames".equals(tagName)) {
            this.parseAnimFrames(xmlp, frames);
        } else {
            throw xmlp.unexpected();
        }
    }

    private AnimatedImage.Img parseAnimFrame(XMLParser xmlp) throws XmlPullParserException, IOException {
        int duration = xmlp.parseIntFromAttribute("duration");
        if (duration < 0) {
            throw new IllegalArgumentException("duration must be >= 0 ms");
        }
        AnimParams animParams = this.parseAnimParams(xmlp);
        Image image = this.getReferencedImage(xmlp);
        AnimatedImage.Img img = new AnimatedImage.Img(duration, image, animParams.tintColor, animParams.zoomX, animParams.zoomY, animParams.zoomCenterX, animParams.zoomCenterY);
        xmlp.nextTag();
        return img;
    }

    private AnimParams parseAnimParams(XMLParser xmlp) throws XmlPullParserException {
        AnimParams params = new AnimParams();
        params.tintColor = ParserUtil.parseColorFromAttribute(xmlp, "tint", this.constants, Color.WHITE);
        float zoom = xmlp.parseFloatFromAttribute("zoom", 1.0f);
        params.zoomX = xmlp.parseFloatFromAttribute("zoomX", zoom);
        params.zoomY = xmlp.parseFloatFromAttribute("zoomY", zoom);
        params.zoomCenterX = xmlp.parseFloatFromAttribute("zoomCenterX", 0.5f);
        params.zoomCenterY = xmlp.parseFloatFromAttribute("zoomCenterY", 0.5f);
        return params;
    }

    private void parseAnimFrames(XMLParser xmlp, ArrayList<AnimatedImage.Element> frames) throws XmlPullParserException, IOException {
        ImageParams params = new ImageParams();
        this.parseRectFromAttribute(xmlp, params);
        this.parseRotationFromAttribute(xmlp, params);
        int duration = xmlp.parseIntFromAttribute("duration");
        if (duration < 1) {
            throw new IllegalArgumentException("duration must be >= 1 ms");
        }
        int count = xmlp.parseIntFromAttribute("count");
        if (count < 1) {
            throw new IllegalArgumentException("count must be >= 1");
        }
        AnimParams animParams = this.parseAnimParams(xmlp);
        int xOffset = xmlp.parseIntFromAttribute("offsetx", 0);
        int yOffset = xmlp.parseIntFromAttribute("offsety", 0);
        if (count > 1 && xOffset == 0 && yOffset == 0) {
            throw new IllegalArgumentException("offsets required for multiple frames");
        }
        for (int i = 0; i < count; ++i) {
            Image image = this.createImage(xmlp, params.x, params.y, params.w, params.h, Color.WHITE, false, params.rot);
            AnimatedImage.Img img = new AnimatedImage.Img(duration, image, animParams.tintColor, animParams.zoomX, animParams.zoomY, animParams.zoomCenterX, animParams.zoomCenterY);
            frames.add(img);
            params.x += xOffset;
            params.y += yOffset;
        }
        xmlp.nextTag();
    }

    private AnimatedImage.Repeat parseAnimRepeat(XMLParser xmlp) throws XmlPullParserException, IOException {
        String strRepeatCount = xmlp.getAttributeValue(null, "count");
        int repeatCount = 0;
        if (strRepeatCount != null && (repeatCount = Integer.parseInt(strRepeatCount)) <= 0) {
            throw new IllegalArgumentException("Invalid repeat count");
        }
        boolean lastRepeatsEndless = false;
        boolean hasWarned = false;
        ArrayList<AnimatedImage.Element> children = new ArrayList<AnimatedImage.Element>();
        xmlp.nextTag();
        while (xmlp.isStartTag()) {
            if (lastRepeatsEndless && !hasWarned) {
                hasWarned = true;
                this.getLogger().log(Level.WARNING, "Animation frames after an endless repeat won''t be displayed: {0}", xmlp.getPositionDescription());
            }
            String tagName = xmlp.getName();
            this.parseAnimElements(xmlp, tagName, children);
            AnimatedImage.Element e = children.get(children.size() - 1);
            lastRepeatsEndless = e instanceof AnimatedImage.Repeat && ((AnimatedImage.Repeat)e).repeatCount == 0;
            xmlp.require(3, null, tagName);
            xmlp.nextTag();
        }
        return new AnimatedImage.Repeat(children.toArray(new AnimatedImage.Element[children.size()]), repeatCount);
    }

    private Border getBorder(AnimatedImage.Element e) {
        if (e instanceof AnimatedImage.Repeat) {
            AnimatedImage.Repeat r = (AnimatedImage.Repeat)e;
            for (AnimatedImage.Element c : r.children) {
                Border border = this.getBorder(c);
                if (border == null) continue;
                return border;
            }
        } else if (e instanceof AnimatedImage.Img) {
            AnimatedImage.Img i = (AnimatedImage.Img)e;
            if (i.image instanceof HasBorder) {
                return ((HasBorder)((Object)i.image)).getBorder();
            }
        }
        return null;
    }

    private Image parseAnimation(XMLParser xmlp, ImageParams params) throws XmlPullParserException, IOException {
        try {
            String timeSource = xmlp.getAttributeNotNull("timeSource");
            int frozenTime = xmlp.parseIntFromAttribute("frozenTime", -1);
            AnimatedImage.Repeat root = this.parseAnimRepeat(xmlp);
            if (params.border == null) {
                params.border = this.getBorder(root);
            }
            AnimatedImage image = new AnimatedImage(this.renderer, root, timeSource, params.border, params.tintColor == null ? Color.WHITE : params.tintColor, frozenTime);
            params.tintColor = null;
            return image;
        }
        catch (IllegalArgumentException ex) {
            throw xmlp.error("Unable to parse", ex);
        }
    }

    private Image parseGradient(XMLParser xmlp, ImageParams params) throws XmlPullParserException, IOException {
        try {
            Gradient.Type type = xmlp.parseEnumFromAttribute("type", Gradient.Type.class);
            Gradient.Wrap wrap = xmlp.parseEnumFromAttribute("wrap", Gradient.Wrap.class, Gradient.Wrap.SCALE);
            Gradient gradient = new Gradient(type);
            gradient.setWrap(wrap);
            xmlp.nextTag();
            while (xmlp.isStartTag()) {
                xmlp.require(2, null, "stop");
                float pos = xmlp.parseFloatFromAttribute("pos");
                Color color = ParserUtil.parseColor(xmlp, xmlp.getAttributeNotNull("color"), this.constants);
                gradient.addStop(pos, color);
                xmlp.nextTag();
                xmlp.require(3, null, "stop");
                xmlp.nextTag();
            }
            return this.renderer.createGradient(gradient);
        }
        catch (IllegalArgumentException ex) {
            throw xmlp.error("Unable to parse", ex);
        }
    }

    private Image createImage(XMLParser xmlp, int x, int y, int w, int h, Color tintColor, boolean tiled, Texture.Rotation rotation) {
        if (w == 0 || h == 0) {
            return new EmptyImage(Math.abs(w), Math.abs(h));
        }
        Texture texture = this.currentTexture;
        int texWidth = texture.getWidth();
        int texHeight = texture.getHeight();
        int x1 = x + Math.abs(w);
        int y1 = y + Math.abs(h);
        if (x < 0 || x >= texWidth || x1 < 0 || x1 > texWidth || y < 0 || y >= texHeight || y1 < 0 || y1 > texHeight) {
            this.getLogger().log(Level.WARNING, "texture partly outside of file: {0}", xmlp.getPositionDescription());
            x = Math.max(0, Math.min(x, texWidth));
            y = Math.max(0, Math.min(y, texHeight));
            w = Integer.signum(w) * (Math.max(0, Math.min(x1, texWidth)) - x);
            h = Integer.signum(h) * (Math.max(0, Math.min(y1, texHeight)) - y);
        }
        return texture.getImage(x, y, w, h, tintColor, tiled, rotation);
    }

    private void parseRectFromAttribute(XMLParser xmlp, ImageParams params) throws XmlPullParserException {
        if (this.currentTexture == null) {
            throw xmlp.error("can't create area outside of <imagefile> object");
        }
        String xywh = xmlp.getAttributeNotNull("xywh");
        if ("*".equals(xywh)) {
            params.x = 0;
            params.y = 0;
            params.w = this.currentTexture.getWidth();
            params.h = this.currentTexture.getHeight();
        } else {
            try {
                int[] coords = TextUtil.parseIntArray(xywh);
                if (coords.length != 4) {
                    throw xmlp.error("xywh requires 4 integer arguments");
                }
                params.x = coords[0];
                params.y = coords[1];
                params.w = coords[2];
                params.h = coords[3];
            }
            catch (IllegalArgumentException ex) {
                throw xmlp.error("can't parse xywh argument", ex);
            }
        }
    }

    private void parseRotationFromAttribute(XMLParser xmlp, ImageParams params) throws XmlPullParserException {
        if (this.currentTexture == null) {
            throw xmlp.error("can't create area outside of <imagefile> object");
        }
        int rot = xmlp.parseIntFromAttribute("rot", 0);
        switch (rot) {
            case 0: {
                params.rot = Texture.Rotation.NONE;
                break;
            }
            case 90: {
                params.rot = Texture.Rotation.CLOCKWISE_90;
                break;
            }
            case 180: {
                params.rot = Texture.Rotation.CLOCKWISE_180;
                break;
            }
            case 270: {
                params.rot = Texture.Rotation.CLOCKWISE_270;
                break;
            }
            default: {
                throw xmlp.error("invalid rotation angle");
            }
        }
    }

    private void parseStdAttributes(XMLParser xmlp, ImageParams params) throws XmlPullParserException {
        params.tintColor = ParserUtil.parseColorFromAttribute(xmlp, "tint", this.constants, null);
        params.border = ParserUtil.parseBorderFromAttribute(xmlp, "border");
        params.inset = ParserUtil.parseBorderFromAttribute(xmlp, "inset");
        params.repeatX = xmlp.parseBoolFromAttribute("repeatX", false);
        params.repeatY = xmlp.parseBoolFromAttribute("repeatY", false);
        params.sizeOverwriteH = ParserUtil.parseIntExpressionFromAttribute(xmlp, "sizeOverwriteH", -1, this.mathInterpreter);
        params.sizeOverwriteV = ParserUtil.parseIntExpressionFromAttribute(xmlp, "sizeOverwriteV", -1, this.mathInterpreter);
        params.center = xmlp.parseBoolFromAttribute("center", false);
    }

    Logger getLogger() {
        return Logger.getLogger(ImageManager.class.getName());
    }

    class MathInterpreter
    extends AbstractMathInterpreter {
        MathInterpreter() {
        }

        public void accessVariable(String name) {
            Image img = ImageManager.this.getImage(name);
            if (img != null) {
                this.push(img);
                return;
            }
            Object obj = ImageManager.this.constants.getParam(name);
            if (obj != null) {
                this.push(obj);
                return;
            }
            throw new IllegalArgumentException("variable not found: " + name);
        }

        protected Object accessField(Object obj, String field) {
            if (obj instanceof ParameterMapImpl) {
                Object result = ((ParameterMapImpl)obj).getParam(field);
                if (result == null) {
                    throw new IllegalArgumentException("field not found: " + field);
                }
                return result;
            }
            if (obj instanceof Image && "border".equals(field)) {
                Border border = null;
                if (obj instanceof HasBorder) {
                    border = ((HasBorder)obj).getBorder();
                }
                return border != null ? border : Border.ZERO;
            }
            return super.accessField(obj, field);
        }
    }

    static class AnimParams {
        Color tintColor;
        float zoomX;
        float zoomY;
        float zoomCenterX;
        float zoomCenterY;

        AnimParams() {
        }
    }

    static class ImageParams {
        int x;
        int y;
        int w;
        int h;
        Color tintColor;
        Border border;
        Border inset;
        boolean repeatX;
        boolean repeatY;
        int sizeOverwriteH = -1;
        int sizeOverwriteV = -1;
        boolean center;
        StateExpression condition;
        Texture.Rotation rot;

        ImageParams() {
        }
    }
}

