/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.theme.HasBorder;

public class AnimatedImage
implements Image,
HasBorder {
    final Renderer renderer;
    final Element root;
    final AnimationState.StateKey timeSource;
    final Border border;
    final float r;
    final float g;
    final float b;
    final float a;
    final int width;
    final int height;
    final int frozenTime;

    AnimatedImage(Renderer renderer, Element root, String timeSource, Border border, Color tintColor, int frozenTime) {
        this.renderer = renderer;
        this.root = root;
        this.timeSource = AnimationState.StateKey.get(timeSource);
        this.border = border;
        this.r = tintColor.getRedFloat();
        this.g = tintColor.getGreenFloat();
        this.b = tintColor.getBlueFloat();
        this.a = tintColor.getAlphaFloat();
        this.width = root.getWidth();
        this.height = root.getHeight();
        this.frozenTime = frozenTime;
    }

    AnimatedImage(AnimatedImage src, Color tintColor) {
        this.renderer = src.renderer;
        this.root = src.root;
        this.timeSource = src.timeSource;
        this.border = src.border;
        this.r = src.r * tintColor.getRedFloat();
        this.g = src.g * tintColor.getGreenFloat();
        this.b = src.b * tintColor.getBlueFloat();
        this.a = src.a * tintColor.getAlphaFloat();
        this.width = src.width;
        this.height = src.height;
        this.frozenTime = src.frozenTime;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.width, this.height);
    }

    public void draw(AnimationState as, int x, int y, int width, int height) {
        int time = 0;
        if (as != null) {
            time = this.frozenTime < 0 || as.getShouldAnimateState(this.timeSource) ? as.getAnimationTime(this.timeSource) : this.frozenTime;
        }
        this.root.render(time, null, x, y, width, height, this, as);
    }

    public Border getBorder() {
        return this.border;
    }

    public Image createTintedVersion(Color color) {
        return new AnimatedImage(this, color);
    }

    static class Repeat
    extends Element {
        final Element[] children;
        final int repeatCount;
        final int singleDuration;

        Repeat(Element[] children, int repeatCount) {
            this.children = children;
            this.repeatCount = repeatCount;
            assert (repeatCount >= 0);
            assert (children.length > 0);
            for (Element e : children) {
                this.duration += e.duration;
            }
            this.singleDuration = this.duration;
            this.duration = repeatCount == 0 ? Integer.MAX_VALUE : (this.duration *= repeatCount);
        }

        int getHeight() {
            int tmp = 0;
            for (Element e : this.children) {
                tmp = Math.max(tmp, e.getHeight());
            }
            return tmp;
        }

        int getWidth() {
            int tmp = 0;
            for (Element e : this.children) {
                tmp = Math.max(tmp, e.getWidth());
            }
            return tmp;
        }

        Img getFirstImg() {
            return this.children[0].getFirstImg();
        }

        void render(int time, Img next, int x, int y, int width, int height, AnimatedImage ai, AnimationState as) {
            if (this.singleDuration == 0) {
                return;
            }
            int iteration = 0;
            if (this.repeatCount == 0) {
                time %= this.singleDuration;
            } else {
                iteration = time / this.singleDuration;
                time -= Math.min(iteration, this.repeatCount - 1) * this.singleDuration;
            }
            Element e = null;
            for (int i = 0; i < this.children.length; ++i) {
                e = this.children[i];
                if (time < e.duration && e.duration > 0) {
                    if (i + 1 < this.children.length) {
                        next = this.children[i + 1].getFirstImg();
                        break;
                    }
                    if (this.repeatCount != 0 && iteration + 1 >= this.repeatCount) break;
                    next = this.getFirstImg();
                    break;
                }
                time -= e.duration;
            }
            if (e != null) {
                e.render(time, next, x, y, width, height, ai, as);
            }
        }
    }

    static class Img
    extends Element {
        final Image image;
        final float r;
        final float g;
        final float b;
        final float a;
        final float zoomX;
        final float zoomY;
        final float zoomCenterX;
        final float zoomCenterY;

        Img(int duration, Image image, Color tintColor, float zoomX, float zoomY, float zoomCenterX, float zoomCenterY) {
            if (duration < 0) {
                throw new IllegalArgumentException("duration");
            }
            this.duration = duration;
            this.image = image;
            this.r = tintColor.getRedFloat();
            this.g = tintColor.getGreenFloat();
            this.b = tintColor.getBlueFloat();
            this.a = tintColor.getAlphaFloat();
            this.zoomX = zoomX;
            this.zoomY = zoomY;
            this.zoomCenterX = zoomCenterX;
            this.zoomCenterY = zoomCenterY;
        }

        int getWidth() {
            return this.image.getWidth();
        }

        int getHeight() {
            return this.image.getHeight();
        }

        Img getFirstImg() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void render(int time, Img next, int x, int y, int width, int height, AnimatedImage ai, AnimationState as) {
            float rr = this.r;
            float gg = this.g;
            float bb = this.b;
            float aa = this.a;
            float zx = this.zoomX;
            float zy = this.zoomY;
            float cx = this.zoomCenterX;
            float cy = this.zoomCenterY;
            if (next != null) {
                float t = (float)time / (float)this.duration;
                rr = Img.blend(rr, next.r, t);
                gg = Img.blend(gg, next.g, t);
                bb = Img.blend(bb, next.b, t);
                aa = Img.blend(aa, next.a, t);
                zx = Img.blend(zx, next.zoomX, t);
                zy = Img.blend(zy, next.zoomY, t);
                cx = Img.blend(cx, next.zoomCenterX, t);
                cy = Img.blend(cy, next.zoomCenterY, t);
            }
            ai.renderer.pushGlobalTintColor(rr * ai.r, gg * ai.g, bb * ai.b, aa * ai.a);
            try {
                int zWidth = (int)((float)width * zx);
                int zHeight = (int)((float)height * zy);
                this.image.draw(as, x + (int)((float)(width - zWidth) * cx), y + (int)((float)(height - zHeight) * cy), zWidth, zHeight);
            }
            finally {
                ai.renderer.popGlobalTintColor();
            }
        }

        private static float blend(float a, float b, float t) {
            return a + (b - a) * t;
        }
    }

    static abstract class Element {
        int duration;

        Element() {
        }

        abstract int getWidth();

        abstract int getHeight();

        abstract Img getFirstImg();

        abstract void render(int var1, Img var2, int var3, int var4, int var5, int var6, AnimatedImage var7, AnimationState var8);
    }
}

