/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.SupportsDrawRepeat;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.renderer.lwjgl.TextureAreaBase;
import org.lwjgl.opengl.GL11;

public class TextureArea
extends TextureAreaBase
implements Image,
SupportsDrawRepeat {
    protected static final int REPEAT_CACHE_SIZE = 10;
    protected final LWJGLTexture texture;
    protected final Color tintColor;
    protected int repeatCacheID = -1;

    public TextureArea(LWJGLTexture texture, int x, int y, int width, int height, Color tintColor) {
        super(x, y, width, height, texture.getTexWidth(), texture.getTexHeight());
        this.texture = texture;
        this.tintColor = tintColor == null ? Color.WHITE : tintColor;
    }

    TextureArea(TextureArea src, Color tintColor) {
        super(src);
        this.texture = src.texture;
        this.tintColor = tintColor;
    }

    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.width, this.height);
    }

    public void draw(AnimationState as, int x, int y, int w, int h) {
        if (this.texture.bind(this.tintColor)) {
            GL11.glBegin((int)7);
            this.drawQuad(x, y, w, h);
            GL11.glEnd();
        }
    }

    public void draw(AnimationState as, int x, int y, int width, int height, int repeatCountX, int repeatCountY) {
        if (this.texture.bind(this.tintColor)) {
            if (repeatCountX * this.width != width || repeatCountY * this.height != height) {
                this.drawRepeatSlow(x, y, width, height, repeatCountX, repeatCountY);
                return;
            }
            if (repeatCountX < 10 || repeatCountY < 10) {
                this.drawRepeat(x, y, repeatCountX, repeatCountY);
                return;
            }
            this.drawRepeatCached(x, y, repeatCountX, repeatCountY);
        }
    }

    private void drawRepeatSlow(int x, int y, int width, int height, int repeatCountX, int repeatCountY) {
        GL11.glBegin((int)7);
        while (repeatCountY > 0) {
            int rowHeight = height / repeatCountY;
            int cx = 0;
            int xi = 0;
            while (xi < repeatCountX) {
                int nx = ++xi * width / repeatCountX;
                this.drawQuad(x + cx, y, nx - cx, rowHeight);
                cx = nx;
            }
            y += rowHeight;
            height -= rowHeight;
            --repeatCountY;
        }
        GL11.glEnd();
    }

    protected void drawRepeat(int x, int y, int repeatCountX, int repeatCountY) {
        short w = this.width;
        short h = this.height;
        GL11.glBegin((int)7);
        while (repeatCountY-- > 0) {
            int curX = x;
            int cntX = repeatCountX;
            while (cntX-- > 0) {
                this.drawQuad(curX, y, w, h);
                curX += w;
            }
            y += h;
        }
        GL11.glEnd();
    }

    protected void drawRepeatCached(int x, int y, int repeatCountX, int repeatCountY) {
        int cacheBlocksX;
        int repeatsByCacheX;
        if (this.repeatCacheID < 0) {
            this.createRepeatCache();
        }
        if (repeatCountX > (repeatsByCacheX = (cacheBlocksX = repeatCountX / 10) * 10)) {
            this.drawRepeat(x + this.width * repeatsByCacheX, y, repeatCountX - repeatsByCacheX, repeatCountY);
        }
        do {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glCallList((int)this.repeatCacheID);
            for (int i = 1; i < cacheBlocksX; ++i) {
                GL11.glTranslatef((float)(this.width * 10), (float)0.0f, (float)0.0f);
                GL11.glCallList((int)this.repeatCacheID);
            }
            GL11.glPopMatrix();
            y += this.height * 10;
        } while ((repeatCountY -= 10) >= 10);
        if (repeatCountY > 0) {
            this.drawRepeat(x, y, repeatsByCacheX, repeatCountY);
        }
    }

    protected void createRepeatCache() {
        this.repeatCacheID = GL11.glGenLists((int)1);
        this.texture.renderer.textureAreas.add(this);
        GL11.glNewList((int)this.repeatCacheID, (int)4864);
        this.drawRepeat(0, 0, 10, 10);
        GL11.glEndList();
    }

    void destroyRepeatCache() {
        GL11.glDeleteLists((int)this.repeatCacheID, (int)1);
        this.repeatCacheID = -1;
    }

    public Image createTintedVersion(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        Color newTintColor = this.tintColor.multiply(color);
        if (newTintColor.equals(this.tintColor)) {
            return this;
        }
        return new TextureArea(this, newTintColor);
    }
}

