/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer;

import de.matthiasmann.twl.Color;
import java.util.ArrayList;

public class Gradient {
    private final Type type;
    private Wrap wrap;
    private final ArrayList<Stop> stops;

    public Gradient(Type type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
        this.wrap = Wrap.SCALE;
        this.stops = new ArrayList();
    }

    public Type getType() {
        return this.type;
    }

    public void setWrap(Wrap wrap) {
        if (wrap == null) {
            throw new NullPointerException("wrap");
        }
        this.wrap = wrap;
    }

    public Wrap getWrap() {
        return this.wrap;
    }

    public int getNumStops() {
        return this.stops.size();
    }

    public Stop getStop(int index) {
        return this.stops.get(index);
    }

    public Stop[] getStops() {
        return this.stops.toArray(new Stop[this.stops.size()]);
    }

    public void addStop(float pos, Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        int numStops = this.stops.size();
        if (numStops == 0) {
            if (!(pos >= 0.0f)) {
                throw new IllegalArgumentException("first stop must be >= 0.0f");
            }
            if (pos > 0.0f) {
                this.stops.add(new Stop(0.0f, color));
            }
        }
        if (numStops > 0 && !(pos > this.stops.get((int)(numStops - 1)).pos)) {
            throw new IllegalArgumentException("pos must be monotone increasing");
        }
        this.stops.add(new Stop(pos, color));
    }

    public static class Stop {
        final float pos;
        final Color color;

        public Stop(float pos, Color color) {
            this.pos = pos;
            this.color = color;
        }

        public float getPos() {
            return this.pos;
        }

        public Color getColor() {
            return this.color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Wrap {
        SCALE,
        CLAMP,
        REPEAT,
        MIRROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        HORIZONTAL,
        VERTICAL;

    }
}

