/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.utils.TypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WheelWidget<T>
extends Widget {
    private final TypeMapping<ItemRenderer> itemRenderer = new TypeMapping();
    private final L listener = new L();
    private final R renderer = new R();
    private final Runnable timerCB = new Runnable(){

        public void run() {
            WheelWidget.this.onTimer();
        }
    };
    protected int itemHeight;
    protected int numVisibleItems;
    protected Image selectedOverlay;
    private static final int TIMER_INTERVAL = 30;
    private static final int MIN_SPEED = 3;
    private static final int MAX_SPEED = 100;
    protected Timer timer;
    protected int dragStartY;
    protected long lastDragTime;
    protected long lastDragDelta;
    protected int lastDragDist;
    protected boolean hasDragStart;
    protected boolean dragActive;
    protected int scrollOffset;
    protected int scrollAmount;
    protected ListModel<T> model;
    protected IntegerModel selectedModel;
    protected int selected;
    protected boolean cyclic;

    public WheelWidget() {
        this.itemRenderer.put(String.class, new StringItemRenderer());
        super.insertChild(this.renderer, 0);
        this.setCanAcceptKeyboardFocus(true);
    }

    public WheelWidget(ListModel<T> model) {
        this();
        this.model = model;
    }

    public ListModel<T> getModel() {
        return this.model;
    }

    public void setModel(ListModel<T> model) {
        this.removeListener();
        this.model = model;
        this.addListener();
        this.invalidateLayout();
    }

    public IntegerModel getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(IntegerModel selectedModel) {
        this.removeSelectedListener();
        this.selectedModel = selectedModel;
        this.addSelectedListener();
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        int oldSelected = this.selected;
        if (oldSelected != selected) {
            this.selected = selected;
            if (this.selectedModel != null) {
                this.selectedModel.setValue(selected);
            }
            this.firePropertyChange("selected", oldSelected, selected);
        }
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public int getNumVisibleItems() {
        return this.numVisibleItems;
    }

    public boolean removeItemRenderer(Class<? extends T> clazz) {
        if (this.itemRenderer.remove(clazz)) {
            super.removeAllChildren();
            this.invalidateLayout();
            return true;
        }
        return false;
    }

    public void registerItemRenderer(Class<? extends T> clazz, ItemRenderer value) {
        this.itemRenderer.put(clazz, value);
        this.invalidateLayout();
    }

    public void scroll(int amount) {
        this.scrollInt(amount);
        this.scrollAmount = 0;
    }

    protected void scrollInt(int amount) {
        int pos = this.selected;
        int half = this.itemHeight / 2;
        this.scrollOffset += amount;
        while (this.scrollOffset >= half) {
            this.scrollOffset -= this.itemHeight;
            ++pos;
        }
        while (this.scrollOffset <= -half) {
            this.scrollOffset += this.itemHeight;
            --pos;
        }
        if (!this.cyclic) {
            int n = this.getNumEntries();
            if (n > 0) {
                while (pos >= n) {
                    --pos;
                    this.scrollOffset += this.itemHeight;
                }
            }
            while (pos < 0) {
                ++pos;
                this.scrollOffset -= this.itemHeight;
            }
            this.scrollOffset = Math.max(-this.itemHeight, Math.min(this.itemHeight, this.scrollOffset));
        }
        this.setSelected(pos);
        if (this.scrollOffset == 0 && this.scrollAmount == 0) {
            this.stopTimer();
        } else {
            this.startTimer();
        }
    }

    public void autoScroll(int dir) {
        if (dir != 0) {
            this.scrollAmount = this.scrollAmount != 0 && Integer.signum(this.scrollAmount) != Integer.signum(dir) ? dir : (this.scrollAmount += dir);
            this.startTimer();
        }
    }

    @Override
    public int getPreferredInnerHeight() {
        return this.numVisibleItems * this.itemHeight;
    }

    @Override
    public int getPreferredInnerWidth() {
        int width = 0;
        int n = this.getNumEntries();
        for (int i = 0; i < n; ++i) {
            Widget w = this.getItemRenderer(i);
            if (w == null) continue;
            width = Math.max(width, w.getPreferredWidth());
        }
        return width;
    }

    @Override
    protected void paintOverlay(GUI gui) {
        super.paintOverlay(gui);
        if (this.selectedOverlay != null) {
            int y = this.getInnerY() + this.itemHeight * (this.numVisibleItems / 2);
            if ((this.numVisibleItems & 1) == 0) {
                y -= this.itemHeight / 2;
            }
            this.selectedOverlay.draw(this.getAnimationState(), this.getX(), y, this.getWidth(), this.itemHeight);
        }
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (evt.isMouseDragEnd() && this.dragActive) {
            int absDist = Math.abs(this.lastDragDist);
            if (absDist > 3 && this.lastDragDelta > 0L) {
                int amount = (int)Math.min(1000L, (long)(absDist * 100) / this.lastDragDelta);
                this.autoScroll(amount * Integer.signum(this.lastDragDist));
            }
            this.hasDragStart = false;
            this.dragActive = false;
            return true;
        }
        if (evt.isMouseDragEvent()) {
            if (this.hasDragStart) {
                long time = this.getTime();
                this.dragActive = true;
                this.lastDragDist = this.dragStartY - evt.getMouseY();
                this.lastDragDelta = Math.max(1L, time - this.lastDragTime);
                this.scroll(this.lastDragDist);
                this.dragStartY = evt.getMouseY();
                this.lastDragTime = time;
            }
            return true;
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        switch (evt.getType()) {
            case MOUSE_WHEEL: {
                this.autoScroll(this.itemHeight * evt.getMouseWheelDelta());
                return true;
            }
            case MOUSE_BTNDOWN: {
                if (evt.getMouseButton() == 0) {
                    this.dragStartY = evt.getMouseY();
                    this.lastDragTime = this.getTime();
                    this.hasDragStart = true;
                }
                return true;
            }
            case KEY_PRESSED: {
                switch (evt.getKeyCode()) {
                    case 200: {
                        this.autoScroll(-this.itemHeight);
                        return true;
                    }
                    case 208: {
                        this.autoScroll(this.itemHeight);
                        return true;
                    }
                }
                return false;
            }
        }
        return evt.isMouseEvent();
    }

    protected long getTime() {
        GUI gui = this.getGUI();
        return gui != null ? gui.getCurrentTime() : 0L;
    }

    protected int getNumEntries() {
        return this.model == null ? 0 : this.model.getNumEntries();
    }

    protected Widget getItemRenderer(int i) {
        Widget w;
        ItemRenderer ir;
        T item = this.model.getEntry(i);
        if (item != null && (ir = this.itemRenderer.get(item.getClass())) != null && (w = ir.getRenderWidget(item)) != null) {
            if (w.getParent() != this.renderer) {
                w.setVisible(false);
                this.renderer.add(w);
            }
            return w;
        }
        return null;
    }

    protected void startTimer() {
        if (this.timer != null && !this.timer.isRunning()) {
            this.timer.start();
        }
    }

    protected void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    protected void onTimer() {
        int amount;
        int newAmount = amount = this.scrollAmount;
        if (amount == 0 && !this.dragActive) {
            amount = -this.scrollOffset;
        }
        if (amount != 0) {
            int absAmount = Math.abs(amount);
            int speed = absAmount * 30 / 200;
            int dir = Integer.signum(amount) * Math.min(absAmount, Math.max(3, Math.min(100, speed)));
            if (newAmount != 0) {
                newAmount -= dir;
            }
            this.scrollAmount = newAmount;
            this.scrollInt(dir);
        }
    }

    @Override
    protected void layout() {
        this.layoutChildFullInnerArea(this.renderer);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeWheel(themeInfo);
    }

    protected void applyThemeWheel(ThemeInfo themeInfo) {
        this.itemHeight = themeInfo.getParameter("itemHeight", 10);
        this.numVisibleItems = themeInfo.getParameter("visibleItems", 5);
        this.selectedOverlay = themeInfo.getImage("selectedOverlay");
        this.invalidateLayout();
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.addListener();
        this.addSelectedListener();
        this.timer = gui.createTimer();
        this.timer.setCallback(this.timerCB);
        this.timer.setDelay(30);
        this.timer.setContinuous(true);
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        this.timer.stop();
        this.timer = null;
        this.removeListener();
        this.removeSelectedListener();
        super.beforeRemoveFromGUI(gui);
    }

    @Override
    public void insertChild(Widget child, int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllChildren() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Widget removeChild(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void addListener() {
        if (this.model != null) {
            this.model.addChangeListener(this.listener);
        }
    }

    private void removeListener() {
        if (this.model != null) {
            this.model.removeChangeListener(this.listener);
        }
    }

    private void addSelectedListener() {
        if (this.selectedModel != null) {
            this.selectedModel.addCallback(this.listener);
            this.syncSelected();
        }
    }

    private void removeSelectedListener() {
        if (this.selectedModel != null) {
            this.selectedModel.removeCallback(this.listener);
        }
    }

    void syncSelected() {
        this.setSelected(this.selectedModel.getValue());
    }

    void entriesDeleted(int first, int last) {
        if (this.selected > first) {
            if (this.selected > last) {
                this.setSelected(this.selected - (last - first + 1));
            } else {
                this.setSelected(first);
            }
        }
        this.invalidateLayout();
    }

    void entriesInserted(int first, int last) {
        if (this.selected >= first) {
            this.setSelected(this.selected + (last - first + 1));
        }
        this.invalidateLayout();
    }

    public static class StringItemRenderer
    extends Label
    implements ItemRenderer {
        public StringItemRenderer() {
            this.setCache(false);
        }

        public Widget getRenderWidget(Object data) {
            this.setText(String.valueOf(data));
            return this;
        }

        protected void sizeChanged() {
        }
    }

    class R
    extends Widget {
        public R() {
            this.setTheme("");
            this.setClip(true);
        }

        protected void paintWidget(GUI gui) {
            if (WheelWidget.this.model == null) {
                return;
            }
            int width = this.getInnerWidth();
            int x = this.getInnerX();
            int y = this.getInnerY();
            int numItems = WheelWidget.this.model.getNumEntries();
            int numDraw = WheelWidget.this.numVisibleItems;
            int startIdx = WheelWidget.this.selected - WheelWidget.this.numVisibleItems / 2;
            if ((numDraw & 1) == 0) {
                y -= WheelWidget.this.itemHeight / 2;
                ++numDraw;
            }
            if (WheelWidget.this.scrollOffset > 0) {
                y -= WheelWidget.this.scrollOffset;
                ++numDraw;
            }
            if (WheelWidget.this.scrollOffset < 0) {
                y -= WheelWidget.this.itemHeight + WheelWidget.this.scrollOffset;
                ++numDraw;
                --startIdx;
            }
            block0: for (int i = 0; i < numDraw; ++i) {
                int idx;
                for (idx = startIdx + i; idx < 0; idx += numItems) {
                    if (!WheelWidget.this.cyclic) continue block0;
                }
                while (idx >= numItems) {
                    if (!WheelWidget.this.cyclic) continue block0;
                    idx -= numItems;
                }
                Widget w = WheelWidget.this.getItemRenderer(idx);
                if (w == null) continue;
                w.setSize(width, WheelWidget.this.itemHeight);
                w.setPosition(x, y + i * WheelWidget.this.itemHeight);
                w.validateLayout();
                this.paintChild(gui, w);
            }
        }

        public void invalidateLayout() {
        }

        protected void sizeChanged() {
        }
    }

    class L
    implements ListModel.ChangeListener,
    Runnable {
        L() {
        }

        public void allChanged() {
            WheelWidget.this.invalidateLayout();
        }

        public void entriesChanged(int first, int last) {
            WheelWidget.this.invalidateLayout();
        }

        public void entriesDeleted(int first, int last) {
            WheelWidget.this.entriesDeleted(first, last);
        }

        public void entriesInserted(int first, int last) {
            WheelWidget.this.entriesInserted(first, last);
        }

        public void run() {
            WheelWidget.this.syncSelected();
        }
    }

    public static interface ItemRenderer {
        public Widget getRenderWidget(Object var1);
    }
}

