/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.SortOrder;
import de.matthiasmann.twl.model.TableColumnHeaderModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.SizeSequence;
import de.matthiasmann.twl.utils.SparseGrid;
import de.matthiasmann.twl.utils.TypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableBase
extends Widget
implements ScrollPane.Scrollable,
ScrollPane.AutoScrollable,
ScrollPane.CustomPageSize {
    public static final AnimationState.StateKey STATE_FIRST_COLUMNHEADER = AnimationState.StateKey.get("firstColumnHeader");
    public static final AnimationState.StateKey STATE_LAST_COLUMNHEADER = AnimationState.StateKey.get("lastColumnHeader");
    public static final AnimationState.StateKey STATE_ROW_SELECTED = AnimationState.StateKey.get("rowSelected");
    public static final AnimationState.StateKey STATE_ROW_HOVER = AnimationState.StateKey.get("rowHover");
    public static final AnimationState.StateKey STATE_ROW_DROPTARGET = AnimationState.StateKey.get("rowDropTarget");
    public static final AnimationState.StateKey STATE_ROW_ODD = AnimationState.StateKey.get("rowOdd");
    public static final AnimationState.StateKey STATE_LEAD_ROW = AnimationState.StateKey.get("leadRow");
    public static final AnimationState.StateKey STATE_SELECTED = AnimationState.StateKey.get("selected");
    public static final AnimationState.StateKey STATE_SORT_ASCENDING = AnimationState.StateKey.get("sortAscending");
    public static final AnimationState.StateKey STATE_SORT_DESCENDING = AnimationState.StateKey.get("sortDescending");
    private final StringCellRenderer stringCellRenderer;
    private final RemoveCellWidgets removeCellWidgetsFunction;
    private final InsertCellWidgets insertCellWidgetsFunction;
    private final CellWidgetContainer cellWidgetContainer;
    protected final TypeMapping<CellRenderer> cellRenderers;
    protected final SparseGrid widgetGrid;
    protected final ColumnSizeSequence columnModel;
    protected TableColumnHeaderModel columnHeaderModel;
    protected SizeSequence rowModel;
    protected boolean hasCellWidgetCreators;
    protected ColumnHeader[] columnHeaders;
    protected CellRenderer[] columnDefaultCellRenderer;
    protected TableSelectionManager selectionManager;
    protected KeyboardSearchHandler keyboardSearchHandler;
    protected DragListener dragListener;
    protected Callback[] callbacks;
    protected Image imageColumnDivider;
    protected Image imageRowBackground;
    protected Image imageRowOverlay;
    protected Image imageRowDropMarker;
    protected ThemeInfo tableBaseThemeInfo;
    protected int columnHeaderHeight;
    protected int columnDividerDragableDistance;
    protected MouseCursor columnResizeCursor;
    protected MouseCursor normalCursor;
    protected MouseCursor dragNotPossibleCursor;
    protected boolean ensureColumnHeaderMinWidth;
    protected int numRows;
    protected int numColumns;
    protected int rowHeight = 32;
    protected int defaultColumnWidth = 256;
    protected boolean autoSizeAllRows;
    protected boolean updateAllCellWidgets;
    protected boolean updateAllColumnWidth;
    protected int scrollPosX;
    protected int scrollPosY;
    protected int firstVisibleRow;
    protected int firstVisibleColumn;
    protected int lastVisibleRow;
    protected int lastVisibleColumn;
    protected boolean firstRowPartialVisible;
    protected boolean lastRowPartialVisible;
    protected int dropMarkerRow = -1;
    protected boolean dropMarkerBeforeRow;
    protected static final int LAST_MOUSE_Y_OUTSIDE = Integer.MIN_VALUE;
    protected int lastMouseY = Integer.MIN_VALUE;
    protected int lastMouseRow = -1;
    protected int lastMouseColumn = -1;
    protected static final int DRAG_INACTIVE = 0;
    protected static final int DRAG_COLUMN_HEADER = 1;
    protected static final int DRAG_USER = 2;
    protected static final int DRAG_IGNORE = 3;
    protected int dragActive;
    protected int dragColumn;
    protected int dragStartX;
    protected int dragStartColWidth;
    protected int dragStartSumWidth;
    protected MouseCursor dragCursor;

    protected TableBase() {
        this.cellRenderers = new TypeMapping();
        this.stringCellRenderer = new StringCellRenderer();
        this.widgetGrid = new SparseGrid(32);
        this.removeCellWidgetsFunction = new RemoveCellWidgets();
        this.insertCellWidgetsFunction = new InsertCellWidgets();
        this.columnModel = new ColumnSizeSequence();
        this.columnDefaultCellRenderer = new CellRenderer[8];
        this.cellWidgetContainer = new CellWidgetContainer();
        super.insertChild(this.cellWidgetContainer, 0);
        this.setCanAcceptKeyboardFocus(true);
    }

    public TableSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setSelectionManager(TableSelectionManager selectionManager) {
        if (this.selectionManager != selectionManager) {
            if (this.selectionManager != null) {
                this.selectionManager.setAssociatedTable(null);
            }
            this.selectionManager = selectionManager;
            if (this.selectionManager != null) {
                this.selectionManager.setAssociatedTable(this);
            }
        }
    }

    public void setDefaultSelectionManager() {
        this.setSelectionManager(new TableRowSelectionManager());
    }

    public KeyboardSearchHandler getKeyboardSearchHandler() {
        return this.keyboardSearchHandler;
    }

    public void setKeyboardSearchHandler(KeyboardSearchHandler keyboardSearchHandler) {
        this.keyboardSearchHandler = keyboardSearchHandler;
    }

    public DragListener getDragListener() {
        return this.dragListener;
    }

    public void setDragListener(DragListener dragListener) {
        this.cancelDragging();
        this.dragListener = dragListener;
    }

    public boolean isDropMarkerBeforeRow() {
        return this.dropMarkerBeforeRow;
    }

    public int getDropMarkerRow() {
        return this.dropMarkerRow;
    }

    public void setDropMarker(int row, boolean beforeRow) {
        if (row < 0 || row > this.numRows) {
            throw new IllegalArgumentException("row");
        }
        if (row == this.numRows && !beforeRow) {
            throw new IllegalArgumentException("row");
        }
        this.dropMarkerRow = row;
        this.dropMarkerBeforeRow = beforeRow;
    }

    public boolean setDropMarker(Event evt) {
        int mouseY = evt.getMouseY();
        if (this.isMouseInside(evt) && !this.isMouseInColumnHeader(mouseY)) {
            int row = this.getRowFromPosition(mouseY -= this.getOffsetY());
            if (row >= 0 && row < this.numRows) {
                int rowEnd;
                int margin;
                int rowStart = this.getRowStartPosition(row);
                if (mouseY - rowStart < (margin = ((rowEnd = this.getRowEndPosition(row)) - rowStart + 2) / 4)) {
                    this.setDropMarker(row, true);
                } else if (rowEnd - mouseY < margin) {
                    this.setDropMarker(row + 1, true);
                } else {
                    this.setDropMarker(row, false);
                }
                return true;
            }
            if (row == this.numRows) {
                this.setDropMarker(row, true);
                return true;
            }
        }
        return false;
    }

    public void clearDropMarker() {
        this.dropMarkerRow = -1;
    }

    public void addCallback(Callback callback) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, callback);
    }

    public boolean isVariableRowHeight() {
        return this.rowModel != null;
    }

    public void setVaribleRowHeight(boolean varibleRowHeight) {
        if (varibleRowHeight && this.rowModel == null) {
            this.rowModel = new RowSizeSequence(this.numRows);
            this.autoSizeAllRows = true;
            this.invalidateLayout();
        } else if (!varibleRowHeight) {
            this.rowModel = null;
        }
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getRowFromPosition(int y) {
        if (y >= 0) {
            if (this.rowModel != null) {
                return this.rowModel.getIndex(y);
            }
            return Math.min(this.numRows - 1, y / this.rowHeight);
        }
        return -1;
    }

    public int getRowStartPosition(int row) {
        this.checkRowIndex(row);
        if (this.rowModel != null) {
            return this.rowModel.getPosition(row);
        }
        return row * this.rowHeight;
    }

    public int getRowHeight(int row) {
        this.checkRowIndex(row);
        if (this.rowModel != null) {
            return this.rowModel.getSize(row);
        }
        return this.rowHeight;
    }

    public int getRowEndPosition(int row) {
        this.checkRowIndex(row);
        if (this.rowModel != null) {
            return this.rowModel.getPosition(row + 1);
        }
        return (row + 1) * this.rowHeight;
    }

    public int getColumnFromPosition(int x) {
        if (x >= 0) {
            int column = this.columnModel.getIndex(x);
            return column;
        }
        return -1;
    }

    public int getColumnStartPosition(int column) {
        this.checkColumnIndex(column);
        return this.columnModel.getPosition(column);
    }

    public int getColumnWidth(int column) {
        this.checkColumnIndex(column);
        return this.columnModel.getSize(column);
    }

    public int getColumnEndPosition(int column) {
        this.checkColumnIndex(column);
        return this.columnModel.getPosition(column + 1);
    }

    public void setColumnWidth(int column, int width) {
        this.checkColumnIndex(column);
        this.columnHeaders[column].setColumnWidth(width);
        if (this.columnModel.update(column)) {
            this.invalidateLayout();
        }
    }

    public AnimationState getColumnHeaderAnimationState(int column) {
        this.checkColumnIndex(column);
        return this.columnHeaders[column].getAnimationState();
    }

    public void setColumnSortOrderAnimationState(int sortColumn, SortOrder sortOrder) {
        for (int column = 0; column < this.numColumns; ++column) {
            AnimationState animState = this.columnHeaders[column].getAnimationState();
            animState.setAnimationState(STATE_SORT_ASCENDING, column == sortColumn && sortOrder == SortOrder.ASCENDING);
            animState.setAnimationState(STATE_SORT_DESCENDING, column == sortColumn && sortOrder == SortOrder.DESCENDING);
        }
    }

    public void scrollToRow(int row) {
        ScrollPane scrollPane = ScrollPane.getContainingScrollPane(this);
        if (scrollPane != null && this.numRows > 0) {
            scrollPane.validateLayout();
            int rowStart = this.getRowStartPosition(row);
            int rowEnd = this.getRowEndPosition(row);
            int height = rowEnd - rowStart;
            scrollPane.scrollToAreaY(rowStart, height, height / 2);
        }
    }

    public int getNumVisibleRows() {
        int rows = this.lastVisibleRow - this.firstVisibleRow;
        if (!this.lastRowPartialVisible) {
            ++rows;
        }
        return rows;
    }

    @Override
    public int getMinHeight() {
        return Math.max(super.getMinHeight(), this.columnHeaderHeight);
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.getInnerWidth() == 0) {
            return this.columnModel.computePreferredWidth();
        }
        if (this.updateAllColumnWidth) {
            this.updateAllColumnWidth();
        }
        return this.numColumns > 0 ? this.getColumnEndPosition(this.numColumns - 1) : 0;
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.autoSizeAllRows) {
            this.autoSizeAllRows();
        }
        return this.columnHeaderHeight + 1 + (this.numRows > 0 ? this.getRowEndPosition(this.numRows - 1) : 0);
    }

    public void registerCellRenderer(Class<?> dataClass, CellRenderer cellRenderer) {
        if (dataClass == null) {
            throw new NullPointerException("dataClass");
        }
        this.cellRenderers.put(dataClass, cellRenderer);
        if (cellRenderer instanceof CellWidgetCreator) {
            this.hasCellWidgetCreators = true;
        }
        if (this.tableBaseThemeInfo != null) {
            this.applyCellRendererTheme(cellRenderer);
        }
    }

    @Override
    public void setScrollPosition(int scrollPosX, int scrollPosY) {
        if (this.scrollPosX != scrollPosX || this.scrollPosY != scrollPosY) {
            this.scrollPosX = scrollPosX;
            this.scrollPosY = scrollPosY;
            this.invalidateLayoutLocally();
        }
    }

    public void adjustScrollPosition(int row) {
        this.checkRowIndex(row);
        ScrollPane scrollPane = ScrollPane.getContainingScrollPane(this);
        int numVisibleRows = this.getNumVisibleRows();
        if (numVisibleRows >= 1 && scrollPane != null) {
            if (row < this.firstVisibleRow || row == this.firstVisibleRow && this.firstRowPartialVisible) {
                int pos = this.getRowStartPosition(row);
                scrollPane.setScrollPositionY(pos);
            } else if (row > this.lastVisibleRow || row == this.lastVisibleRow && this.lastRowPartialVisible) {
                int innerHeight = Math.max(0, this.getInnerHeight() - this.columnHeaderHeight);
                int pos = this.getRowEndPosition(row);
                pos = Math.max(0, pos - innerHeight);
                scrollPane.setScrollPositionY(pos);
            }
        }
    }

    @Override
    public int getAutoScrollDirection(Event evt, int autoScrollArea) {
        int areaY = this.getInnerY() + this.columnHeaderHeight;
        int areaHeight = this.getInnerHeight() - this.columnHeaderHeight;
        int mouseY = evt.getMouseY();
        if (mouseY >= areaY && mouseY < areaY + areaHeight && ((mouseY -= areaY) <= autoScrollArea || areaHeight - mouseY <= autoScrollArea)) {
            if (mouseY < areaHeight / 2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public int getPageSizeX(int availableWidth) {
        return availableWidth;
    }

    @Override
    public int getPageSizeY(int availableHeight) {
        return availableHeight - this.columnHeaderHeight;
    }

    public boolean isFixedWidthMode() {
        ScrollPane scrollPane = ScrollPane.getContainingScrollPane(this);
        return scrollPane == null || scrollPane.getFixed() == ScrollPane.Fixed.HORIZONTAL;
    }

    protected final void checkRowIndex(int row) {
        if (row < 0 || row >= this.numRows) {
            throw new IndexOutOfBoundsException("row");
        }
    }

    protected final void checkColumnIndex(int column) {
        if (column < 0 || column >= this.numColumns) {
            throw new IndexOutOfBoundsException("column");
        }
    }

    protected final void checkRowRange(int idx, int count) {
        if (idx < 0 || count < 0 || count > this.numRows || idx > this.numRows - count) {
            throw new IllegalArgumentException("row");
        }
    }

    protected final void checkColumnRange(int idx, int count) {
        if (idx < 0 || count < 0 || count > this.numColumns || idx > this.numColumns - count) {
            throw new IllegalArgumentException("column");
        }
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeTableBase(themeInfo);
        this.updateAll();
    }

    protected void applyThemeTableBase(ThemeInfo themeInfo) {
        this.tableBaseThemeInfo = themeInfo;
        this.imageColumnDivider = themeInfo.getImage("columnDivider");
        this.imageRowBackground = themeInfo.getImage("row.background");
        this.imageRowOverlay = themeInfo.getImage("row.overlay");
        this.imageRowDropMarker = themeInfo.getImage("row.dropmarker");
        this.rowHeight = themeInfo.getParameter("rowHeight", 32);
        this.defaultColumnWidth = themeInfo.getParameter("columnHeaderWidth", 256);
        this.columnHeaderHeight = themeInfo.getParameter("columnHeaderHeight", 10);
        this.columnDividerDragableDistance = themeInfo.getParameter("columnDividerDragableDistance", 3);
        this.ensureColumnHeaderMinWidth = themeInfo.getParameter("ensureColumnHeaderMinWidth", false);
        for (CellRenderer cellRenderer : this.cellRenderers.getUniqueValues()) {
            this.applyCellRendererTheme(cellRenderer);
        }
        this.applyCellRendererTheme(this.stringCellRenderer);
        this.updateAllColumnWidth = true;
    }

    @Override
    protected void applyThemeMouseCursor(ThemeInfo themeInfo) {
        this.columnResizeCursor = themeInfo.getMouseCursor("columnResizeCursor");
        this.normalCursor = themeInfo.getMouseCursor("mouseCursor");
        this.dragNotPossibleCursor = themeInfo.getMouseCursor("dragNotPossibleCursor");
    }

    protected void applyCellRendererTheme(CellRenderer cellRenderer) {
        String childThemeName = cellRenderer.getTheme();
        assert (!TableBase.isAbsoluteTheme(childThemeName));
        ThemeInfo childTheme = this.tableBaseThemeInfo.getChildTheme(childThemeName);
        if (childTheme != null) {
            cellRenderer.applyTheme(childTheme);
        }
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void childAdded(Widget child) {
    }

    @Override
    protected void childRemoved(Widget exChild) {
    }

    protected int getOffsetX() {
        return this.getInnerX() - this.scrollPosX;
    }

    protected int getOffsetY() {
        return this.getInnerY() - this.scrollPosY + this.columnHeaderHeight;
    }

    @Override
    protected void positionChanged() {
        super.positionChanged();
        if (this.keyboardSearchHandler != null) {
            this.keyboardSearchHandler.updateInfoWindowPosition();
        }
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        if (this.isFixedWidthMode()) {
            this.updateAllColumnWidth = true;
        }
        if (this.keyboardSearchHandler != null) {
            this.keyboardSearchHandler.updateInfoWindowPosition();
        }
    }

    @Override
    protected Object getTooltipContentAt(int mouseX, int mouseY) {
        Object tooltip;
        if (this.lastMouseRow >= 0 && this.lastMouseRow < this.getNumRows() && this.lastMouseColumn >= 0 && this.lastMouseColumn < this.getNumColumns() && (tooltip = this.getTooltipContentFromRow(this.lastMouseRow, this.lastMouseColumn)) != null) {
            return tooltip;
        }
        return super.getTooltipContentAt(mouseX, mouseY);
    }

    @Override
    protected void layout() {
        int innerWidth = this.getInnerWidth();
        int innerHeight = Math.max(0, this.getInnerHeight() - this.columnHeaderHeight);
        this.cellWidgetContainer.setPosition(this.getInnerX(), this.getInnerY() + this.columnHeaderHeight);
        this.cellWidgetContainer.setSize(innerWidth, innerHeight);
        if (this.updateAllColumnWidth) {
            this.updateAllColumnWidth();
        }
        if (this.autoSizeAllRows) {
            this.autoSizeAllRows();
        }
        if (this.updateAllCellWidgets) {
            this.updateAllCellWidgets();
        }
        int scrollEndX = this.scrollPosX + innerWidth;
        int scrollEndY = this.scrollPosY + innerHeight;
        int startRow = Math.min(this.numRows - 1, Math.max(0, this.getRowFromPosition(this.scrollPosY)));
        int startColumn = Math.min(this.numColumns - 1, Math.max(0, this.getColumnFromPosition(this.scrollPosX)));
        int endRow = Math.min(this.numRows - 1, Math.max(startRow, this.getRowFromPosition(scrollEndY)));
        int endColumn = Math.min(this.numColumns - 1, Math.max(startColumn, this.getColumnFromPosition(scrollEndX)));
        if (this.numRows > 0) {
            this.firstRowPartialVisible = this.getRowStartPosition(startRow) < this.scrollPosY;
            this.lastRowPartialVisible = this.getRowEndPosition(endRow) > scrollEndY;
        } else {
            this.firstRowPartialVisible = false;
            this.lastRowPartialVisible = false;
        }
        if (!this.widgetGrid.isEmpty()) {
            if (startRow > this.firstVisibleRow) {
                this.widgetGrid.iterate(this.firstVisibleRow, 0, startRow - 1, this.numColumns, this.removeCellWidgetsFunction);
            }
            if (endRow < this.lastVisibleRow) {
                this.widgetGrid.iterate(endRow + 1, 0, this.lastVisibleRow, this.numColumns, this.removeCellWidgetsFunction);
            }
            this.widgetGrid.iterate(startRow, 0, endRow, this.numColumns, this.insertCellWidgetsFunction);
        }
        this.firstVisibleRow = startRow;
        this.firstVisibleColumn = startColumn;
        this.lastVisibleRow = endRow;
        this.lastVisibleColumn = endColumn;
        if (this.numColumns > 0) {
            int offsetX = this.getOffsetX();
            int colStartPos = this.getColumnStartPosition(0);
            for (int i = 0; i < this.numColumns; ++i) {
                int colEndPos = this.getColumnEndPosition(i);
                ColumnHeader w = this.columnHeaders[i];
                if (w != null) {
                    assert (w.getParent() == this);
                    w.setPosition(offsetX + colStartPos + this.columnDividerDragableDistance, this.getInnerY());
                    w.setSize(Math.max(0, colEndPos - colStartPos - 2 * this.columnDividerDragableDistance), this.columnHeaderHeight);
                    ((Widget)w).setVisible(this.columnHeaderHeight > 0);
                    AnimationState animationState = w.getAnimationState();
                    animationState.setAnimationState(STATE_FIRST_COLUMNHEADER, i == 0);
                    animationState.setAnimationState(STATE_LAST_COLUMNHEADER, i == this.numColumns - 1);
                }
                colStartPos = colEndPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintWidget(GUI gui) {
        if (this.firstVisibleRow < 0 || this.firstVisibleRow >= this.numRows) {
            return;
        }
        int innerX = this.getInnerX();
        int innerY = this.getInnerY() + this.columnHeaderHeight;
        int innerWidth = this.getInnerWidth();
        int innerHeight = this.getInnerHeight() - this.columnHeaderHeight;
        int offsetX = this.getOffsetX();
        int offsetY = this.getOffsetY();
        Renderer renderer = gui.getRenderer();
        renderer.clipEnter(innerX, innerY, innerWidth, innerHeight);
        try {
            boolean isCellSelection;
            int leadColumn;
            int leadRow;
            AnimationState animState = this.getAnimationState();
            if (this.selectionManager != null) {
                leadRow = this.selectionManager.getLeadRow();
                leadColumn = this.selectionManager.getLeadColumn();
                isCellSelection = this.selectionManager.getSelectionGranularity() == TableSelectionManager.SelectionGranularity.CELLS;
            } else {
                leadRow = -1;
                leadColumn = -1;
                isCellSelection = false;
            }
            if (this.imageRowBackground != null) {
                this.paintRowImage(this.imageRowBackground, leadRow);
            }
            if (this.imageColumnDivider != null) {
                animState.setAnimationState(STATE_ROW_SELECTED, false);
                for (int col = this.firstVisibleColumn; col <= this.lastVisibleColumn; ++col) {
                    int colEndPos = this.getColumnEndPosition(col);
                    int curX = offsetX + colEndPos;
                    this.imageColumnDivider.draw(animState, curX, innerY, 1, innerHeight);
                }
            }
            int rowStartPos = this.getRowStartPosition(this.firstVisibleRow);
            for (int row = this.firstVisibleRow; row <= this.lastVisibleRow; ++row) {
                int colSpan;
                int rowEndPos = this.getRowEndPosition(row);
                int curRowHeight = rowEndPos - rowStartPos;
                int curY = offsetY + rowStartPos;
                TreeTableNode rowNode = this.getNodeFromRow(row);
                boolean isRowSelected = !isCellSelection && this.isRowSelected(row);
                int colStartPos = this.getColumnStartPosition(this.firstVisibleColumn);
                for (int col = this.firstVisibleColumn; col <= this.lastVisibleColumn; col += Math.max(1, colSpan)) {
                    int colEndPos = this.getColumnEndPosition(col);
                    CellRenderer cellRenderer = this.getCellRenderer(row, col, rowNode);
                    boolean isCellSelected = isRowSelected || this.isCellSelected(row, col);
                    int curX = offsetX + colStartPos;
                    colSpan = 1;
                    if (cellRenderer != null) {
                        Widget cellRendererWidget;
                        colSpan = cellRenderer.getColumnSpan();
                        if (colSpan > 1) {
                            colEndPos = this.getColumnEndPosition(Math.max(this.numColumns - 1, col + colSpan - 1));
                        }
                        if ((cellRendererWidget = cellRenderer.getCellRenderWidget(curX, curY, colEndPos - colStartPos, curRowHeight, isCellSelected)) != null) {
                            if (cellRendererWidget.getParent() != this) {
                                this.insertCellRenderer(cellRendererWidget);
                            }
                            this.paintChild(gui, cellRendererWidget);
                        }
                    }
                    colStartPos = colEndPos;
                }
                rowStartPos = rowEndPos;
            }
            if (this.imageRowOverlay != null) {
                this.paintRowImage(this.imageRowOverlay, leadRow);
            }
            if (this.dropMarkerRow >= 0 && this.dropMarkerBeforeRow && this.imageRowDropMarker != null) {
                int y = this.rowModel != null ? this.rowModel.getPosition(this.dropMarkerRow) : this.dropMarkerRow * this.rowHeight;
                this.imageRowDropMarker.draw(animState, this.getOffsetX(), this.getOffsetY() + y, this.columnModel.getEndPosition(), 1);
            }
        }
        finally {
            renderer.clipLeave();
        }
    }

    private void paintRowImage(Image img, int leadRow) {
        AnimationState animState = this.getAnimationState();
        int x = this.getOffsetX();
        int width = this.columnModel.getEndPosition();
        int offsetY = this.getOffsetY();
        int rowStartPos = this.getRowStartPosition(this.firstVisibleRow);
        for (int row = this.firstVisibleRow; row <= this.lastVisibleRow; ++row) {
            int rowEndPos = this.getRowEndPosition(row);
            int curRowHeight = rowEndPos - rowStartPos;
            int curY = offsetY + rowStartPos;
            animState.setAnimationState(STATE_ROW_SELECTED, this.isRowSelected(row));
            animState.setAnimationState(STATE_ROW_HOVER, this.dragActive == 0 && this.lastMouseY >= curY && this.lastMouseY < curY + curRowHeight);
            animState.setAnimationState(STATE_LEAD_ROW, row == leadRow);
            animState.setAnimationState(STATE_ROW_DROPTARGET, !this.dropMarkerBeforeRow && row == this.dropMarkerRow);
            animState.setAnimationState(STATE_ROW_ODD, (row & 1) == 1);
            img.draw(animState, x, curY, width, curRowHeight);
            rowStartPos = rowEndPos;
        }
    }

    protected void insertCellRenderer(Widget widget) {
        int posX = widget.getX();
        int posY = widget.getY();
        widget.setVisible(false);
        super.insertChild(widget, super.getNumChildren());
        widget.setPosition(posX, posY);
    }

    protected abstract TreeTableNode getNodeFromRow(int var1);

    protected abstract Object getCellData(int var1, int var2, TreeTableNode var3);

    protected abstract Object getTooltipContentFromRow(int var1, int var2);

    protected boolean isRowSelected(int row) {
        if (this.selectionManager != null) {
            return this.selectionManager.isRowSelected(row);
        }
        return false;
    }

    protected boolean isCellSelected(int row, int column) {
        if (this.selectionManager != null) {
            return this.selectionManager.isCellSelected(row, column);
        }
        return false;
    }

    public void setColumnDefaultCellRenderer(int column, CellRenderer cellRenderer) {
        if (column >= this.columnDefaultCellRenderer.length) {
            CellRenderer[] tmp = new CellRenderer[Math.max(column + 1, this.numColumns)];
            System.arraycopy(this.columnDefaultCellRenderer, 0, tmp, 0, this.columnDefaultCellRenderer.length);
            this.columnDefaultCellRenderer = tmp;
        }
        this.columnDefaultCellRenderer[column] = cellRenderer;
    }

    public CellRenderer getColumnDefaultCellRenderer(int column) {
        if (column < this.columnDefaultCellRenderer.length) {
            return this.columnDefaultCellRenderer[column];
        }
        return null;
    }

    protected CellRenderer getCellRendererNoDefault(Object data) {
        Class<?> dataClass = data.getClass();
        return this.cellRenderers.get(dataClass);
    }

    protected CellRenderer getDefaultCellRenderer(int col) {
        CellRenderer cellRenderer = this.getColumnDefaultCellRenderer(col);
        if (cellRenderer == null) {
            cellRenderer = this.stringCellRenderer;
        }
        return cellRenderer;
    }

    protected CellRenderer getCellRenderer(Object data, int col) {
        CellRenderer cellRenderer = this.getCellRendererNoDefault(data);
        if (cellRenderer == null) {
            cellRenderer = this.getDefaultCellRenderer(col);
        }
        return cellRenderer;
    }

    protected CellRenderer getCellRenderer(int row, int col, TreeTableNode node) {
        Object data = this.getCellData(row, col, node);
        if (data != null) {
            CellRenderer cellRenderer = this.getCellRenderer(data, col);
            cellRenderer.setCellData(row, col, data);
            return cellRenderer;
        }
        return null;
    }

    protected int computeRowHeight(int row) {
        TreeTableNode rowNode = this.getNodeFromRow(row);
        int height = 0;
        for (int column = 0; column < this.numColumns; ++column) {
            CellRenderer cellRenderer = this.getCellRenderer(row, column, rowNode);
            if (cellRenderer == null) continue;
            height = Math.max(height, cellRenderer.getPreferredHeight());
            column += Math.max(cellRenderer.getColumnSpan() - 1, 0);
        }
        return height;
    }

    protected int clampColumnWidth(int width) {
        return Math.max(2 * this.columnDividerDragableDistance + 1, width);
    }

    protected int computePreferredColumnWidth(int index) {
        return this.clampColumnWidth(this.columnHeaders[index].getPreferredWidth());
    }

    protected boolean autoSizeRow(int row) {
        int height = this.computeRowHeight(row);
        return this.rowModel.setSize(row, height);
    }

    protected void autoSizeAllRows() {
        if (this.rowModel != null) {
            this.rowModel.initializeAll(this.numRows);
        }
        this.autoSizeAllRows = false;
    }

    protected void removeCellWidget(Widget widget) {
        int idx = this.cellWidgetContainer.getChildIndex(widget);
        if (idx >= 0) {
            this.cellWidgetContainer.removeChild(idx);
        }
    }

    void insertCellWidget(int row, int column, WidgetEntry widgetEntry) {
        CellWidgetCreator cwc = (CellWidgetCreator)this.getCellRenderer(row, column, null);
        Widget widget = widgetEntry.widget;
        if (widget != null) {
            if (widget.getParent() != this.cellWidgetContainer) {
                this.cellWidgetContainer.insertChild(widget, this.cellWidgetContainer.getNumChildren());
            }
            int x = this.getColumnStartPosition(column);
            int w = this.getColumnEndPosition(column) - x;
            int y = this.getRowStartPosition(row);
            int h = this.getRowEndPosition(row) - y;
            cwc.positionWidget(widget, x + this.getOffsetX(), y + this.getOffsetY(), w, h);
        }
    }

    protected void updateCellWidget(int row, int column) {
        WidgetEntry we = (WidgetEntry)this.widgetGrid.get(row, column);
        Widget oldWidget = we != null ? we.widget : null;
        Widget newWidget = null;
        TreeTableNode rowNode = this.getNodeFromRow(row);
        CellRenderer cellRenderer = this.getCellRenderer(row, column, rowNode);
        if (cellRenderer instanceof CellWidgetCreator) {
            CellWidgetCreator cellWidgetCreator = (CellWidgetCreator)cellRenderer;
            if (we != null && we.creator != cellWidgetCreator) {
                this.removeCellWidget(oldWidget);
                oldWidget = null;
            }
            if ((newWidget = cellWidgetCreator.updateWidget(oldWidget)) != null) {
                if (we == null) {
                    we = new WidgetEntry();
                    this.widgetGrid.set(row, column, we);
                }
                we.widget = newWidget;
                we.creator = cellWidgetCreator;
            }
        }
        if (newWidget == null && we != null) {
            this.widgetGrid.remove(row, column);
        }
        if (oldWidget != null && newWidget != oldWidget) {
            this.removeCellWidget(oldWidget);
        }
    }

    protected void updateAllCellWidgets() {
        if (!this.widgetGrid.isEmpty() || this.hasCellWidgetCreators) {
            for (int row = 0; row < this.numRows; ++row) {
                for (int col = 0; col < this.numColumns; ++col) {
                    this.updateCellWidget(row, col);
                }
            }
        }
        this.updateAllCellWidgets = false;
    }

    protected void removeAllCellWidgets() {
        this.cellWidgetContainer.removeAllChildren();
    }

    protected DialogLayout.Gap getColumnMPM(int column) {
        if (this.tableBaseThemeInfo != null) {
            ParameterMap columnWidthMap = this.tableBaseThemeInfo.getParameterMap("columnWidths");
            Object obj = columnWidthMap.getParameterValue(Integer.toString(column), false);
            if (obj instanceof DialogLayout.Gap) {
                return (DialogLayout.Gap)obj;
            }
            if (obj instanceof Integer) {
                return new DialogLayout.Gap((Integer)obj);
            }
        }
        return null;
    }

    protected ColumnHeader createColumnHeader(int column) {
        ColumnHeader btn = new ColumnHeader();
        btn.setTheme("columnHeader");
        btn.setCanAcceptKeyboardFocus(false);
        super.insertChild(btn, super.getNumChildren());
        return btn;
    }

    protected void updateColumnHeader(int column) {
        ColumnHeader columnHeader = this.columnHeaders[column];
        columnHeader.setText(this.columnHeaderModel.getColumnHeaderText(column));
        AnimationState.StateKey[] states = this.columnHeaderModel.getColumnHeaderStates();
        if (states.length > 0) {
            AnimationState animationState = columnHeader.getAnimationState();
            for (int i = 0; i < states.length; ++i) {
                animationState.setAnimationState(states[i], this.columnHeaderModel.getColumnHeaderState(column, i));
            }
        }
    }

    protected void updateColumnHeaderNumbers() {
        for (int i = 0; i < this.columnHeaders.length; ++i) {
            this.columnHeaders[i].column = i;
        }
    }

    private void removeColumnHeaders(int column, int count) throws IndexOutOfBoundsException {
        for (int i = 0; i < count; ++i) {
            int idx = super.getChildIndex(this.columnHeaders[column + i]);
            if (idx < 0) continue;
            super.removeChild(idx);
        }
    }

    protected boolean isMouseInColumnHeader(int y) {
        return (y -= this.getInnerY()) >= 0 && y < this.columnHeaderHeight;
    }

    protected int getColumnSeparatorUnderMouse(int x) {
        int col;
        int dist;
        x -= this.getOffsetX();
        if ((dist = (x += this.columnDividerDragableDistance) - this.columnModel.getPosition(col = this.columnModel.getIndex(x))) < 2 * this.columnDividerDragableDistance) {
            return col - 1;
        }
        return -1;
    }

    protected int getRowUnderMouse(int y) {
        int row = this.getRowFromPosition(y -= this.getOffsetY());
        return row;
    }

    protected int getColumnUnderMouse(int x) {
        int col = this.columnModel.getIndex(x -= this.getOffsetX());
        return col;
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (this.dragActive != 0) {
            return this.handleDragEvent(evt);
        }
        if (evt.isKeyEvent() && this.keyboardSearchHandler != null && this.keyboardSearchHandler.isActive() && this.keyboardSearchHandler.handleKeyEvent(evt)) {
            return true;
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        if (evt.isMouseEvent()) {
            return this.handleMouseEvent(evt);
        }
        return evt.isKeyEvent() && this.keyboardSearchHandler != null && this.keyboardSearchHandler.handleKeyEvent(evt);
    }

    @Override
    protected boolean handleKeyStrokeAction(String action, Event event) {
        if (!super.handleKeyStrokeAction(action, event)) {
            if (this.selectionManager == null) {
                return false;
            }
            if (!this.selectionManager.handleKeyStrokeAction(action, event)) {
                return false;
            }
        }
        this.requestKeyboardFocus(null);
        return true;
    }

    protected void cancelDragging() {
        if (this.dragActive == 2) {
            if (this.dragListener != null) {
                this.dragListener.dragCanceled();
            }
            this.dragActive = 3;
        }
    }

    protected boolean handleDragEvent(Event evt) {
        if (evt.isMouseEvent()) {
            return this.handleMouseEvent(evt);
        }
        if (evt.isKeyPressedEvent() && evt.getKeyCode() == 1) {
            switch (this.dragActive) {
                case 2: {
                    this.cancelDragging();
                    break;
                }
                case 1: {
                    this.columnHeaderDragged(this.dragStartColWidth);
                    this.dragActive = 3;
                }
            }
            this.dragCursor = null;
        }
        return true;
    }

    void mouseLeftTableArea() {
        this.lastMouseY = Integer.MIN_VALUE;
        this.lastMouseRow = -1;
        this.lastMouseColumn = -1;
    }

    @Override
    Widget routeMouseEvent(Event evt) {
        if (evt.getType() == Event.Type.MOUSE_EXITED) {
            this.mouseLeftTableArea();
        } else {
            this.lastMouseY = evt.getMouseY();
        }
        if (this.dragActive == 0) {
            boolean inHeader = this.isMouseInColumnHeader(evt.getMouseY());
            if (inHeader) {
                if (this.lastMouseRow != -1 || this.lastMouseColumn != -1) {
                    this.lastMouseRow = -1;
                    this.lastMouseColumn = -1;
                    this.resetTooltip();
                }
            } else {
                int row = this.getRowUnderMouse(evt.getMouseY());
                int column = this.getColumnUnderMouse(evt.getMouseX());
                if (this.lastMouseRow != row || this.lastMouseColumn != column) {
                    this.lastMouseRow = row;
                    this.lastMouseColumn = column;
                    this.resetTooltip();
                }
            }
        }
        return super.routeMouseEvent(evt);
    }

    protected boolean handleMouseEvent(Event evt) {
        Event.Type evtType = evt.getType();
        if (this.dragActive != 0) {
            switch (this.dragActive) {
                case 1: {
                    int innerWidth = this.getInnerWidth();
                    if (this.dragColumn < 0 || innerWidth <= 0) break;
                    int newWidth = this.clampColumnWidth(evt.getMouseX() - this.dragStartX);
                    this.columnHeaderDragged(newWidth);
                    break;
                }
                case 2: {
                    this.dragCursor = this.dragListener.dragged(evt);
                    if (!evt.isMouseDragEnd()) break;
                    this.dragListener.dragStopped(evt);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (evt.isMouseDragEnd()) {
                this.dragActive = 0;
                this.dragCursor = null;
            }
            return true;
        }
        boolean inHeader = this.isMouseInColumnHeader(evt.getMouseY());
        if (inHeader) {
            int column = this.getColumnSeparatorUnderMouse(evt.getMouseX());
            boolean fixedWidthMode = this.isFixedWidthMode();
            if (!(column < 0 || column >= this.getNumColumns() - 1 && fixedWidthMode)) {
                if (evtType == Event.Type.MOUSE_BTNDOWN) {
                    this.dragStartColWidth = this.getColumnWidth(column);
                    this.dragColumn = column;
                    this.dragStartX = evt.getMouseX() - this.dragStartColWidth;
                    if (fixedWidthMode) {
                        for (int i = 0; i < this.numColumns; ++i) {
                            this.columnHeaders[i].setColumnWidth(this.getColumnWidth(i));
                        }
                        this.dragStartSumWidth = this.dragStartColWidth + this.getColumnWidth(column + 1);
                    }
                }
                if (evt.isMouseDragEvent()) {
                    this.dragActive = 1;
                }
                return true;
            }
        } else {
            int row = this.lastMouseRow;
            int column = this.lastMouseColumn;
            if (evt.isMouseDragEvent()) {
                if (this.dragListener != null && this.dragListener.dragStarted(row, row, evt)) {
                    this.dragCursor = this.dragListener.dragged(evt);
                    this.dragActive = 2;
                } else {
                    this.dragActive = 3;
                }
                return true;
            }
            if (this.selectionManager != null) {
                this.selectionManager.handleMouseEvent(row, column, evt);
            }
            if (evtType == Event.Type.MOUSE_CLICKED && evt.getMouseClickCount() == 2 && this.callbacks != null) {
                for (Callback cb : this.callbacks) {
                    cb.mouseDoubleClicked(row, column);
                }
            }
            if (evtType == Event.Type.MOUSE_BTNUP && evt.getMouseButton() == 1 && this.callbacks != null) {
                for (Callback cb : this.callbacks) {
                    cb.mouseRightClick(row, column, evt);
                }
            }
        }
        return evtType != Event.Type.MOUSE_WHEEL;
    }

    @Override
    public MouseCursor getMouseCursor(Event evt) {
        switch (this.dragActive) {
            case 1: {
                return this.columnResizeCursor;
            }
            case 2: {
                return this.dragCursor;
            }
            case 3: {
                return this.dragNotPossibleCursor;
            }
        }
        boolean inHeader = this.isMouseInColumnHeader(evt.getMouseY());
        if (inHeader) {
            int column = this.getColumnSeparatorUnderMouse(evt.getMouseX());
            boolean fixedWidthMode = this.isFixedWidthMode();
            if (!(column < 0 || column >= this.getNumColumns() - 1 && fixedWidthMode)) {
                return this.columnResizeCursor;
            }
        }
        return this.normalCursor;
    }

    private void columnHeaderDragged(int newWidth) {
        if (this.isFixedWidthMode()) {
            assert (this.dragColumn + 1 < this.numColumns);
            newWidth = Math.min(newWidth, this.dragStartSumWidth - 2 * this.columnDividerDragableDistance);
            this.columnHeaders[this.dragColumn].setColumnWidth(newWidth);
            this.columnHeaders[this.dragColumn + 1].setColumnWidth(this.dragStartSumWidth - newWidth);
            this.updateAllColumnWidth = true;
            this.invalidateLayout();
        } else {
            this.setColumnWidth(this.dragColumn, newWidth);
        }
    }

    protected void columnHeaderClicked(int column) {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.columnHeaderClicked(column);
            }
        }
    }

    protected void updateAllColumnWidth() {
        if (this.getInnerWidth() > 0) {
            this.columnModel.initializeAll(this.numColumns);
            this.updateAllColumnWidth = false;
        }
    }

    protected void updateAll() {
        if (!this.widgetGrid.isEmpty()) {
            this.removeAllCellWidgets();
            this.widgetGrid.clear();
        }
        if (this.rowModel != null) {
            this.autoSizeAllRows = true;
        }
        this.updateAllCellWidgets = true;
        this.updateAllColumnWidth = true;
        this.invalidateLayout();
    }

    protected void modelAllChanged() {
        if (this.columnHeaders != null) {
            this.removeColumnHeaders(0, this.columnHeaders.length);
        }
        this.dropMarkerRow = -1;
        this.columnHeaders = new ColumnHeader[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.columnHeaders[i] = this.createColumnHeader(i);
            this.updateColumnHeader(i);
        }
        this.updateColumnHeaderNumbers();
        if (this.selectionManager != null) {
            this.selectionManager.modelChanged();
        }
        this.updateAll();
    }

    protected void modelRowChanged(int row) {
        if (this.rowModel != null && this.autoSizeRow(row)) {
            this.invalidateLayout();
        }
        for (int col = 0; col < this.numColumns; ++col) {
            this.updateCellWidget(row, col);
        }
        this.invalidateLayoutLocally();
    }

    protected void modelRowsChanged(int idx, int count) {
        this.checkRowRange(idx, count);
        boolean rowHeightChanged = false;
        for (int i = 0; i < count; ++i) {
            if (this.rowModel != null) {
                rowHeightChanged |= this.autoSizeRow(idx + i);
            }
            for (int col = 0; col < this.numColumns; ++col) {
                this.updateCellWidget(idx + i, col);
            }
        }
        this.invalidateLayoutLocally();
        if (rowHeightChanged) {
            this.invalidateLayout();
        }
    }

    protected void modelCellChanged(int row, int column) {
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        if (this.rowModel != null) {
            this.autoSizeRow(row);
        }
        this.updateCellWidget(row, column);
        this.invalidateLayout();
    }

    protected void modelRowsInserted(int row, int count) {
        ScrollPane sp;
        this.checkRowRange(row, count);
        if (this.rowModel != null) {
            this.rowModel.insert(row, count);
        }
        if (this.dropMarkerRow > row || this.dropMarkerRow == row && this.dropMarkerBeforeRow) {
            this.dropMarkerRow += count;
        }
        if (!this.widgetGrid.isEmpty() || this.hasCellWidgetCreators) {
            this.removeAllCellWidgets();
            this.widgetGrid.insertRows(row, count);
            for (int i = 0; i < count; ++i) {
                for (int col = 0; col < this.numColumns; ++col) {
                    this.updateCellWidget(row + i, col);
                }
            }
        }
        this.invalidateLayout();
        if (row < this.getRowFromPosition(this.scrollPosY) && (sp = ScrollPane.getContainingScrollPane(this)) != null) {
            int rowsStart = this.getRowStartPosition(row);
            int rowsEnd = this.getRowEndPosition(row + count - 1);
            sp.setScrollPositionY(this.scrollPosY + rowsEnd - rowsStart);
        }
        if (this.selectionManager != null) {
            this.selectionManager.rowsInserted(row, count);
        }
    }

    protected void modelRowsDeleted(int row, int count) {
        ScrollPane sp;
        if (row + count <= this.getRowFromPosition(this.scrollPosY) && (sp = ScrollPane.getContainingScrollPane(this)) != null) {
            int rowsStart = this.getRowStartPosition(row);
            int rowsEnd = this.getRowEndPosition(row + count - 1);
            sp.setScrollPositionY(this.scrollPosY - rowsEnd + rowsStart);
        }
        if (this.rowModel != null) {
            this.rowModel.remove(row, count);
        }
        if (this.dropMarkerRow >= row) {
            this.dropMarkerRow = this.dropMarkerRow < row + count ? -1 : (this.dropMarkerRow -= count);
        }
        if (!this.widgetGrid.isEmpty()) {
            this.widgetGrid.iterate(row, 0, row + count - 1, this.numColumns, this.removeCellWidgetsFunction);
            this.widgetGrid.removeRows(row, count);
        }
        if (this.selectionManager != null) {
            this.selectionManager.rowsDeleted(row, count);
        }
        this.invalidateLayout();
    }

    protected void modelColumnsInserted(int column, int count) {
        ScrollPane sp;
        this.checkColumnRange(column, count);
        ColumnHeader[] newColumnHeaders = new ColumnHeader[this.numColumns];
        System.arraycopy(this.columnHeaders, 0, newColumnHeaders, 0, column);
        System.arraycopy(this.columnHeaders, column, newColumnHeaders, column + count, this.numColumns - (column + count));
        for (int i = 0; i < count; ++i) {
            newColumnHeaders[column + i] = this.createColumnHeader(column + i);
        }
        this.columnHeaders = newColumnHeaders;
        this.updateColumnHeaderNumbers();
        this.columnModel.insert(column, count);
        if (!this.widgetGrid.isEmpty() || this.hasCellWidgetCreators) {
            this.removeAllCellWidgets();
            this.widgetGrid.insertColumns(column, count);
            for (int row = 0; row < this.numRows; ++row) {
                for (int i = 0; i < count; ++i) {
                    this.updateCellWidget(row, column + i);
                }
            }
        }
        if (column < this.getColumnStartPosition(this.scrollPosX) && (sp = ScrollPane.getContainingScrollPane(this)) != null) {
            int columnsStart = this.getColumnStartPosition(column);
            int columnsEnd = this.getColumnEndPosition(column + count - 1);
            sp.setScrollPositionX(this.scrollPosX + columnsEnd - columnsStart);
        }
        this.invalidateLayout();
    }

    protected void modelColumnsDeleted(int column, int count) {
        ScrollPane sp;
        if (column + count <= this.getColumnStartPosition(this.scrollPosX) && (sp = ScrollPane.getContainingScrollPane(this)) != null) {
            int columnsStart = this.getColumnStartPosition(column);
            int columnsEnd = this.getColumnEndPosition(column + count - 1);
            sp.setScrollPositionY(this.scrollPosX - columnsEnd + columnsStart);
        }
        this.columnModel.remove(column, count);
        if (!this.widgetGrid.isEmpty()) {
            this.widgetGrid.iterate(0, column, this.numRows, column + count - 1, this.removeCellWidgetsFunction);
            this.widgetGrid.removeColumns(column, count);
        }
        this.removeColumnHeaders(column, count);
        ColumnHeader[] newColumnHeaders = new ColumnHeader[this.numColumns];
        System.arraycopy(this.columnHeaders, 0, newColumnHeaders, 0, column);
        System.arraycopy(this.columnHeaders, column + count, newColumnHeaders, column, this.numColumns - count);
        this.columnHeaders = newColumnHeaders;
        this.updateColumnHeaderNumbers();
        this.invalidateLayout();
    }

    protected void modelColumnHeaderChanged(int column) {
        this.checkColumnIndex(column);
        this.updateColumnHeader(column);
    }

    public static class StringCellRenderer
    extends TextWidget
    implements CellRenderer {
        public StringCellRenderer() {
            this.setCache(false);
            this.setClip(true);
        }

        public void applyTheme(ThemeInfo themeInfo) {
            super.applyTheme(themeInfo);
        }

        public void setCellData(int row, int column, Object data) {
            this.setCharSequence(String.valueOf(data));
        }

        public int getColumnSpan() {
            return 1;
        }

        protected void sizeChanged() {
        }

        public Widget getCellRenderWidget(int x, int y, int width, int height, boolean isSelected) {
            this.setPosition(x, y);
            this.setSize(width, height);
            this.getAnimationState().setAnimationState(STATE_SELECTED, isSelected);
            return this;
        }
    }

    static class CellWidgetContainer
    extends Widget {
        CellWidgetContainer() {
            this.setTheme("");
            this.setClip(true);
        }

        protected void childInvalidateLayout(Widget child) {
        }

        protected void sizeChanged() {
        }

        protected void childAdded(Widget child) {
        }

        protected void childRemoved(Widget exChild) {
        }

        protected void allChildrenRemoved() {
        }
    }

    static class WidgetEntry
    extends SparseGrid.Entry {
        Widget widget;
        CellWidgetCreator creator;

        WidgetEntry() {
        }
    }

    protected class ColumnHeader
    extends Button
    implements Runnable {
        int column;
        private int columnWidth;
        int springWidth;
        final DialogLayout.Spring spring = new DialogLayout.Spring(){

            int getMinSize(int axis) {
                return TableBase.this.clampColumnWidth(ColumnHeader.this.getMinWidth());
            }

            int getPrefSize(int axis) {
                return ColumnHeader.this.getPreferredWidth();
            }

            int getMaxSize(int axis) {
                return ColumnHeader.this.getMaxWidth();
            }

            void setSize(int axis, int pos, int size) {
                ColumnHeader.this.springWidth = size;
            }
        };

        public ColumnHeader() {
            this.addCallback(this);
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        public void setColumnWidth(int columnWidth) {
            this.columnWidth = columnWidth;
        }

        public int getPreferredWidth() {
            if (this.columnWidth > 0) {
                return this.columnWidth;
            }
            DialogLayout.Gap mpm = TableBase.this.getColumnMPM(this.column);
            int prefWidth = mpm != null ? mpm.preferred : TableBase.this.defaultColumnWidth;
            return Math.max(prefWidth, super.getPreferredWidth());
        }

        public int getMinWidth() {
            DialogLayout.Gap mpm = TableBase.this.getColumnMPM(this.column);
            int minWidth = mpm != null ? mpm.min : 0;
            return Math.max(minWidth, super.getPreferredWidth());
        }

        public int getMaxWidth() {
            DialogLayout.Gap mpm = TableBase.this.getColumnMPM(this.column);
            int maxWidth = mpm != null ? mpm.max : Short.MAX_VALUE;
            return maxWidth;
        }

        public void adjustSize() {
        }

        protected boolean handleEvent(Event evt) {
            if (evt.isMouseEventNoWheel()) {
                TableBase.this.mouseLeftTableArea();
            }
            return super.handleEvent(evt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintWidget(GUI gui) {
            Renderer renderer = gui.getRenderer();
            renderer.clipEnter(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            try {
                this.paintLabelText(this.getAnimationState());
            }
            finally {
                renderer.clipLeave();
            }
        }

        public void run() {
            TableBase.this.columnHeaderClicked(this.column);
        }
    }

    class InsertCellWidgets
    implements SparseGrid.GridFunction {
        InsertCellWidgets() {
        }

        public void apply(int row, int column, SparseGrid.Entry e) {
            TableBase.this.insertCellWidget(row, column, (WidgetEntry)e);
        }
    }

    class RemoveCellWidgets
    implements SparseGrid.GridFunction {
        RemoveCellWidgets() {
        }

        public void apply(int row, int column, SparseGrid.Entry e) {
            WidgetEntry widgetEntry = (WidgetEntry)e;
            Widget widget = widgetEntry.widget;
            if (widget != null) {
                TableBase.this.removeCellWidget(widget);
            }
        }
    }

    protected class ColumnSizeSequence
    extends SizeSequence {
        protected ColumnSizeSequence() {
        }

        protected void initializeSizes(int index, int count) {
            boolean useSprings = TableBase.this.isFixedWidthMode();
            if (!useSprings) {
                int sum = 0;
                for (int i = 0; i < count; ++i) {
                    int width;
                    this.table[index + i] = width = TableBase.this.computePreferredColumnWidth(index + i);
                    sum += width;
                }
                boolean bl = useSprings = sum < TableBase.this.getInnerWidth();
            }
            if (useSprings) {
                this.computeColumnHeaderLayout();
                for (int i = 0; i < count; ++i) {
                    this.table[index + i] = TableBase.this.clampColumnWidth(TableBase.this.columnHeaders[i].springWidth);
                }
            }
        }

        protected boolean update(int index) {
            int width;
            if (TableBase.this.isFixedWidthMode()) {
                this.computeColumnHeaderLayout();
                width = TableBase.this.clampColumnWidth(TableBase.this.columnHeaders[index].springWidth);
            } else {
                width = TableBase.this.computePreferredColumnWidth(index);
                if (TableBase.this.ensureColumnHeaderMinWidth) {
                    width = Math.max(width, TableBase.this.columnHeaders[index].getMinWidth());
                }
            }
            return this.setSize(index, width);
        }

        void computeColumnHeaderLayout() {
            if (TableBase.this.columnHeaders != null) {
                DialogLayout.SequentialGroup g = (DialogLayout.SequentialGroup)new DialogLayout().createSequentialGroup();
                for (ColumnHeader h : TableBase.this.columnHeaders) {
                    g.addSpring(h.spring);
                }
                g.setSize(0, 0, TableBase.this.getInnerWidth());
            }
        }

        int computePreferredWidth() {
            int count = TableBase.this.getNumColumns();
            if (!TableBase.this.isFixedWidthMode()) {
                int sum = 0;
                for (int i = 0; i < count; ++i) {
                    int width = TableBase.this.computePreferredColumnWidth(i);
                    sum += width;
                }
                return sum;
            }
            if (TableBase.this.columnHeaders != null) {
                DialogLayout.SequentialGroup g = (DialogLayout.SequentialGroup)new DialogLayout().createSequentialGroup();
                for (ColumnHeader h : TableBase.this.columnHeaders) {
                    g.addSpring(h.spring);
                }
                return g.getPrefSize(0);
            }
            return 0;
        }
    }

    class RowSizeSequence
    extends SizeSequence {
        public RowSizeSequence(int initialCapacity) {
            super(initialCapacity);
        }

        protected void initializeSizes(int index, int count) {
            int i = 0;
            while (i < count) {
                this.table[index] = TableBase.this.computeRowHeight(index);
                ++i;
                ++index;
            }
        }
    }

    public static interface DragListener {
        public boolean dragStarted(int var1, int var2, Event var3);

        public MouseCursor dragged(Event var1);

        public void dragStopped(Event var1);

        public void dragCanceled();
    }

    public static interface KeyboardSearchHandler {
        public boolean handleKeyEvent(Event var1);

        public boolean isActive();

        public void updateInfoWindowPosition();
    }

    public static interface CellWidgetCreator
    extends CellRenderer {
        public Widget updateWidget(Widget var1);

        public void positionWidget(Widget var1, int var2, int var3, int var4, int var5);
    }

    public static interface CellRenderer {
        public void applyTheme(ThemeInfo var1);

        public String getTheme();

        public void setCellData(int var1, int var2, Object var3);

        public int getColumnSpan();

        public int getPreferredHeight();

        public Widget getCellRenderWidget(int var1, int var2, int var3, int var4, boolean var5);
    }

    public static interface Callback {
        public void mouseDoubleClicked(int var1, int var2);

        public void mouseRightClick(int var1, int var2, Event var3);

        public void columnHeaderClicked(int var1);
    }
}

