/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.utils.TintAnimator;

public class ResizableFrame
extends Widget {
    public static final AnimationState.StateKey STATE_FADE = AnimationState.StateKey.get("fade");
    private String title = "";
    private final MouseCursor[] cursors;
    private ResizableAxis resizableAxis = ResizableAxis.BOTH;
    private boolean draggable = true;
    private boolean backgroundDraggable;
    private DragMode dragMode = DragMode.NONE;
    private int dragStartX;
    private int dragStartY;
    private int dragInitialLeft;
    private int dragInitialTop;
    private int dragInitialRight;
    private int dragInitialBottom;
    private Color fadeColorInactive = Color.WHITE;
    private int fadeDurationActivate;
    private int fadeDurationDeactivate;
    private int fadeDurationShow;
    private int fadeDurationHide;
    private TextWidget titleWidget;
    private int titleAreaTop;
    private int titleAreaLeft;
    private int titleAreaRight;
    private int titleAreaBottom;
    private boolean hasCloseButton;
    private Button closeButton;
    private int closeButtonX;
    private int closeButtonY;
    private boolean hasResizeHandle;
    private Widget resizeHandle;
    private int resizeHandleX;
    private int resizeHandleY;
    private DragMode resizeHandleDragMode;

    public ResizableFrame() {
        this.cursors = new MouseCursor[DragMode.values().length];
        this.setCanAcceptKeyboardFocus(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.titleWidget != null) {
            this.titleWidget.setCharSequence(title);
        }
    }

    public ResizableAxis getResizableAxis() {
        return this.resizableAxis;
    }

    public void setResizableAxis(ResizableAxis resizableAxis) {
        if (resizableAxis == null) {
            throw new NullPointerException("resizableAxis");
        }
        this.resizableAxis = resizableAxis;
        if (this.resizeHandle != null) {
            this.layoutResizeHandle();
        }
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean movable) {
        this.draggable = movable;
    }

    public boolean isBackgroundDraggable() {
        return this.backgroundDraggable;
    }

    public void setBackgroundDraggable(boolean backgroundDraggable) {
        this.backgroundDraggable = backgroundDraggable;
    }

    public final boolean hasTitleBar() {
        return this.titleWidget != null && this.titleWidget.getParent() == this;
    }

    public void addCloseCallback(Runnable cb) {
        if (this.closeButton == null) {
            this.closeButton = new Button();
            this.closeButton.setTheme("closeButton");
            this.closeButton.setCanAcceptKeyboardFocus(false);
            this.add(this.closeButton);
            this.layoutCloseButton();
        }
        this.closeButton.setVisible(this.hasCloseButton);
        this.closeButton.addCallback(cb);
    }

    public void removeCloseCallback(Runnable cb) {
        if (this.closeButton != null) {
            this.closeButton.removeCallback(cb);
            this.closeButton.setVisible(this.closeButton.hasCallbacks());
        }
    }

    public int getFadeDurationActivate() {
        return this.fadeDurationActivate;
    }

    public int getFadeDurationDeactivate() {
        return this.fadeDurationDeactivate;
    }

    public int getFadeDurationHide() {
        return this.fadeDurationHide;
    }

    public int getFadeDurationShow() {
        return this.fadeDurationShow;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            TintAnimator tintAnimator = this.getTintAnimator();
            if (tintAnimator != null && tintAnimator.hasTint() || !super.isVisible()) {
                this.fadeTo(this.hasKeyboardFocus() ? Color.WHITE : this.fadeColorInactive, this.fadeDurationShow);
            }
        } else if (super.isVisible()) {
            this.fadeToHide(this.fadeDurationHide);
        }
    }

    public void setHardVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void applyThemeResizableFrame(ThemeInfo themeInfo) {
        for (DragMode m : DragMode.values()) {
            this.cursors[m.ordinal()] = themeInfo.getMouseCursor(m.cursorName);
        }
        this.titleAreaTop = themeInfo.getParameter("titleAreaTop", 0);
        this.titleAreaLeft = themeInfo.getParameter("titleAreaLeft", 0);
        this.titleAreaRight = themeInfo.getParameter("titleAreaRight", 0);
        this.titleAreaBottom = themeInfo.getParameter("titleAreaBottom", 0);
        this.closeButtonX = themeInfo.getParameter("closeButtonX", 0);
        this.closeButtonY = themeInfo.getParameter("closeButtonY", 0);
        this.hasCloseButton = themeInfo.getParameter("hasCloseButton", false);
        this.hasResizeHandle = themeInfo.getParameter("hasResizeHandle", false);
        this.resizeHandleX = themeInfo.getParameter("resizeHandleX", 0);
        this.resizeHandleY = themeInfo.getParameter("resizeHandleY", 0);
        this.fadeColorInactive = themeInfo.getParameter("fadeColorInactive", Color.WHITE);
        this.fadeDurationActivate = themeInfo.getParameter("fadeDurationActivate", 0);
        this.fadeDurationDeactivate = themeInfo.getParameter("fadeDurationDeactivate", 0);
        this.fadeDurationShow = themeInfo.getParameter("fadeDurationShow", 0);
        this.fadeDurationHide = themeInfo.getParameter("fadeDurationHide", 0);
        this.invalidateLayout();
        if (!(!super.isVisible() || this.hasKeyboardFocus() || this.getTintAnimator() == null && Color.WHITE.equals(this.fadeColorInactive))) {
            this.fadeTo(this.fadeColorInactive, 0);
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeResizableFrame(themeInfo);
    }

    protected void updateTintAnimation() {
        TintAnimator tintAnimator = this.getTintAnimator();
        tintAnimator.update();
        if (!tintAnimator.isFadeActive() && tintAnimator.isZeroAlpha()) {
            this.setHardVisible(false);
        }
    }

    protected void fadeTo(Color color, int duration) {
        this.allocateTint().fadeTo(color, duration);
        if (!super.isVisible() && color.getAlpha() != 0) {
            this.setHardVisible(true);
        }
    }

    protected void fadeToHide(int duration) {
        if (duration <= 0) {
            this.setHardVisible(false);
        } else {
            this.allocateTint().fadeToHide(duration);
        }
    }

    private TintAnimator allocateTint() {
        TintAnimator tintAnimator = this.getTintAnimator();
        if (tintAnimator == null) {
            tintAnimator = new TintAnimator(new TintAnimator.AnimationStateTimeSource(this.getAnimationState(), STATE_FADE));
            this.setTintAnimator(tintAnimator);
            if (!super.isVisible()) {
                tintAnimator.fadeToHide(0);
            }
        }
        return tintAnimator;
    }

    protected boolean isFrameElement(Widget widget) {
        return widget == this.titleWidget || widget == this.closeButton || widget == this.resizeHandle;
    }

    protected void layout() {
        int minWidth = this.getMinWidth();
        int minHeight = this.getMinHeight();
        if (this.getWidth() < minWidth || this.getHeight() < minHeight) {
            int width = Math.max(this.getWidth(), minWidth);
            int height = Math.max(this.getHeight(), minHeight);
            if (this.getParent() != null) {
                int x = Math.min(this.getX(), this.getParent().getInnerRight() - width);
                int y = Math.min(this.getY(), this.getParent().getInnerBottom() - height);
                this.setPosition(x, y);
            }
            this.setSize(width, height);
        }
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget child = this.getChild(i);
            if (this.isFrameElement(child)) continue;
            this.layoutChildFullInnerArea(child);
        }
        this.layoutTitle();
        this.layoutCloseButton();
        this.layoutResizeHandle();
    }

    protected void layoutTitle() {
        int titleX = this.getTitleX(this.titleAreaLeft);
        int titleY = this.getTitleY(this.titleAreaTop);
        int titleWidth = Math.max(0, this.getTitleX(this.titleAreaRight) - titleX);
        int titleHeight = Math.max(0, this.getTitleY(this.titleAreaBottom) - titleY);
        if (this.titleAreaLeft != this.titleAreaRight && this.titleAreaTop != this.titleAreaBottom) {
            if (this.titleWidget == null) {
                this.titleWidget = new TextWidget(this.getAnimationState());
                this.titleWidget.setTheme("title");
                this.titleWidget.setMouseCursor(this.cursors[DragMode.POSITION.ordinal()]);
                this.titleWidget.setCharSequence(this.title);
                this.titleWidget.setClip(true);
            }
            if (this.titleWidget.getParent() == null) {
                this.insertChild(this.titleWidget, 0);
            }
            this.titleWidget.setPosition(titleX, titleY);
            this.titleWidget.setSize(titleWidth, titleHeight);
        } else if (this.titleWidget != null && this.titleWidget.getParent() == this) {
            this.titleWidget.destroy();
            this.removeChild(this.titleWidget);
        }
    }

    protected void layoutCloseButton() {
        if (this.closeButton != null) {
            this.closeButton.adjustSize();
            this.closeButton.setPosition(this.getTitleX(this.closeButtonX), this.getTitleY(this.closeButtonY));
            this.closeButton.setVisible(this.closeButton.hasCallbacks() && this.hasCloseButton);
        }
    }

    protected void layoutResizeHandle() {
        if (this.hasResizeHandle && this.resizeHandle == null) {
            this.resizeHandle = new Widget(this.getAnimationState(), true);
            this.resizeHandle.setTheme("resizeHandle");
            super.insertChild(this.resizeHandle, 0);
        }
        if (this.resizeHandle != null) {
            this.resizeHandleDragMode = this.resizeHandleX > 0 ? (this.resizeHandleY > 0 ? DragMode.CORNER_TL : DragMode.CORNER_TR) : (this.resizeHandleY > 0 ? DragMode.CORNER_BL : DragMode.CORNER_BR);
            this.resizeHandle.adjustSize();
            this.resizeHandle.setPosition(this.getTitleX(this.resizeHandleX), this.getTitleY(this.resizeHandleY));
            this.resizeHandle.setVisible(this.hasResizeHandle && this.resizableAxis == ResizableAxis.BOTH);
        } else {
            this.resizeHandleDragMode = DragMode.NONE;
        }
    }

    protected void keyboardFocusGained() {
        this.fadeTo(Color.WHITE, this.fadeDurationActivate);
    }

    protected void keyboardFocusLost() {
        if (!this.hasOpenPopups() && super.isVisible()) {
            this.fadeTo(this.fadeColorInactive, this.fadeDurationDeactivate);
        }
    }

    public int getMinWidth() {
        int minWidth = super.getMinWidth();
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget child = this.getChild(i);
            if (this.isFrameElement(child)) continue;
            minWidth = Math.max(minWidth, child.getMinWidth() + this.getBorderHorizontal());
        }
        if (this.hasTitleBar() && this.titleAreaRight < 0) {
            minWidth = Math.max(minWidth, this.titleWidget.getPreferredWidth() + this.titleAreaLeft - this.titleAreaRight);
        }
        return minWidth;
    }

    public int getMinHeight() {
        int minHeight = super.getMinHeight();
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget child = this.getChild(i);
            if (this.isFrameElement(child)) continue;
            minHeight = Math.max(minHeight, child.getMinHeight() + this.getBorderVertical());
        }
        return minHeight;
    }

    public int getMaxWidth() {
        int maxWidth = super.getMaxWidth();
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            int aMaxWidth;
            Widget child = this.getChild(i);
            if (this.isFrameElement(child) || (aMaxWidth = child.getMaxWidth()) <= 0 || maxWidth != 0 && (aMaxWidth += this.getBorderHorizontal()) >= maxWidth) continue;
            maxWidth = aMaxWidth;
        }
        return maxWidth;
    }

    public int getMaxHeight() {
        int maxHeight = super.getMaxHeight();
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            int aMaxHeight;
            Widget child = this.getChild(i);
            if (this.isFrameElement(child) || (aMaxHeight = child.getMaxHeight()) <= 0 || maxHeight != 0 && (aMaxHeight += this.getBorderVertical()) >= maxHeight) continue;
            maxHeight = aMaxHeight;
        }
        return maxHeight;
    }

    public int getPreferredInnerWidth() {
        int prefWidth = 0;
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget child = this.getChild(i);
            if (this.isFrameElement(child)) continue;
            prefWidth = Math.max(prefWidth, child.getPreferredWidth());
        }
        return prefWidth;
    }

    public int getPreferredWidth() {
        int prefWidth = super.getPreferredWidth();
        if (this.hasTitleBar() && this.titleAreaRight < 0) {
            prefWidth = Math.max(prefWidth, this.titleWidget.getPreferredWidth() + this.titleAreaLeft - this.titleAreaRight);
        }
        return prefWidth;
    }

    public int getPreferredInnerHeight() {
        int prefHeight = 0;
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget child = this.getChild(i);
            if (this.isFrameElement(child)) continue;
            prefHeight = Math.max(prefHeight, child.getPreferredHeight());
        }
        return prefHeight;
    }

    public void adjustSize() {
        this.layoutTitle();
        super.adjustSize();
    }

    private int getTitleX(int offset) {
        return offset < 0 ? this.getRight() + offset : this.getX() + offset;
    }

    private int getTitleY(int offset) {
        return offset < 0 ? this.getBottom() + offset : this.getY() + offset;
    }

    protected boolean handleEvent(Event evt) {
        boolean isMouseExit;
        boolean bl = isMouseExit = evt.getType() == Event.Type.MOUSE_EXITED;
        if (isMouseExit && this.resizeHandle != null && this.resizeHandle.isVisible()) {
            this.resizeHandle.getAnimationState().setAnimationState(TextWidget.STATE_HOVER, false);
        }
        if (this.dragMode != DragMode.NONE) {
            if (evt.isMouseDragEnd()) {
                this.dragMode = DragMode.NONE;
            } else if (evt.getType() == Event.Type.MOUSE_DRAGGED) {
                this.handleMouseDrag(evt);
            }
            return true;
        }
        if (!isMouseExit && this.resizeHandle != null && this.resizeHandle.isVisible()) {
            this.resizeHandle.getAnimationState().setAnimationState(TextWidget.STATE_HOVER, this.resizeHandle.isMouseInside(evt));
        }
        if (!evt.isMouseDragEvent() && evt.getType() == Event.Type.MOUSE_BTNDOWN && evt.getMouseButton() == 0 && this.handleMouseDown(evt)) {
            return true;
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        return evt.isMouseEvent();
    }

    public MouseCursor getMouseCursor(Event evt) {
        DragMode cursorMode = this.dragMode;
        if (cursorMode == DragMode.NONE && (cursorMode = this.getDragMode(evt.getMouseX(), evt.getMouseY())) == DragMode.NONE) {
            return this.getMouseCursor();
        }
        return this.cursors[cursorMode.ordinal()];
    }

    private DragMode getDragMode(int mx, int my) {
        boolean bot;
        boolean left = mx < this.getInnerX();
        boolean right = mx >= this.getInnerRight();
        boolean top = my < this.getInnerY();
        boolean bl = bot = my >= this.getInnerBottom();
        if (this.hasTitleBar()) {
            if (this.titleWidget.isInside(mx, my)) {
                if (this.draggable) {
                    return DragMode.POSITION;
                }
                return DragMode.NONE;
            }
            boolean bl2 = top = my < this.titleWidget.getY();
        }
        if (this.closeButton != null && this.closeButton.isVisible() && this.closeButton.isInside(mx, my)) {
            return DragMode.NONE;
        }
        if (this.resizableAxis == ResizableAxis.NONE) {
            if (this.backgroundDraggable) {
                return DragMode.POSITION;
            }
            return DragMode.NONE;
        }
        if (this.resizeHandle != null && this.resizeHandle.isVisible() && this.resizeHandle.isInside(mx, my)) {
            return this.resizeHandleDragMode;
        }
        if (!this.resizableAxis.allowX) {
            left = false;
            right = false;
        }
        if (!this.resizableAxis.allowY) {
            top = false;
            bot = false;
        }
        if (left) {
            if (top) {
                return DragMode.CORNER_TL;
            }
            if (bot) {
                return DragMode.CORNER_BL;
            }
            return DragMode.EDGE_LEFT;
        }
        if (right) {
            if (top) {
                return DragMode.CORNER_TR;
            }
            if (bot) {
                return DragMode.CORNER_BR;
            }
            return DragMode.EDGE_RIGHT;
        }
        if (top) {
            return DragMode.EDGE_TOP;
        }
        if (bot) {
            return DragMode.EDGE_BOTTOM;
        }
        if (this.backgroundDraggable) {
            return DragMode.POSITION;
        }
        return DragMode.NONE;
    }

    private boolean handleMouseDown(Event evt) {
        int mx = evt.getMouseX();
        int my = evt.getMouseY();
        this.dragStartX = mx;
        this.dragStartY = my;
        this.dragInitialLeft = this.getX();
        this.dragInitialTop = this.getY();
        this.dragInitialRight = this.getRight();
        this.dragInitialBottom = this.getBottom();
        this.dragMode = this.getDragMode(mx, my);
        return this.dragMode != DragMode.NONE;
    }

    private void handleMouseDrag(Event evt) {
        int dx = evt.getMouseX() - this.dragStartX;
        int dy = evt.getMouseY() - this.dragStartY;
        int minWidth = this.getMinWidth();
        int minHeight = this.getMinHeight();
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        if (maxWidth > 0 && maxWidth < minWidth) {
            maxWidth = minWidth;
        }
        if (maxHeight > 0 && maxHeight < minHeight) {
            maxHeight = minHeight;
        }
        int left = this.dragInitialLeft;
        int top = this.dragInitialTop;
        int right = this.dragInitialRight;
        int bottom = this.dragInitialBottom;
        switch (this.dragMode) {
            case CORNER_BL: 
            case CORNER_TL: 
            case EDGE_LEFT: {
                left = Math.min(left + dx, right - minWidth);
                if (maxWidth <= 0) break;
                left = Math.max(left, Math.min(this.dragInitialLeft, right - maxWidth));
                break;
            }
            case CORNER_BR: 
            case CORNER_TR: 
            case EDGE_RIGHT: {
                right = Math.max(right + dx, left + minWidth);
                if (maxWidth <= 0) break;
                right = Math.min(right, Math.max(this.dragInitialRight, left + maxWidth));
                break;
            }
            case POSITION: {
                if (this.getParent() != null) {
                    int minX = this.getParent().getInnerX();
                    int maxX = this.getParent().getInnerRight();
                    int width = this.dragInitialRight - this.dragInitialLeft;
                    left = Math.max(minX, Math.min(maxX - width, left + dx));
                    right = Math.min(maxX, Math.max(minX + width, right + dx));
                    break;
                }
                left += dx;
                right += dx;
            }
        }
        switch (this.dragMode) {
            case CORNER_TL: 
            case CORNER_TR: 
            case EDGE_TOP: {
                top = Math.min(top + dy, bottom - minHeight);
                if (maxHeight <= 0) break;
                top = Math.max(top, Math.min(this.dragInitialTop, bottom - maxHeight));
                break;
            }
            case CORNER_BL: 
            case CORNER_BR: 
            case EDGE_BOTTOM: {
                bottom = Math.max(bottom + dy, top + minHeight);
                if (maxHeight <= 0) break;
                bottom = Math.min(bottom, Math.max(this.dragInitialBottom, top + maxHeight));
                break;
            }
            case POSITION: {
                if (this.getParent() != null) {
                    int minY = this.getParent().getInnerY();
                    int maxY = this.getParent().getInnerBottom();
                    int height = this.dragInitialBottom - this.dragInitialTop;
                    top = Math.max(minY, Math.min(maxY - height, top + dy));
                    bottom = Math.min(maxY, Math.max(minY + height, bottom + dy));
                    break;
                }
                top += dy;
                bottom += dy;
            }
        }
        this.setArea(top, left, right, bottom);
    }

    private void setArea(int top, int left, int right, int bottom) {
        Widget p = this.getParent();
        if (p != null) {
            top = Math.max(top, p.getInnerY());
            left = Math.max(left, p.getInnerX());
            right = Math.min(right, p.getInnerRight());
            bottom = Math.min(bottom, p.getInnerBottom());
        }
        this.setPosition(left, top);
        this.setSize(Math.max(this.getMinWidth(), right - left), Math.max(this.getMinHeight(), bottom - top));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DragMode {
        NONE("mouseCursor"),
        EDGE_LEFT("mouseCursor.left"),
        EDGE_TOP("mouseCursor.top"),
        EDGE_RIGHT("mouseCursor.right"),
        EDGE_BOTTOM("mouseCursor.bottom"),
        CORNER_TL("mouseCursor.top-left"),
        CORNER_TR("mouseCursor.top-right"),
        CORNER_BR("mouseCursor.bottom-right"),
        CORNER_BL("mouseCursor.bottom-left"),
        POSITION("mouseCursor.all");

        final String cursorName;

        private DragMode(String cursorName) {
            this.cursorName = cursorName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResizableAxis {
        NONE(false, false),
        HORIZONTAL(true, false),
        VERTICAL(false, true),
        BOTH(true, true);

        final boolean allowX;
        final boolean allowY;

        private ResizableAxis(boolean allowX, boolean allowY) {
            this.allowX = allowX;
            this.allowY = allowY;
        }
    }
}

