/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;

public abstract class ComboBoxBase
extends Widget {
    public static final AnimationState.StateKey STATE_COMBOBOX_KEYBOARD_FOCUS = AnimationState.StateKey.get("comboboxKeyboardFocus");
    protected final Button button = new Button(this.getAnimationState());
    protected final PopupWindow popup = new PopupWindow(this){

        protected void escapePressed(Event evt) {
            ComboBoxBase.this.popupEscapePressed(evt);
        }
    };

    protected ComboBoxBase() {
        this.button.addCallback(new Runnable(){

            public void run() {
                ComboBoxBase.this.openPopup();
            }
        });
        this.add(this.button);
        this.setCanAcceptKeyboardFocus(true);
        this.setDepthFocusTraversal(false);
    }

    protected abstract Widget getLabel();

    protected boolean openPopup() {
        if (this.popup.openPopup()) {
            this.setPopupSize();
            return true;
        }
        return false;
    }

    public int getPreferredInnerWidth() {
        return this.getLabel().getPreferredWidth() + this.button.getPreferredWidth();
    }

    public int getPreferredInnerHeight() {
        return Math.max(this.getLabel().getPreferredHeight(), this.button.getPreferredHeight());
    }

    public int getMinWidth() {
        int minWidth = super.getMinWidth();
        minWidth = Math.max(minWidth, this.getLabel().getMinWidth() + this.button.getMinWidth());
        return minWidth;
    }

    public int getMinHeight() {
        int minInnerHeight = Math.max(this.getLabel().getMinHeight(), this.button.getMinHeight());
        return Math.max(super.getMinHeight(), minInnerHeight + this.getBorderVertical());
    }

    protected void setPopupSize() {
        int minHeight = this.popup.getMinHeight();
        int popupHeight = ComboBoxBase.computeSize(minHeight, this.popup.getPreferredHeight(), this.popup.getMaxHeight());
        int popupMaxBottom = this.popup.getParent().getInnerBottom();
        if (this.getBottom() + minHeight > popupMaxBottom) {
            if (this.getY() - popupHeight >= this.popup.getParent().getInnerY()) {
                this.popup.setPosition(this.getX(), this.getY() - popupHeight);
            } else {
                this.popup.setPosition(this.getX(), popupMaxBottom - minHeight);
            }
        } else {
            this.popup.setPosition(this.getX(), this.getBottom());
        }
        popupHeight = Math.min(popupHeight, popupMaxBottom - this.popup.getY());
        this.popup.setSize(this.getWidth(), popupHeight);
    }

    protected void layout() {
        int btnWidth = this.button.getPreferredWidth();
        int innerHeight = this.getInnerHeight();
        int innerX = this.getInnerX();
        int innerY = this.getInnerY();
        this.button.setPosition(this.getInnerRight() - btnWidth, innerY);
        this.button.setSize(btnWidth, innerHeight);
        this.getLabel().setPosition(innerX, innerY);
        this.getLabel().setSize(Math.max(0, this.button.getX() - innerX), innerHeight);
    }

    protected void sizeChanged() {
        super.sizeChanged();
        if (this.popup.isOpen()) {
            this.setPopupSize();
        }
    }

    private static void setRecursive(Widget w, AnimationState.StateKey what, boolean state) {
        w.getAnimationState().setAnimationState(what, state);
        for (int i = 0; i < w.getNumChildren(); ++i) {
            Widget child = w.getChild(i);
            ComboBoxBase.setRecursive(child, what, state);
        }
    }

    protected void keyboardFocusGained() {
        super.keyboardFocusGained();
        ComboBoxBase.setRecursive(this.getLabel(), STATE_COMBOBOX_KEYBOARD_FOCUS, true);
    }

    protected void keyboardFocusLost() {
        super.keyboardFocusLost();
        ComboBoxBase.setRecursive(this.getLabel(), STATE_COMBOBOX_KEYBOARD_FOCUS, false);
    }

    protected void popupEscapePressed(Event evt) {
        this.popup.closePopup();
    }
}

