/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.ActionMap;
import de.matthiasmann.twl.Widget;

public final class ActionCallback
implements Runnable {
    private final Widget widget;
    private final ActionMap actionMap;
    private final String action;

    public ActionCallback(Widget widget, String action) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.widget = widget;
        this.actionMap = null;
        this.action = action;
    }

    public ActionCallback(ActionMap actionMap, String action) {
        if (actionMap == null) {
            throw new NullPointerException("actionMap");
        }
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.widget = null;
        this.actionMap = actionMap;
        this.action = action;
    }

    public void run() {
        ActionMap am = this.actionMap;
        if (am == null && (am = this.widget.getActionMap()) == null) {
            return;
        }
        am.invokeDirect(this.action);
    }
}

