/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractNumberSetting;

public class LongSetting
extends AbstractNumberSetting<Long> {
    private long value;

    LongSetting(Properties defaultProps, Properties props, String key, long defaultLong) {
        super(defaultProps, props, key, String.valueOf(defaultLong), false, null, null);
    }

    LongSetting(Properties defaultProps, Properties props, String key, long defaultLong, long min, long max) {
        super(defaultProps, props, key, String.valueOf(defaultLong), true, new Long(min), new Long(max));
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.setValueInternal(String.valueOf(value));
    }

    @Override
    protected void loadValue(String sValue) {
        try {
            this.value = Long.parseLong(sValue.trim());
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    @Override
    protected Comparable<Long> convertToComparable(String value) {
        return new Long(value);
    }
}

