/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class IntSetSetting
extends AbstractSetting {
    private Set<Integer> value;

    IntSetSetting(Properties defaultProps, Properties props, String key, Integer[] defaultValue) {
        super(defaultProps, props, key, IntSetSetting.decode(new HashSet<Integer>(Arrays.asList(defaultValue))));
        this.setPrivate(true);
    }

    public Set<Integer> getValue() {
        return this.value;
    }

    public synchronized Integer[] getValueAsArray() {
        return this.value.toArray(new Integer[this.value.size()]);
    }

    public void setValue(Set<? extends Integer> value) {
        this.setValueInternal(IntSetSetting.decode(value));
    }

    public synchronized void add(Integer i) {
        this.value.add(i);
        this.setValue(this.value);
    }

    public synchronized boolean remove(Integer i) {
        if (this.value.remove(i)) {
            this.setValue(this.value);
            return true;
        }
        return false;
    }

    public synchronized boolean contains(Integer i) {
        return this.value.contains(i);
    }

    public synchronized int length() {
        return this.value.size();
    }

    @Override
    protected synchronized void loadValue(String sValue) {
        this.value = IntSetSetting.encode(sValue);
    }

    private static final Set<Integer> encode(String src) {
        if (src == null || src.length() == 0) {
            return new HashSet<Integer>();
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        int size = tokenizer.countTokens();
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            set.add(new Integer(tokenizer.nextToken()));
        }
        return set;
    }

    private static final String decode(Set<? extends Integer> src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (Integer n : src) {
            buffer.append(n.toString()).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

