/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public abstract class AbstractNumberSetting<T extends Number>
extends AbstractSetting {
    protected final T MAX_VALUE;
    protected final T MIN_VALUE;
    private final boolean remote;

    protected AbstractNumberSetting(Properties defaultProps, Properties props, String key, String defaultValue, boolean remote, T min, T max) {
        super(defaultProps, props, key, defaultValue);
        this.remote = remote;
        if (max != null && min != null && ((Comparable)max).compareTo(min) < 0) {
            throw new IllegalArgumentException("max less than min");
        }
        this.MAX_VALUE = max;
        this.MIN_VALUE = min;
        this.setValueInternal(this.getValueAsString());
    }

    @Override
    protected void setValueInternal(String value) {
        if (this.remote) {
            assert (this.MAX_VALUE != null) : "remote setting created with no max";
            assert (this.MIN_VALUE != null) : "remote setting created with no min";
        }
        value = this.normalizeValue(value);
        super.setValueInternal(value);
    }

    protected String normalizeValue(String value) {
        Comparable<T> comparableValue = null;
        try {
            comparableValue = this.convertToComparable(value);
        }
        catch (NumberFormatException e) {
            return this.DEFAULT_VALUE;
        }
        if (this.MAX_VALUE != null && comparableValue.compareTo(this.MAX_VALUE) > 0) {
            return this.MAX_VALUE.toString();
        }
        if (this.MIN_VALUE != null && comparableValue.compareTo(this.MIN_VALUE) < 0) {
            return this.MIN_VALUE.toString();
        }
        return value;
    }

    protected abstract Comparable<T> convertToComparable(String var1);
}

