/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagRawBinaryField
extends Mp4TagField {
    protected int dataSize;
    protected byte[] dataBytes;

    public Mp4TagRawBinaryField(Mp4BoxHeader header, ByteBuffer raw) throws UnsupportedEncodingException {
        super(header.getId());
        this.dataSize = header.getDataLength();
        this.build(raw);
    }

    @Override
    public Mp4FieldType getFieldType() {
        return Mp4FieldType.IMPLICIT;
    }

    @Override
    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.dataBytes;
    }

    @Override
    protected void build(ByteBuffer raw) {
        this.dataBytes = new byte[this.dataSize];
        for (int i = 0; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = raw.get();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.dataBytes.length == 0;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public byte[] getData() {
        return this.dataBytes;
    }

    public void setData(byte[] d) {
        this.dataBytes = d;
    }

    @Override
    public void copyContent(TagField field) {
        throw new UnsupportedOperationException("not done");
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream outerbaos = new ByteArrayOutputStream();
            outerbaos.write(Utils.getSizeBEInt32(8 + this.dataSize));
            outerbaos.write(this.getId().getBytes(StandardCharsets.ISO_8859_1));
            outerbaos.write(this.dataBytes);
            return outerbaos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

