/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.reference;

import org.jaudiotagger.tag.id3.reference.ID3Rating;

public class MediaPlayerRating
extends ID3Rating {
    private static ID3Rating rating = null;

    private MediaPlayerRating() {
    }

    @Override
    public int convertRatingFromFiveStarScale(int value) {
        if (value < 0 || value > 5) {
            throw new IllegalArgumentException("convert Ratings from Five Star Scale accepts values from 0 to 5 not:" + value);
        }
        int newValue = 0;
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                newValue = 1;
                break;
            }
            case 2: {
                newValue = 64;
                break;
            }
            case 3: {
                newValue = 128;
                break;
            }
            case 4: {
                newValue = 196;
                break;
            }
            case 5: {
                newValue = 255;
            }
        }
        return newValue;
    }

    @Override
    public int convertRatingToFiveStarScale(int value) {
        int newValue = 0;
        newValue = value <= 0 ? 0 : (value <= 1 ? 1 : (value <= 64 ? 2 : (value <= 128 ? 3 : (value <= 196 ? 4 : 5))));
        return newValue;
    }

    public static ID3Rating getInstance() {
        if (rating == null) {
            rating = new MediaPlayerRating();
        }
        return rating;
    }
}

