/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.chunk;

import java.util.HashMap;
import java.util.Map;
import org.jaudiotagger.tag.FieldKey;

public enum WavInfoIdentifier {
    ARTIST("IART", FieldKey.ARTIST),
    ALBUM_ARTIST("iaar", FieldKey.ALBUM_ARTIST),
    TITLE("INAM", FieldKey.TITLE),
    ALBUM("IPRD", FieldKey.ALBUM),
    TRACKNO("ITRK", FieldKey.TRACK),
    YEAR("ICRD", FieldKey.YEAR),
    GENRE("IGNR", FieldKey.GENRE),
    COMMENTS("ICMT", FieldKey.COMMENT),
    COPYRIGHT("ICOP", null),
    ENCODER("ISFT", FieldKey.ENCODER),
    RATING("IRTD", FieldKey.RATING),
    COMPOSER("IMUS", FieldKey.COMPOSER),
    CONDUCTOR("ITCH", FieldKey.CONDUCTOR),
    LYRICIST("IWRI", FieldKey.LYRICIST),
    ISRC("ISRC", FieldKey.ISRC),
    LABEL("ICMS", FieldKey.RECORD_LABEL),
    TRACK_GAIN("ITGL", null),
    ALBUM_GAIN("IAGL", null);

    private static final Map<String, WavInfoIdentifier> CODE_TYPE_MAP;
    private static final Map<FieldKey, WavInfoIdentifier> FIELDKEY_TYPE_MAP;
    private String code;
    private FieldKey fieldKey;

    private WavInfoIdentifier(String code, FieldKey fieldKey) {
        this.code = code;
        this.fieldKey = fieldKey;
    }

    public String getCode() {
        return this.code;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public static synchronized WavInfoIdentifier getByCode(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (WavInfoIdentifier type : WavInfoIdentifier.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public static synchronized WavInfoIdentifier getByByFieldKey(FieldKey fieldKey) {
        if (FIELDKEY_TYPE_MAP.isEmpty()) {
            for (WavInfoIdentifier type : WavInfoIdentifier.values()) {
                if (type.getFieldKey() == null) continue;
                FIELDKEY_TYPE_MAP.put(type.getFieldKey(), type);
            }
        }
        return FIELDKEY_TYPE_MAP.get((Object)fieldKey);
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, WavInfoIdentifier>();
        FIELDKEY_TYPE_MAP = new HashMap<FieldKey, WavInfoIdentifier>();
    }
}

